/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "ellipsetoolwidget.h"

#include "mq3macro.h"
#include "mq3compat.h"

#include <qlayout.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <math.h>

#include "3dmprefs.h"

EllipsoidToolWidget::EllipsoidToolWidget( Observer * observer, QWidget * parent )
   : QDockWindow ( QDockWindow::InDock, parent, "", WDestructiveClose ),
     m_observer( observer )
{
   const int  DEFAULT_SMOOTHNESS = 2;
   const bool DEFAULT_SPHERE     = false;

   m_layout = boxLayout();

   m_smoothLabel = new QLabel( "Smoothness:", this, "" );
   m_layout->addWidget( m_smoothLabel );
   m_smoothValue = new QSpinBox( this, "" );
   m_layout->addWidget( m_smoothValue );

   m_smoothValue->setMinValue( 0 );
   m_smoothValue->setMaxValue( 5 );

   m_facesLabel = new QLabel( "Faces: 320", this, "" );
   m_layout->addWidget( m_facesLabel );

   m_sphereCheckBox = new QCheckBox( "Sphere", this, "" );
   m_layout->addWidget( m_sphereCheckBox );

   int smoothVal = DEFAULT_SMOOTHNESS;
   if ( g_prefs.exists( "ui_ellipsetool_smoothness" ) )
   {
      int val = g_prefs( "ui_ellipsetool_smoothness" ).intValue();
      if ( val >= 0 && val <= 5 )
      {
         smoothVal = val;
      }
   }

   m_smoothValue->setValue( smoothVal );

   bool isSphere = DEFAULT_SPHERE;
   if ( g_prefs.exists( "ui_ellipsetool_issphere" ) )
   {
      isSphere = (g_prefs( "ui_ellipsetool_issphere" ).intValue() != 0) ? true : false;
   }

   m_sphereCheckBox->setChecked( isSphere );

   connect( m_smoothValue,    SIGNAL(valueChanged(int)), this, SLOT(smoothnessValueChanged(int))      );
   connect( m_sphereCheckBox, SIGNAL(toggled(bool)),     this, SLOT(sphereCheckBoxValueChanged(bool)) );

   m_smoothLabel->show();
   m_smoothValue->show();
   m_facesLabel->show();
   m_sphereCheckBox->show();

   smoothnessValueChanged( smoothVal );
   sphereCheckBoxValueChanged( isSphere );
}

EllipsoidToolWidget::~EllipsoidToolWidget()
{
}

void EllipsoidToolWidget::smoothnessValueChanged( int newValue )
{
   QString str;
   str.sprintf( "Faces: %d", 20 * (unsigned) pow(4, newValue) );
   m_facesLabel->setText( str );

   g_prefs( "ui_ellipsetool_smoothness" ) = newValue;
   m_observer->setSmoothnessValue( newValue );
}

void EllipsoidToolWidget::sphereCheckBoxValueChanged( bool o )
{
   g_prefs( "ui_ellipsetool_issphere" ) = o ? 1 : 0;
   m_observer->setSphere( o );
}
