/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "assignjointcmd.h"

#include "jointwin.h"
#include "model.h"
#include "modelstatus.h"
#include "log.h"

#include <list>

AssignJointCommand::AssignJointCommand()
{
}

AssignJointCommand::~AssignJointCommand()
{
}

bool AssignJointCommand::activated( int arg, Model * model )
{
   std::list<int> j = model->getSelectedBoneJoints();

   if ( j.size() == 1 )
   {
      unsigned int joint = j.front();
      list<int> vertlist = model->getSelectedVertices();
      list<int>::iterator it;
      log_debug( "assigning %d vertices to joint %d\n", vertlist.size(), joint );
      model_status( model, StatusNormal, STATUSTIME_SHORT, "assigning %d vertices to joint %d\n", vertlist.size(), joint );
      for ( it = vertlist.begin(); it != vertlist.end(); it++ )
      {
         model->setVertexBoneJoint( *it, joint );
      }
   }
   else
   {
      model_status( model, StatusError, STATUSTIME_LONG, "You must have exactly 1 bone joint selected." );
      JointWin * win = new JointWin( model );  
      win->show();
   }
   return true;
}

bool AssignJointCommand::getKeyBinding( int arg, int & keyBinding )
{
   keyBinding = Qt::CTRL + Qt::Key_B;
   return true;
}


