/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __EDITKEYFRAME_H
#define __EDITKEYFRAME_H

#include "editkeyframe.base.h"

class Model;

class EditKeyframeWin : public EditKeyframeBase
{
   Q_OBJECT

   public:
      EditKeyframeWin( Model * model, const unsigned & anim, const unsigned & frame, 
            const unsigned & joint, const bool & rotation, 
            QWidget * parent = NULL, const char * name = "" );
      virtual ~EditKeyframeWin();

   public slots:
      virtual void dataChanged();
      virtual void accept();
      virtual void reject();

   protected:
      Model    * m_model;
      unsigned   m_anim;
      unsigned   m_frame;
      unsigned   m_joint;
      bool       m_rotation;
};

#endif // __EDITKEYFRAME_H
