/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#ifndef __ANIMCONVERTWIN_H
#define __ANIMCONVERTWIN_H

#include "animconvertwin.base.h"

#include "model.h"

#include "mq3macro.h"

class QAccel;

class AnimConvertWindow : public AnimConvertWinBase
{
   Q_OBJECT

   public:
      typedef enum Operation_e
      {
         OP_CONTINUE,
         OP_CANCEL,
         OP_CANCEL_ALL
      } Operation;

      AnimConvertWindow( QWidget * parent = NULL, const char * name = "" );
      virtual ~AnimConvertWindow();

      void setAnimationData( Model * model, Model::AnimationMode mode, unsigned animIndex );

      QString getNewName();
      unsigned getNewFrameCount();

      Operation requestedOperation();

   public slots:
      void helpNowEvent( int );

      void continueClicked();
      void cancelClicked();
      void cancelAllClicked();

   protected:
      QAccel * m_accel;

      Operation m_operation;
};

#endif // __ANIMCONVERTWIN_H
