#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h> /* memset */
#include <math.h> /* sqrt */
#include <mx/gl.h>
#include "md2.h"

#define NUMVERTEXNORMALS 162
#define MAX_TRIANGLES 4096

float md2_avertexnormals[NUMVERTEXNORMALS][3] = {
#include "anorms.h"
};

//glcmds related
int	commands[65536];
int numcommands, numglverts;
int	used[MAX_TRIANGLES];
int	strip_xyz[128];
int	strip_st[128];
int	strip_tris[128];
int	stripcount;
int FanLength (int starttri, int startv, md2_model_t *md2);
int StripLength (int starttri, int startv, md2_model_t *md2);
void BuildGlCmds(md2_model_t *md2);

//

/*
 * load model
 */
#if 0
md2_model_t* md2_readModel (const char *filename)
{
	FILE *file;
	md2_model_t *model;
	byte buffer[MD2_MAX_FRAMESIZE];
	int i;

	model = (md2_model_t *) malloc (sizeof (md2_model_t));
	if (!model)
		return 0;

	file = fopen (filename, "rb");
	if (!file)
	{
		free (model);
		return 0;
	}

	/* initialize model and read header */
	memset (model, 0, sizeof (md2_model_t));
	fread (&model->header, sizeof (md2_header_t), 1, file);

	if (model->header.magic != (int) (('2' << 24) + ('P' << 16) + ('D' << 8) + 'I'))
	{
		fclose (file);
		free (model);
		return 0;
	}

	/* read skins */
	fseek (file, model->header.offsetSkins, SEEK_SET);
	if (model->header.numSkins > 0)
	{
		model->skins = (md2_skin_t *) malloc (sizeof (md2_skin_t) * model->header.numSkins);
		if (!model->skins)
		{
			md2_freeModel (model);
			return 0;
		}

		for (i = 0; i < model->header.numSkins; i++)
			fread (&model->skins[i], sizeof (md2_skin_t), 1, file);
	}

	/* read texture coordinates */
	fseek (file, model->header.offsetTexCoords, SEEK_SET);
	if (model->header.numTexCoords > 0)
	{
		model->texCoords = (md2_textureCoordinate_t *) malloc (sizeof (md2_textureCoordinate_t) * model->header.numTexCoords);
		if (!model->texCoords)
		{
			md2_freeModel (model);
			return 0;
		}

		for (i = 0; i < model->header.numTexCoords; i++)
			fread (&model->texCoords[i], sizeof (md2_textureCoordinate_t), 1, file);
	}

	/* read triangles */
	fseek (file, model->header.offsetTriangles, SEEK_SET);
	if (model->header.numTriangles > 0)
	{
		model->triangles = (md2_triangle_t *) malloc (sizeof (md2_triangle_t) * model->header.numTriangles);
		if (!model->triangles)
		{
			md2_freeModel (model);
			return 0;
		}

		for (i = 0; i < model->header.numTriangles; i++)
			fread (&model->triangles[i], sizeof (md2_triangle_t), 1, file);
	}

	/* read alias frames */
	fseek (file, model->header.offsetFrames, SEEK_SET);
	if (model->header.numFrames > 0)
	{
		model->frames = (md2_frame_t *) malloc (sizeof (md2_frame_t) * model->header.numFrames);
		if (!model->frames)
		{
			md2_freeModel (model);
			return 0;
		}

		for (i = 0; i < model->header.numFrames; i++)
		{
			md2_alias_frame_t *frame = (md2_alias_frame_t *) buffer;
			int j;

			model->frames[i].vertices = (md2_triangleVertex_t *) malloc (sizeof (md2_triangleVertex_t) * model->header.numVertices);
			if (!model->frames[i].vertices)
			{
				md2_freeModel (model);
				return 0;
			}

			fread (frame, 1, model->header.frameSize, file);
			strcpy_s (model->frames[i].name, sizeof(model->frames[i].name), frame->name);
			for (j = 0; j < model->header.numVertices; j++)
			{
				model->frames[i].vertices[j].vertex[0] = (float) ((int) frame->alias_vertices[j].vertex[0]) * frame->scale[0] + frame->translate[0];
				model->frames[i].vertices[j].vertex[2] = -1* ((float) ((int) frame->alias_vertices[j].vertex[1]) * frame->scale[1] + frame->translate[1]);
				model->frames[i].vertices[j].vertex[1] = (float) ((int) frame->alias_vertices[j].vertex[2]) * frame->scale[2] + frame->translate[2];

				model->frames[i].vertices[j].normal[0] = md2_avertexnormals[frame->alias_vertices[j].lightNormalIndex][0];
				model->frames[i].vertices[j].normal[1] = md2_avertexnormals[frame->alias_vertices[j].lightNormalIndex][1];
				model->frames[i].vertices[j].normal[2] = md2_avertexnormals[frame->alias_vertices[j].lightNormalIndex][2];
			}
		}
	}

	/* read gl commands */
	fseek (file, model->header.offsetGlCommands, SEEK_SET);
	if (model->header.numGlCommands)
	{
		model->glCommandBuffer = (int *) malloc (sizeof (int) * model->header.numGlCommands);
		if (!model->glCommandBuffer)
		{
			md2_freeModel (model);
			return 0;
		}

		fread (model->glCommandBuffer, sizeof (int), model->header.numGlCommands, file);
	}

	fclose (file);

	return model;
}
#endif


/*
 * free model
 */
void
md2_freeModel (md2_model_t *model)
{
	if (model)
	{
		if (model->skins)
			free (model->skins);

		if (model->texCoords)
			free (model->texCoords);

		if (model->triangles)
		{
			free (model->triangles);
		}

		if (model->frames)
		{
			int i;

			for (i = 0; i < model->header.numFrames; i++)
			{
				if (model->frames[i].vertices)
					free(model->frames[i].vertices);
			}
			free(model->frames);
		}
		if (model->glCommandBuffer)
			free (model->glCommandBuffer);

		if(commands)
			free(commands);

		free (model);
	}
}

int SaveAsMD2(char *filename, mdx_model_t *mdx)
{
	md2_model_t *md2;
	md2_glCommandVertex_t v1, v2, v3;
	int pos = 0;
	int maxSkinName = 64;
	int something;
	int i, j,k;
	int z, x;
	int s = 0;
	int trick = 0;
	int first, extra;
	int numStripVerts, numFanVerts;
	int isFinished = 0;
	int texCoordStart = 0;
	int totalTris = 0;
	int TrisCount = 0;
	int TexTrisCount = 0;
	short *glTris;
	short *glTexTris;
	float sf, tf;
	int handle;
	int offsetFrames = 0;
	md2_alias_frame_t* frameData;


	if (!mdx)
		return 0;

	//	FILE *suck;
		//Open MD2 File for writing 
	handle = _open(filename, _O_BINARY | _O_WRONLY | _O_CREAT | _O_TRUNC, _S_IREAD | _S_IWRITE);

	//	suck = fopen("test.txt", "w+");

		//Check for error
	if (handle == -1)
		return 0; //return on error

	//Init MD2	
	md2 = malloc(sizeof(md2_model_t));

	//Main MD2 Data
#if 1
	//hypov8 match rest of code's way of allocating frame data
	//fixes free model crash when exporting md2
	{
		//frameData = (md2_alias_frame_t *)malloc(sizeof(md2_alias_frame_t) * mdx->header.numFrames);
		md2->frames = (md2_frame_t *)malloc(sizeof(md2_frame_t) * mdx->header.numFrames); //dummy
		offsetFrames = mdx->header.frameSize* mdx->header.numFrames;

		for (i = 0; i < mdx->header.numFrames; i++)
		{
			md2->frames[i].vertices = malloc(sizeof(md2_triangleVertex_t)); //dummy
			//frameData[i].vertices = (md2_alias_triangleVertex_t *)malloc(sizeof(md2_alias_triangleVertex_t) * mdx->header.numVertices);

			/*memcpy(frameData[i].scale, (byte *)mdx->framesBuffer + (i*mdx->header.frameSize), sizeof(frameData[i].scale));
			memcpy(frameData[i].translate, (byte *)mdx->framesBuffer + (i*mdx->header.frameSize) + sizeof(frameData[i].scale), sizeof(frameData[i].translate));
			memcpy(frameData[i].name, (byte *)mdx->framesBuffer + (i*mdx->header.frameSize) + sizeof(frameData[i].scale) + sizeof(frameData[i].translate), sizeof(frameData[i].name));
			memcpy(frameData[i].vertices, (byte *)mdx->framesBuffer + (i*mdx->header.frameSize) + sizeof(frameData[i].scale) + sizeof(frameData[i].translate) +
				sizeof(frameData[i].name), sizeof(md2_alias_triangleVertex_t) * mdx->header.numVertices);

			offsetFrames += sizeof(frameData[i].scale) + sizeof(frameData[i].translate) + sizeof(frameData[i].name) + (sizeof(md2_alias_triangleVertex_t) *mdx->header.numVertices);
		*/
		}
	}
#else
	md2->frames = (md2_frame_t *)malloc(sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames));
	memcpy(md2->frames, (md2_frame_t *)mdx->framesBuffer, sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames));
#endif

	md2->skins = mdx->skins;
	extra = 0;

	//	fprintf(suck, "first .... \n");
	//	fflush(suck);

		//Header data
	md2->header.frameSize = mdx->header.frameSize;
	md2->header.magic = (int)(('2' << 24) + ('P' << 16) + ('D' << 8) + 'I');
	md2->header.numFrames = mdx->header.numFrames;
	md2->header.numGlCommands = mdx->header.numGlCommands;
	md2->header.numSkins = mdx->header.numSkins;
	md2->header.numTriangles = mdx->header.numTriangles;
	md2->header.numVertices = mdx->header.numVertices;
	md2->header.skinHeight = mdx->header.skinHeight;
	md2->header.skinWidth = mdx->header.skinWidth;
	md2->header.version = 8;

	//	fprintf(suck, "second .... \n");
	//	fflush(suck);

		//Allocate memory for GLCommands
	md2->glCommandBuffer = (int *)malloc(sizeof(int) * md2->header.numGlCommands);
	md2->texCoords = malloc(sizeof(short) * 2 * md2->header.numVertices * sizeof(md2_textureCoordinate_t));

	//malloc mem for arrays
	glTris = malloc(mdx->header.numGlCommands * 3);
	glTexTris = malloc(mdx->header.numGlCommands * 3);

	///---------TESTING-----------------////
//	fprintf(suck, "testing .... \n");
//	fflush(suck);
	i = j = k = 0;
	//create software skin..
	while (!isFinished)
	{
		first = md2->glCommandBuffer[i] = mdx->glCommandBuffer[i++];

		//something that we have to get rid of in the glcommand conversion
		something = mdx->glCommandBuffer[i++];

		if (trick == 0)
			k = i - 1;
		trick++;

		if (first > 0)
		{
			// Triangle strip
			numStripVerts = first;

			totalTris += numStripVerts - 2;

			//First vert
			*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
			*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

			md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
			md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

			//vert index
			v2.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

			//Second vert
			*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
			*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

			md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
			md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

			//vert index
			v3.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

			for (z = 1;z <= (numStripVerts - 2);z++)
			{
				v1.vertexIndex = v2.vertexIndex;
				v2.vertexIndex = v3.vertexIndex;

				*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
				*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

				md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
				md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

				//vert index
				v3.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

				// As we create the strip, the vertex winding changes...
				if (!(z & 1))
				{
					//append glTris		[v1.vertexIndex, v2.vertexIndex, v3.vertexIndex]
					glTris[TrisCount++] = v1.vertexIndex;
					glTris[TrisCount++] = v2.vertexIndex;
					glTris[TrisCount++] = v3.vertexIndex;

					//append glTexTris	[texCoordStart + z + 2, texCoordStart + z + 1, texCoordStart + z]
					glTexTris[TexTrisCount++] = (texCoordStart + z + 2 - 1);
					glTexTris[TexTrisCount++] = (texCoordStart + z + 1 - 1);
					glTexTris[TexTrisCount++] = (texCoordStart + z - 1);
					//		fprintf(suck,"Strip odd %d-%d-%d\n", glTexTris[TexTrisCount-3], glTexTris[TexTrisCount-2], glTexTris[TexTrisCount-1]);
				}
				else
				{
					//append glTris		[v3.vertexIndex, v2.vertexIndex, v1.vertexIndex]
					glTris[TrisCount++] = v3.vertexIndex;
					glTris[TrisCount++] = v2.vertexIndex;
					glTris[TrisCount++] = v1.vertexIndex;

					//append glTexTris	[texCoordStart + z, texCoordStart + z + 1, texCoordStart + z + 2]
					glTexTris[TexTrisCount++] = (texCoordStart + z - 1);
					glTexTris[TexTrisCount++] = (texCoordStart + z + 1 - 1);
					glTexTris[TexTrisCount++] = (texCoordStart + z + 2 - 1);
					//	fprintf(suck,"Strip even %d-%d-%d\n", glTexTris[TexTrisCount-3], glTexTris[TexTrisCount-2], glTexTris[TexTrisCount-1]);
				}
			}
			texCoordStart += numStripVerts;
		}
		else if (first < 0)
		{
			// Triangle fan

			numFanVerts = -first;
			totalTris += numFanVerts - 2;

			//First vert
			*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
			*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

			md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
			md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

			//vert index
			v1.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

			//Second vert
			*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
			*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

			md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
			md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

			//vert index
			v3.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

			for (z = 1;z <= (numFanVerts - 2);z++)
			{
				v2.vertexIndex = v3.vertexIndex;

				*(float *)&md2->glCommandBuffer[k++] = sf = *(float *)&mdx->glCommandBuffer[i++];
				*(float *)&md2->glCommandBuffer[k++] = tf = *(float *)&mdx->glCommandBuffer[i++];

				md2->texCoords[j].s = (short)(sf*mdx->header.skinWidth);
				md2->texCoords[j++].t = (short)(tf*mdx->header.skinHeight);

				//vert index
				v3.vertexIndex = md2->glCommandBuffer[k++] = mdx->glCommandBuffer[i++];

				//append glTris		[v3.vertexIndex, v2.vertexIndex, v1.vertexIndex]
				glTris[TrisCount++] = v3.vertexIndex;
				glTris[TrisCount++] = v2.vertexIndex;
				glTris[TrisCount++] = v1.vertexIndex;

				//append glTexTris	[texCoordStart + 1, texCoordStart + z + 1, texCoordStart + z + 2]
				glTexTris[TexTrisCount++] = (texCoordStart + 1 - 1);
				glTexTris[TexTrisCount++] = (texCoordStart + z + 1 - 1);
				glTexTris[TexTrisCount++] = (texCoordStart + z + 2 - 1);
				//	fprintf(suck,"Fan %d-%d-%d\n", glTexTris[TexTrisCount-3], glTexTris[TexTrisCount-2], glTexTris[TexTrisCount-1]);
			}
			texCoordStart += numFanVerts;
		}
		else if (first == 0)
		{
			isFinished = 1;
		}
	}

	//	fprintf(suck, "finished testing .... \n");	
	//	fflush(suck);
		///---------TESTING-----------------////

	md2->triangles = (md2_triangle_t *)malloc(sizeof(md2_triangle_t)*totalTris * 3);

	//now we have glTris and glTexTris..now we need to write them & flip tris normals
	for (z = 0, x = 0;z <= (TrisCount - 1);z++)
	{
		md2->triangles[z].vertexIndices[2] = glTris[x];
		md2->triangles[z].textureIndices[0] = glTexTris[x++];

		md2->triangles[z].vertexIndices[1] = glTris[x];
		md2->triangles[z].textureIndices[1] = glTexTris[x++];

		md2->triangles[z].vertexIndices[0] = glTris[x];
		md2->triangles[z].textureIndices[2] = glTexTris[x++];
	}

	//	fprintf(suck, "tris's .... \n");
	//	fflush(suck);

		//fixup header
	md2->header.numTexCoords = j;
	//	fprintf(suck, "texCoords: %d\n", md2->header.numTexCoords);
	md2->header.numTriangles = totalTris;
	//	fprintf(suck, "TotalTris: %d\n", md2->header.numTriangles);
	md2->header.numGlCommands = mdx->header.numGlCommands - extra;

	//	fprintf(suck, "headers .... \n");
	//	fflush(suck);

		//Header offsets
	pos += sizeof(md2_header_t);
	md2->header.offsetSkins = pos;

	pos += maxSkinName*md2->header.numSkins;
	md2->header.offsetTexCoords = pos;

	pos += md2->header.numTexCoords * sizeof(md2_textureCoordinate_t);
	md2->header.offsetTriangles = pos;

	pos += md2->header.numTriangles * sizeof(md2_triangle_t);
	md2->header.offsetFrames = pos;

#if 1
	pos += offsetFrames;// sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames);
	md2->header.offsetGlCommands = pos;
#else
	pos += sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames);
	md2->header.offsetGlCommands = pos;
#endif
	BuildGlCmds(md2);
	md2->header.numGlCommands = numcommands;

	pos += (md2->header.numGlCommands * 4);//-(4*extra);  //4 bytes (dword)
	md2->header.offsetEnd = pos;

	//Write header
	write(handle, &md2->header, sizeof(md2_header_t));
	//Write skins
	write(handle, md2->skins, maxSkinName*md2->header.numSkins);
	//Write TexCoords
	write(handle, md2->texCoords, md2->header.numTexCoords * sizeof(md2_textureCoordinate_t));
	//Write Tris
	write(handle, md2->triangles, (long)md2->header.numTriangles * sizeof(md2_triangle_t));
	//Write animation frames
#if 1 

	write(handle, mdx->framesBuffer, (sizeof(byte) * (mdx->header.numFrames * mdx->header.frameSize)));

	/*for (i = 0; i < mdx->header.numFrames; i++)
	{
		write(handle, frameData[i].scale,		sizeof(frameData[i].scale));
		write(handle, frameData[i].translate,	sizeof(frameData[i].translate));
		write(handle, frameData[i].name,		sizeof(frameData[i].name));
		write(handle, frameData[i].vertices,	sizeof(md2_alias_triangleVertex_t) * md2->header.numVertices);
	}

	if (frameData)
	{
		int i;

		for (i = 0; i < mdx->header.numFrames; i++)
		{
			if (frameData[i].vertices)
				free(frameData[i].vertices);
		}
		free(frameData);
	}*/

#else
	write(handle, md2->frames, (sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames)));
#endif
	//Write GlCommands...hack really..need to generate new ones 
	//write(handle, md2->glCommandBuffer, (md2->header.numGlCommands*4)-(4*extra));
	write(handle, commands, numcommands*4);

	close(handle);
//	fflush(suck);
//	fclose(suck);
	//unsigned int frameBytes = (sizeof(byte) * (mdx->header.offsetGlCommands - mdx->header.offsetFrames));

	md2_freeModel(md2);

	return 1;
}

// from models.c in the Quake 2 source.
void BuildGlCmds(md2_model_t *md2)
{
	int		i, j, k;
	int		startv;
	float		s, t;
	int		len, bestlen, besttype;
	int		best_xyz[1024];
	int		best_st[1024];
	int		best_tris[1024];
	int		type;

	//
	// build tristrips
	//
	numcommands = 0;
	numglverts = 0;
	memset (used, 0, sizeof(used));
	for (i=0 ; i<md2->header.numTriangles ; i++)
	{
		// pick an unused triangle and start the trifan
		if (used[i])
			continue;
		bestlen = 0;
		for (type = 0 ; type < 2 ; type++)
		{
			for (startv =0 ; startv < 3 ; startv++)
			{
				if (type == 1)
					len = StripLength (i, startv, md2);
				else
					len = FanLength (i, startv, md2);
				if (len > bestlen)
				{
					besttype = type;
					bestlen = len;
					for (j=0 ; j<bestlen+2 ; j++)
					{
						best_st[j] = strip_st[j];
						best_xyz[j] = strip_xyz[j];
					}
					for (j=0 ; j<bestlen ; j++)
						best_tris[j] = strip_tris[j];
				}
			}
		}

		// mark the tris on the best strip/fan as used
		for (j=0 ; j<bestlen ; j++)
			used[best_tris[j]] = 1;

		if (besttype == 1)
			commands[numcommands++] = (bestlen+2);
		else
			commands[numcommands++] = -(bestlen+2);

		numglverts += bestlen+2;

		for (j=0 ; j<bestlen+2 ; j++)
		{
			// emit a vertex into the reorder buffer
			k = best_st[j];

			// emit s/t coords into the commands stream
			s = md2->texCoords[k].s;
			t = md2->texCoords[k].t;
			
			s = (float)((s + 0.5) / md2->header.skinWidth);
			t = (float)((t + 0.5) / md2->header.skinHeight);

         		if(numcommands>16510)
		        {
            			int x = 25;
			        x += numcommands-4 *10;
            			k = best_st[j];
			}

			*(float *)&commands[numcommands++] = s;
			*(float *)&commands[numcommands++] = t;
			*(int *)&commands[numcommands++] = best_xyz[j];
		}
	}

	commands[numcommands++] = 0;		// end of list marker
}

//===========
//StripLength
//===========

int StripLength (int starttri, int startv, md2_model_t *md2)
{
	int				m1, m2;
	int				st1, st2;
	int				j;
//	TRealTriangle	*last, *check;
	md2_triangle_t  *last, *check;
	int				k;

	used[starttri] = 2;

//	last = &Tris[starttri];
	last = &md2->triangles[starttri];

	strip_xyz[0] = last->vertexIndices[(startv)%3];
	strip_xyz[1] = last->vertexIndices[(startv+1)%3];
	strip_xyz[2] = last->vertexIndices[(startv+2)%3];
	strip_st[0] = last->textureIndices[(startv)%3];
	strip_st[1] = last->textureIndices[(startv+1)%3];
	strip_st[2] = last->textureIndices[(startv+2)%3];

	strip_tris[0] = starttri;
	stripcount = 1;

	m1 = last->vertexIndices[(startv+2)%3];
	st1 = last->textureIndices[(startv+2)%3];
	m2 = last->vertexIndices[(startv+1)%3];
	st2 = last->textureIndices[(startv+1)%3];

	// look for a matching triangle
nexttri:
	for (j=starttri+1, check=&md2->triangles[starttri+1]
		; j<md2->header.numTriangles ; j++, check++)
	{
		for (k=0 ; k<3 ; k++)
		{
			if (check->vertexIndices[k] != m1)
				continue;
			if (check->textureIndices[k] != st1)
				continue;
			if (check->vertexIndices[ (k+1)%3 ] != m2)
				continue;
			if (check->textureIndices[ (k+1)%3 ] != st2)
				continue;

			// this is the next part of the fan

			// if we can't use this triangle, this tristrip is done
			if (used[j])
				goto done;

			// the new edge
			if (stripcount & 1)
			{
				m2 = check->vertexIndices[ (k+2)%3 ];
				st2 = check->textureIndices[ (k+2)%3 ];
			}
			else
			{
				m1 = check->vertexIndices[ (k+2)%3 ];
				st1 = check->textureIndices[ (k+2)%3 ];
			}

			strip_xyz[stripcount+2] = check->vertexIndices[ (k+2)%3 ];
			strip_st[stripcount+2] = check->textureIndices[ (k+2)%3 ];
			strip_tris[stripcount] = j;
			stripcount++;

			used[j] = 2;
			goto nexttri;
		}
	}
done:

	// clear the temp used flags
	for (j=starttri+1 ; j<md2->header.numTriangles ; j++)
		if (used[j] == 2)
			used[j] = 0;

	return stripcount;
}


//===========
//FanLength
//===========

int FanLength (int starttri, int startv, md2_model_t *md2)
{
	int		m1, m2;
	int		st1, st2;
	int		j;
//	TRealTriangle	*last, *check;
	md2_triangle_t  *last, *check;
	int		k;

	used[starttri] = 2;

	last = &md2->triangles[starttri];

	strip_xyz[0] = last->vertexIndices[(startv)%3];
	strip_xyz[1] = last->vertexIndices[(startv+1)%3];
	strip_xyz[2] = last->vertexIndices[(startv+2)%3];
	strip_st[0] = last->textureIndices[(startv)%3];
	strip_st[1] = last->textureIndices[(startv+1)%3];
	strip_st[2] = last->textureIndices[(startv+2)%3];

	strip_tris[0] = starttri;
	stripcount = 1;

	m1 = last->vertexIndices[(startv+0)%3];
	st1 = last->textureIndices[(startv+0)%3];
	m2 = last->vertexIndices[(startv+2)%3];
	st2 = last->textureIndices[(startv+2)%3];


	// look for a matching triangle
nexttri:
	for (j=starttri+1, check=&md2->triangles[starttri+1] 
		; j<md2->header.numTriangles ; j++, check++)
	{
		for (k=0 ; k<3 ; k++)
		{
			if (check->vertexIndices[k] != m1)
				continue;
			if (check->textureIndices[k] != st1)
				continue;
			if (check->vertexIndices[ (k+1)%3 ] != m2)
				continue;
			if (check->textureIndices[ (k+1)%3 ] != st2)
				continue;

			// this is the next part of the fan

			// if we can't use this triangle, this tristrip is done
			if (used[j])
				goto done;

			// the new edge
			m2 = check->vertexIndices[ (k+2)%3 ];
			st2 = check->textureIndices[ (k+2)%3 ];

			strip_xyz[stripcount+2] = m2;
			strip_st[stripcount+2] = st2;
			strip_tris[stripcount] = j;
			stripcount++;

			used[j] = 2;
			goto nexttri;
		}
	}
done:

	// clear the temp used flags
	for (j=starttri+1 ; j<md2->header.numTriangles ; j++)
		if (used[j] == 2)
			used[j] = 0;

	return stripcount;
}