#define WIN32_LEAN_AND_MEAN
#define ERR(x) error(__FILE__, __LINE__, x)
#define AVIERR(x) if ((x) != AVIERR_OK) ERR(#x)

#include <windows.h>
#include <vfw.h> /* don't forget to link with vfw32.lib and user32.lib! */
#include <stdio.h>
#include <stdlib.h>
#include <shellapi.h> 
#include <malloc.h>
#include <mx/mx.h>
#include <mx/gl.h>
#include <mx/mxTga.h>
#include "mdxviewer.h"
#include "mdx.h"
#include "md2.h"
#include "GlWindow.h"
#include "pakviewer.h"


MDXViewer *g_mdxViewer = 0;
char *loadmod=NULL;


static char recentFiles[8][256] = { "", "", "", "", "", "", "", "" };

int counter=0;
long Skins=0;
long Vertices=0;
long Triangles=0;
long GlCommands=0;
long Frames=0;


void error(char *file, int line, char *err)
{
	FILE *error;
	error = fopen("error.log", "w");
	fprintf(error, "%s:%d: %s\n", file, line, err);
	fclose(error);
	exit(1);
}

void
MDXViewer::initRecentFiles ()
{
	for (int i = 0; i < 8; i++)
	{
		if (strlen (recentFiles[i]))
		{
			mb->modify (IDC_MODEL_RECENTMODELS1 + i, IDC_MODEL_RECENTMODELS1 + i, recentFiles[i]);
		}
		else
		{
			mb->modify (IDC_MODEL_RECENTMODELS1 + i, IDC_MODEL_RECENTMODELS1 + i, "(empty)");
			mb->setEnabled (IDC_MODEL_RECENTMODELS1 + i, false);
		}
	}
}



void
MDXViewer::loadRecentFiles ()
{
	FILE *file = fopen ("mdx.ini", "rb");
	if (file)
	{
		fread (recentFiles, sizeof recentFiles, 1, file);
		fclose (file);
	}
}



void
MDXViewer::saveRecentFiles ()
{
	char path[256];

	strcpy (path, mx::getApplicationPath ());
	strcat (path, "/mdx.ini");

	FILE *file = fopen (path, "wb");
	if (file)
	{
		fwrite (recentFiles, sizeof recentFiles, 1, file);
		fclose (file);
	}
}




MDXViewer::MDXViewer ()
: mxWindow (0, 0, 0, 0, 0, "MDX Viewer 1.1", mxWindow::Normal)
{
	// create menu stuff
	mb = new mxMenuBar (this);
	mxMenu *menuModel = new mxMenu ();
	mxMenu *menuSkin = new mxMenu ();
	mxMenu *menuOptions = new mxMenu ();
	mxMenu *menuView = new mxMenu ();
	mxMenu *menuHelp = new mxMenu ();

	mb->addMenu ("Model", menuModel);
	mb->addMenu ("Skin", menuSkin);
	mb->addMenu ("Options", menuOptions);
	mb->addMenu ("Help", menuHelp);

	mxMenu *menuRecentModels = new mxMenu ();
	menuRecentModels->add ("(empty)", IDC_MODEL_RECENTMODELS1);
	menuRecentModels->add ("(empty)", IDC_MODEL_RECENTMODELS2);
	menuRecentModels->add ("(empty)", IDC_MODEL_RECENTMODELS3);
	menuRecentModels->add ("(empty)", IDC_MODEL_RECENTMODELS4);

	mxMenu *menuRecentPakFiles = new mxMenu ();
	menuRecentPakFiles->add ("(empty)", IDC_MODEL_RECENTPAKFILES1);
	menuRecentPakFiles->add ("(empty)", IDC_MODEL_RECENTPAKFILES2);
	menuRecentPakFiles->add ("(empty)", IDC_MODEL_RECENTPAKFILES3);
	menuRecentPakFiles->add ("(empty)", IDC_MODEL_RECENTPAKFILES4);


	menuModel->add ("Load Model...", IDC_MODEL_LOADMODEL);
	menuModel->add ("Merge Model...", IDC_MODEL_LOADWEAPON);
	menuModel->addSeparator ();
	menuModel->add ("Unload Models", IDC_MODEL_UNLOADMODEL);
//	menuModel->add ("Unload Weapon", IDC_MODEL_UNLOADWEAPON);
	menuModel->addSeparator ();
	menuModel->add ("Open PAK file...", IDC_MODEL_OPENPAKFILE);
	menuModel->add ("Close PAK file", IDC_MODEL_CLOSEPAKFILE);
	menuModel->addSeparator ();
	menuModel->addMenu ("Recent Models", menuRecentModels);
	menuModel->addMenu ("Recent PAK files", menuRecentPakFiles);
	menuModel->addSeparator ();
	menuModel-> add ("Save as MD2", IDC_MODEL_MD2);
	menuModel->addSeparator ();
	menuModel->add ("Exit", IDC_MODEL_EXIT);

	menuSkin->add ("Load Main Model Skin...", IDC_SKIN_MODELSKIN);
	menuSkin->add ("Load Model 2 Skin...", IDC_SKIN_WEAPONSKIN);
	menuSkin->add ("Load Model 3 Skin...", IDC_SKIN_MODELSKIN3);
	menuSkin->add ("Load Model 4 Skin...", IDC_SKIN_MODELSKIN4);
	menuSkin->add ("Load Model 5 Skin...", IDC_SKIN_MODELSKIN5);
	menuSkin->add ("Load Model 6 Skin...", IDC_SKIN_MODELSKIN6);
	menuSkin->addSeparator ();
	menuSkin->add ("Load Background Texture...", IDC_SKIN_BACKGROUND);
	menuSkin->add ("Load Water Texture...", IDC_SKIN_WATER);
#ifdef WIN32
	menuSkin->addSeparator ();
	menuSkin->add ("Make Screenshot...", IDC_SKIN_SCREENSHOT);
	menuSkin->add ("Make AVI File...", IDC_SKIN_AVI);
#endif
	menuOptions->add ("Background Color...", IDC_OPTIONS_BGCOLOR);
	menuOptions->add ("Wireframe Color...", IDC_OPTIONS_WFCOLOR);
	menuOptions->add ("Shade Color...", IDC_OPTIONS_FGCOLOR);
	menuOptions->add ("Light Color...", IDC_OPTIONS_LIGHTCOLOR);
	menuOptions->addSeparator ();
	menuOptions->add ("Center Model", IDC_OPTIONS_CENTERMODEL);
	menuOptions->add ("Generate Light Normals", IDC_OPTIONS_GENERATELIGHTNORMALS);

#ifdef WIN32
	menuHelp->add ("Goto Homepage...", IDC_HELP_GOTOHOMEPAGE);
	menuHelp->addSeparator ();
#endif
	menuHelp->add ("About", IDC_HELP_ABOUT);

	// create tabcontrol with subdialog windows
	tab = new mxTab (this, 0, 0, 0, 0);
#ifdef WIN32
	SetWindowLong ((HWND) tab->getHandle (), GWL_EXSTYLE, WS_EX_CLIENTEDGE);
#endif

	bar = new mxProgressBar (this, 0, 0, 300, 20, 0);
#ifdef WIN32
	SetWindowLong ((HWND) bar->getHandle (), GWL_EXSTYLE, WS_EX_CLIENTEDGE);
#endif

	mxWindow *wAnim = new mxWindow (this, 0, 0, 0, 0);
	mxWindow *wInfo = new mxWindow (this, 0, 0, 0, 0);
	mxWindow *wView = new mxWindow (this, 0, 0, 0, 0);

	// and add them to the tabcontrol
	tab->add (wView, "View");
	tab->add (wAnim, "Animation");
	tab->add (wInfo, "Model Info");

	// Create widgets for the View Tab
	cRenderMode = new mxChoice (wView, 5, 5, 200, 22, IDC_RENDERMODE);
	cRenderMode->add ("Wireframe");
	cRenderMode->add ("Flat shaded");
	cRenderMode->add ("Smooth Shaded");
	cRenderMode->add ("Textured");
	cRenderMode->select (0);
	cbWater = new mxCheckBox (wView, 5, 30, 100, 22, "Enable Water", IDC_WATER);
	cbLight = new mxCheckBox (wView, 5, 55, 100, 22, "Enable Light", IDC_LIGHT);
	cbLight->setChecked (false);
	mxLabel *lblBrightness = new mxLabel (wView, 105, 34, 200, 16, "Brightness");
	mxSlider *slBrightness = new mxSlider (wView, 162, 35, 100, 16, IDC_BRIGHTNESS);
	slBrightness->setRange (0, 100);
	slBrightness->setValue (5);
	mxToolTip::add (slBrightness, "Brightness - don't forget to reload the skin!");
	mxCheckBox *cbShininess = new mxCheckBox (wView, 105, 55, 100, 22, "Shininess", IDC_SHININESS);
	cbShininess->setChecked (false);
	cbBackground = new mxCheckBox (wView, 205, 55, 100, 22, "Background", IDC_BACKGROUND);
	mxChoice *cTextureLimit = new mxChoice (wView, 210, 5, 60, 22, IDC_TEXTURELIMIT);
	cTextureLimit->add ("512");
	cTextureLimit->add ("256");
	cTextureLimit->add ("128");
	cTextureLimit->select (0);
	mxToolTip::add (cTextureLimit, "Choose Texture Size Limit");

	// Create widgets for the Animation Tab
	cAnim = new mxChoice (wAnim, 5, 5, 200, 22, IDC_ANIMATION);

	mxCheckBox *cbInterp = new mxCheckBox (wAnim, 65, 30, 100, 22, "Interpolate", IDC_INTERPOLATE);
	cbInterp->setChecked (true);

	mxSlider *slPitch = new mxSlider (wAnim, 5, 55, 200, 22, IDC_PITCH);
	slPitch->setRange (1, 200);
	slPitch->setValue (125);
	mxToolTip::add (slPitch, "Frame Animation Speed (Pitch)");

	bPause = new mxButton (wAnim, 210, 5, 79, 22, "Pause", IDC_PAUSE);

	bDecFrame = new mxButton (wAnim, 211, 31, 20, 20, "<", IDC_DECFRAME);
	bDecFrame->setEnabled (false);
	mxToolTip::add (bDecFrame, "Decrease Current Frame");

	leFrame = new mxLineEdit (wAnim, 232, 30, 35, 22, "0");
	leFrame->setEnabled (false);
	mxToolTip::add (leFrame, "Current Frame");

	bSetFrame = new mxButton (wAnim, 232, 51, 35, 20, "Set", IDC_FRAME);
	bSetFrame->setEnabled (false);
	mxToolTip::add (bSetFrame, "Set Current Frame");

	bIncFrame = new mxButton (wAnim, 268, 31, 20, 20, ">", IDC_INCFRAME);
	bIncFrame->setEnabled (false);
	mxToolTip::add (bIncFrame, "Increase Current Frame");

	// Create widgets for the Model Info Tab
	lModelInfo1 = new mxLabel (wInfo, 5, 5, 150, 125, "No Model.");
//	lModelInfo2 = new mxLabel (wInfo, 155, 5, 150, 125, "No Weapon.");

	// create the OpenGL window
	glw = new GlWindow (this, 0, 0, 0, 0, "", mxWindow::Normal);
#ifdef WIN32
	SetWindowLong ((HWND) glw->getHandle (), GWL_EXSTYLE, WS_EX_CLIENTEDGE);
#endif

	// finally create the pakviewer window
	pakViewer = new PAKViewer (this);

	loadRecentFiles ();
	initRecentFiles ();

	setBounds (20, 20, 690, 550);
	setVisible (true);

	if(loadmod!=NULL)
	{
		if (!loadModel (loadmod, counter))
		{
			char str[256];
			sprintf (str, "Error reading model: %s", loadmod);
			mxMessageBox (this, str, "ERROR", MX_MB_OK | MX_MB_ERROR);
		}
		counter++;
	}
}



MDXViewer::~MDXViewer ()
{
	saveRecentFiles ();

}



int
MDXViewer::handleEvent (mxEvent *event)
{

	switch (event->event)
	{
	case mxEvent::Action:
	{
		switch (event->action)
		{
		case IDC_MODEL_LOADMODEL:
		case IDC_MODEL_LOADWEAPON:
		{

			
			const char *ptr = mxGetOpenFileName (this, 0, "*.mdx");
			if (ptr && counter!=5)
			{
				if(event->action==IDC_MODEL_LOADMODEL)
				{
					counter=0;
					Skins=0;
					Vertices=0;
					Triangles=0;
					GlCommands=0;
					Frames=0;
					setModelInfo (0, 1);
					glw->loadModel (0, 1);
					glw->loadModel (0, 2);
					glw->loadModel (0, 3);
					glw->loadModel (0, 4);
					glw->loadModel (0, 5);
					glw->loadTexture (0, TEXTURE_WEAPON);
					glw->loadTexture (0, TEXTURE_MODEL3);
					glw->loadTexture (0, TEXTURE_MODEL4);
					glw->loadTexture (0, TEXTURE_MODEL5);
					glw->loadTexture (0, TEXTURE_MODEL6);
					cAnim->removeAll ();
					glw->setFrameInfo (0, 0);
					glw->redraw ();
				}
				
//				if (!loadModel (ptr, event->action - IDC_MODEL_LOADMODEL))
				if (!loadModel (ptr, counter))
				{
					char str[256];

					sprintf (str, "Error reading model: %s", ptr);
					mxMessageBox (this, str, "ERROR", MX_MB_OK | MX_MB_ERROR);
					break;
				}
				counter++;
				
				
				// now update recent files list

				int i;
				char path[256];

				strcpy (path, "[m] ");
			
				strcat (path, ptr);

				for (i = 0; i < 4; i++)
				{
					if (!_stricmp (recentFiles[i], path))
						break;
				}

				// swap existing recent file
				if (i < 4)
				{
					char tmp[256];
					strcpy (tmp, recentFiles[0]);
					strcpy (recentFiles[0], recentFiles[i]);
					strcpy (recentFiles[i], tmp);
				}

				// insert recent file
				else
				{
					for (i = 3; i > 0; i--)
						strcpy (recentFiles[i], recentFiles[i - 1]);

					strcpy (recentFiles[0], path);
				}

				initRecentFiles ();
			}
		}
		break;

		case IDC_MODEL_UNLOADMODEL:
		case IDC_MODEL_UNLOADWEAPON:
			counter=0;
			Skins=0;
			Vertices=0;
			Triangles=0;
			GlCommands=0;
			Frames=0;
			setModelInfo (0, 0);
			setModelInfo (0, 1);
			glw->loadModel (0, 0);
			glw->loadModel (0, 1);
			glw->loadModel (0, 2);
			glw->loadModel (0, 3);
			glw->loadModel (0, 4);
			glw->loadModel (0, 5);
			glw->loadTexture (0, TEXTURE_MODEL);
			glw->loadTexture (0, TEXTURE_WEAPON);
			glw->loadTexture (0, TEXTURE_MODEL3);
			glw->loadTexture (0, TEXTURE_MODEL4);
			glw->loadTexture (0, TEXTURE_MODEL5);
			glw->loadTexture (0, TEXTURE_MODEL6);
			cAnim->removeAll ();
			glw->setFrameInfo (0, 0);
			glw->redraw ();
			break;

		case IDC_MODEL_OPENPAKFILE:
		case IDC_MODEL_OPENPAKFILE2:
		{
			const char *ptr = mxGetOpenFileName (this, "c:\\Program Files\\Kingpin\\main\\", "*.pak");
			if (ptr)
			{
				pakViewer->setLoadEntirePAK (event->action == IDC_MODEL_OPENPAKFILE);
				if (!pakViewer->openPAKFile (ptr))
				{
					mxMessageBox (this, "Error loading PAK file", "ERROR", MX_MB_OK | MX_MB_ERROR);
					break;
				}

				// update recent pak file list

				int i;

				for (i = 4; i < 8; i++)
				{
					if (!_stricmp(recentFiles[i], ptr))
						break;
				}

				// swap existing recent file
				if (i < 8)
				{
					char tmp[256];
					strcpy (tmp, recentFiles[4]);
					strcpy (recentFiles[4], recentFiles[i]);
					strcpy (recentFiles[i], tmp);
				}

				// insert recent file
				else
				{
					for (i = 7; i > 4; i--)
						strcpy (recentFiles[i], recentFiles[i - 1]);

					strcpy (recentFiles[4], ptr);
				}

				initRecentFiles ();

				redraw ();
			}
		}
		break;

		case IDC_MODEL_CLOSEPAKFILE:
		{
			pakViewer->closePAKFile ();
			redraw ();
		}
		break;

		case IDC_MODEL_RECENTMODELS1:
		case IDC_MODEL_RECENTMODELS2:
		case IDC_MODEL_RECENTMODELS3:
		case IDC_MODEL_RECENTMODELS4:
		{
			int i = event->action - IDC_MODEL_RECENTMODELS1;
			bool isModel = recentFiles[i][1] == 'm';
			char *ptr = &recentFiles[i][4];

			if (!loadModel (ptr, isModel ? 0:1))
			{
				char str[256];

				sprintf (str, "Error reading model: %s", ptr);
				mxMessageBox (this, str, "ERROR", MX_MB_OK | MX_MB_ERROR);
				break;
			}

			// update recent model list

			char tmp[256];			
			strcpy (tmp, recentFiles[0]);
			strcpy (recentFiles[0], recentFiles[i]);
			strcpy (recentFiles[i], tmp);

			initRecentFiles ();
		}
		break;

		case IDC_MODEL_RECENTPAKFILES1:
		case IDC_MODEL_RECENTPAKFILES2:
		case IDC_MODEL_RECENTPAKFILES3:
		case IDC_MODEL_RECENTPAKFILES4:
		{
			int i = event->action - IDC_MODEL_RECENTPAKFILES1 + 4;
			pakViewer->setLoadEntirePAK (true);
			pakViewer->openPAKFile (recentFiles[i]);

			char tmp[256];			
			strcpy (tmp, recentFiles[4]);
			strcpy (recentFiles[4], recentFiles[i]);
			strcpy (recentFiles[i], tmp);

			initRecentFiles ();

			redraw ();
		}
		break;
		case IDC_MODEL_MD2:
		{
			const char *file = mxGetSaveFileName (this, 0, "*.md2");
			if (file)
			{
				int blah;
				char *test=NULL;
				if((test = strstr(file, ".md2"))==NULL)
					strcat((char *)file, ".md2");
				if (glw->getModel(0))
				   if((blah = SaveAsMD2((char *)file, glw->getModel(0)))!=1)
				   {
					    char str[256];

						sprintf (str, "Error saving model: %s", file);
						mxMessageBox (this, str, "ERROR", MX_MB_OK | MX_MB_ERROR);
				   }
			}
		}
			break;
		case IDC_MODEL_EXIT:
			mx::setIdleWindow (0);
			mx::quit ();
			break;

		case IDC_SKIN_MODELSKIN:
		case IDC_SKIN_MODELSKIN3:
		case IDC_SKIN_MODELSKIN4:
		case IDC_SKIN_MODELSKIN5:
		case IDC_SKIN_MODELSKIN6:
		case IDC_SKIN_WEAPONSKIN:
		{
//			const char *ptr = mxGetOpenFileName (this, 0, "*.pcx");
			const char *ptr = mxGetOpenFileName (this, 0, "*.tga");
			if (ptr)
			{
				if(event->action==IDC_SKIN_MODELSKIN)
					glw->loadTexture (ptr, TEXTURE_MODEL);
				else if(event->action==IDC_SKIN_WEAPONSKIN)
					glw->loadTexture (ptr, TEXTURE_WEAPON);
				else if(event->action==IDC_SKIN_MODELSKIN3)
					glw->loadTexture (ptr, TEXTURE_MODEL3);
				else if(event->action==IDC_SKIN_MODELSKIN4)
					glw->loadTexture (ptr, TEXTURE_MODEL4);
				else if(event->action==IDC_SKIN_MODELSKIN5)
					glw->loadTexture (ptr, TEXTURE_MODEL5);
				else if(event->action==IDC_SKIN_MODELSKIN6)
					glw->loadTexture (ptr, TEXTURE_MODEL6);
				
				setRenderMode (3);
				glw->redraw ();
			}
		}
		break;

		case IDC_SKIN_BACKGROUND:
		case IDC_SKIN_WATER:
		{
			const char *ptr = mxGetOpenFileName (this, 0, "*.tga");
			if (!ptr)
				break;

			if (glw->loadTexture (ptr, event->action == IDC_SKIN_BACKGROUND ? TEXTURE_BACKGROUND:TEXTURE_WATER))
			{
				if (event->action == IDC_SKIN_BACKGROUND)
				{
					cbBackground->setChecked (true);
					glw->setFlag (F_BACKGROUND, true);
				}
				else
				{
					cbWater->setChecked (true);
					glw->setFlag (F_WATER, true);
				}

				setRenderMode (3);
				glw->redraw ();
			}
			else
				mxMessageBox (this, "Error loading texture.", "MDX Viewer", MX_MB_OK | MX_MB_ERROR);
		}
		break;

#ifdef WIN32
		case IDC_SKIN_SCREENSHOT:
		{
			const char *ptr = mxGetSaveFileName (this, 0, "*.tga");
			if (ptr)
			{
				char *test=NULL;
				if((test = strstr(ptr, ".tga"))==NULL)
					strcat((char *)ptr, ".tga");
				makeScreenShot (ptr);
			}
		//	int test = MakeAVI();
		}
		break;
		case IDC_SKIN_AVI:
		{
			int index = cAnim->getSelectedIndex ();
			if (index >= 0)
			{
				// set the animation
				int start, end, test;
				//FILE *te;
				initAVIAnimation (glw->getModel (0), index - 1, &start, &end);
				if(start==0 && end==0)
					{start = 1; end = glw->getModel (0)->header.numFrames;}
			//	te = fopen("test.txt", "w+");
			//	fprintf(te, "%d start, %d end\n", start, end);
			//	fclose(te);
				if((test = MakeAVI(start, end))==0)
					mxMessageBox (this, "Error creating AVI File.", "MDX Viewer", MX_MB_OK | MX_MB_ERROR);
				
				glw->redraw ();
			}

		}
		break;
#endif

		case IDC_OPTIONS_BGCOLOR:
		case IDC_OPTIONS_FGCOLOR:
		case IDC_OPTIONS_WFCOLOR:
		case IDC_OPTIONS_LIGHTCOLOR:
		{
			float r, g, b;
			int ir, ig, ib;

			if (event->action == IDC_OPTIONS_BGCOLOR)
				glw->getBGColor (&r, &g, &b);
			else if (event->action == IDC_OPTIONS_FGCOLOR)
				glw->getFGColor (&r, &g, &b);
			else if (event->action == IDC_OPTIONS_WFCOLOR)
				glw->getWFColor (&r, &g, &b);
			else if (event->action == IDC_OPTIONS_LIGHTCOLOR)
				glw->getLightColor (&r, &g, &b);

			ir = (int) (r * 255.0f);
			ig = (int) (g * 255.0f);
			ib = (int) (b * 255.0f);
			if (mxChooseColor (this, &ir, &ig, &ib))
			{
				if (event->action == IDC_OPTIONS_BGCOLOR)
					glw->setBGColor ((float) ir / 255.0f, (float) ig / 255.0f, (float) ib / 255.0f);
				else if (event->action == IDC_OPTIONS_FGCOLOR)
					glw->setFGColor ((float) ir / 255.0f, (float) ig / 255.0f, (float) ib / 255.0f);
				else if (event->action == IDC_OPTIONS_WFCOLOR)
					glw->setWFColor ((float) ir / 255.0f, (float) ig / 255.0f, (float) ib / 255.0f);
				else if (event->action == IDC_OPTIONS_LIGHTCOLOR)
					glw->setLightColor ((float) ir / 255.0f, (float) ig / 255.0f, (float) ib / 255.0f);

				glw->redraw ();
			}
		}
		break;

		case IDC_OPTIONS_CENTERMODEL:
		{
			centerModel ();
			glw->redraw ();
		}
		break;

		case IDC_OPTIONS_GENERATELIGHTNORMALS:
			mdx_generateLightNormals (glw->getModel (0));
			mdx_generateLightNormals (glw->getModel (1));
			glw->redraw ();
			break;

#ifdef WIN32
		case IDC_HELP_GOTOHOMEPAGE:
			ShellExecute (0, "open", "http://www.planetwolfenstein.com/tramdesign", 0, 0, SW_SHOW);
			break;
#endif

		case IDC_HELP_ABOUT:
			mxMessageBox (this,
				"MDX Viewer 1.1 (c) 2002 by TiCaL\n\n"
				"Thanks to Mete Cirigan for MD2 Viewer code\n"
				"Thanks to Chris Cookson for helping me out :)\n"
				"Left-drag to rotate.\n"
				"Right-drag to zoom.\n"
				"Shift-left-drag to x-y-pan.\n\n"
				"Build:\t" __DATE__ ".\n"
				"Email:\ttical@kingpin.com\n\n"
				"Known bug:\n   - TGA files with odd pixel width don't load properly.\n     FIX: Resize the TGA image so its 1 pixel more/less wider."
				"\n\nWeb:\thttp://www.planetwolfenstein.com/tramdesign/", "About MDX Viewer",
				MX_MB_OK | MX_MB_INFORMATION);
			break;

		// 
		// widget actions
		//
		//

		//
		// Model Panel
		//

		case IDC_RENDERMODE:
			setRenderMode (cRenderMode->getSelectedIndex ());
			glw->redraw ();
			break;

		case IDC_WATER:
			glw->setFlag (F_WATER, cbWater->isChecked ());
			glw->redraw ();
			break;

		case IDC_LIGHT:
			glw->setFlag (F_LIGHT, cbLight->isChecked ());
			glw->redraw ();
			break;

		case IDC_BRIGHTNESS:
			glw->setBrightness (((mxSlider *) event->widget)->getValue ());
			break;

		case IDC_SHININESS:
			glw->setFlag (F_SHININESS, ((mxCheckBox *) event->widget)->isChecked ());
			glw->redraw ();
			break;

		case IDC_BACKGROUND:
			glw->setFlag (F_BACKGROUND, ((mxCheckBox *) event->widget)->isChecked ());
			glw->redraw ();
			break;

		case IDC_TEXTURELIMIT:
		{
			int tl[3] = { 512, 256, 128 };
			int index = ((mxChoice *) event->widget)->getSelectedIndex ();
			if (index >= 0)
				glw->setTextureLimit (tl[index]);
		}
		break;

		//
		// Animation Panel
		//
		case IDC_ANIMATION:
		{
			int index = cAnim->getSelectedIndex ();
			if (index >= 0)
			{
				// set the animation
				initAnimation (glw->getModel (0), index - 1);

				// if we pause, update current frame in leFrame
				if (glw->getFlag (F_PAUSE))
				{
					char str[32];
					int frame = glw->getCurrFrame ();
					sprintf (str, "%d", frame);
					leFrame->setLabel (str);
					glw->setFrameInfo (frame, frame);
				}

				glw->redraw ();
			}
		}
		break;

		case IDC_INTERPOLATE:
			glw->setFlag (F_INTERPOLATE, ((mxCheckBox *) event->widget)->isChecked ());
			break;

		case IDC_PITCH:
			glw->setPitch ((float) ((mxSlider *) event->widget)->getValue ());
			break;

		case IDC_PAUSE: // Pause/Play
		{
			bool pause = !glw->getFlag (F_PAUSE);;
			static int startFrame = 0, endFrame = 0, currFrame = 0, currFrame2 = 0;
			static float pol = 0;
			static int index;

			glw->setFlag (F_PAUSE, pause);
			bDecFrame->setEnabled (pause);
			leFrame->setEnabled (pause);
			bIncFrame->setEnabled (pause);
			bSetFrame->setEnabled (pause);

			if (pause)
			{
				char str[32];

				// store current settings
				startFrame = glw->getStartFrame ();
				endFrame = glw->getEndFrame ();
				currFrame = glw->getCurrFrame ();
				currFrame2 = glw->getCurrFrame2 ();
				pol = glw->d_pol;

				sprintf (str, "%d", glw->getCurrFrame ());
				leFrame->setLabel (str);
				bPause->setLabel ("Play");

				index = cAnim->getSelectedIndex ();
			}
			else
			{

				glw->d_startFrame = startFrame;
				glw->d_endFrame = endFrame;
				glw->d_currFrame = currFrame;
				glw->d_currFrame2 = currFrame2;
				glw->d_pol = pol;

				bPause->setLabel ("Pause");

				int index2 = cAnim->getSelectedIndex ();
				if (index != index2 && index2 >= 0)
					initAnimation (glw->getModel (0), index2 - 1);
			}
		}
		break;

		case IDC_DECFRAME:
		{
			int frame = glw->getCurrFrame () - 1;
			glw->setFrameInfo (frame, frame);

			char str[32];
			sprintf (str, "%d", glw->getCurrFrame ());
			leFrame->setLabel (str);
			glw->redraw ();
		}
		break;

		case IDC_FRAME:
		{
			const char *ptr = leFrame->getLabel ();
			if (ptr)
			{
				int frame = atoi (ptr);
				glw->setFrameInfo (frame, frame);

				char str[32];
				sprintf (str, "%d", glw->getCurrFrame ());
				leFrame->setLabel (str);
				glw->redraw ();
			}
		}
		break;

		case IDC_INCFRAME:
		{
			int frame = glw->getCurrFrame () + 1;
			glw->setFrameInfo (frame, frame);

			char str[32];
			sprintf (str, "%d", glw->getCurrFrame ());
			leFrame->setLabel (str);
			glw->redraw ();
			
		}
		break;

		}
	} // mxEvent::Action
	break;

	case mxEvent::Size:
	{
		int w = event->width;
		int h = event->height;
		int y = mb->getHeight ();
#ifdef WIN32
#define HEIGHT 120
#else
#define HEIGHT 140
		h -= 40;
#endif

		if (pakViewer->isVisible ())
		{
			w -= 170;
			pakViewer->setBounds (w, y, 170, h);
		}
		//fix tga bug for avi file....always make glw even width
		if (w&1) w+=1;

		//resize
		glw->setBounds (0, y, w, h - HEIGHT);
		bar->setBounds (0, y + h - HEIGHT, w-1, HEIGHT-105);
		tab->setBounds (0, y+16 + h - HEIGHT, w, HEIGHT);
		
	}
	break;
	} // event->event

	return 1;
}



void
MDXViewer::redraw ()
{
	mxEvent event;
	event.event = mxEvent::Size;
	event.width = w2 ();
	event.height = h2 ();
	handleEvent (&event);
}



void
MDXViewer::makeScreenShot (const char *filename)
{
#ifdef WIN32
	glw->redraw ();
	int w = glw->w2 ();
	int h = glw->h2 ();

	mxImage *image = new mxImage ();
	if (image->create (w, h, 24))
	{
#if 0
		glReadBuffer (GL_FRONT);
		glReadPixels (0, 0, w, h, GL_RGB, GL_UNSIGNED_BYTE, image->data);
#else
		HDC hdc = GetDC ((HWND) glw->getHandle ());
		byte *data = (byte *) image->data;
		int i = 0;
		for (int y = 0; y < h; y++)
		{
			for (int x = 0; x < w; x++)
			{
				COLORREF cref = GetPixel (hdc, x, y);
				data[i++] = (byte) ((cref >> 0)& 0xff);
				data[i++] = (byte) ((cref >> 8) & 0xff);
				data[i++] = (byte) ((cref >> 16) & 0xff);
			}
		}
		ReleaseDC ((HWND) glw->getHandle (), hdc);
#endif
		if (!mxTgaWrite (filename, image))
			mxMessageBox (this, "Error writing screenshot.", "MDX Viewer", MX_MB_OK | MX_MB_ERROR);

		delete image;
	}
#endif
}



void
MDXViewer::setRenderMode (int mode)
{
	if (mode >= 0)
	{
		cRenderMode->select (mode);
		glw->setRenderMode (mode);

		// disable light, if not needed
	//	glw->setFlag (F_LIGHT, mode != 0);
	//	cbLight->setChecked (mode != 0);
	}
}



void
MDXViewer::centerModel ()
{
	if (glw->getModel (0))
	{
		float minmax[6];//, minmax2[6], minmax3[6], minmax4[6], minmax5[6], minmax6[6];
//		float model1=0, model2=0, model3=0, model4=0, model5=0, model6=0, average;
		
//		int count=0;
		mdx_getBoundingBox (glw->getModel (0), minmax);
/*		model1 = (minmax[3]+minmax[2])/2;
		
		if(glw->getModel (1)){
			mdx_getBoundingBox (glw->getModel (1), minmax2);
			count++;
			model2 = (minmax2[3]+minmax2[2])/2;
		}
		if(glw->getModel (2)){
			mdx_getBoundingBox (glw->getModel (2), minmax3);
			count++;
			model3 = (minmax3[3]+minmax3[2])/2;
		}
		if(glw->getModel (3)){
			mdx_getBoundingBox (glw->getModel (3), minmax4);
			count++;
			model4 = (minmax4[3]+minmax4[2])/2;
		}
		if(glw->getModel (4)){
			mdx_getBoundingBox (glw->getModel (4), minmax5);
			count++;
			model5 = (minmax5[3]+minmax5[2])/2;
		}
		if(glw->getModel (5)){
			mdx_getBoundingBox (glw->getModel (5), minmax6);
			count++;
			model6 = (minmax6[3]+minmax6[2])/2;
		}
		
		average = (model1+model2+model3+model4+model5+model6)/count;*/
		
		// center vertically
		glw->d_transY = (minmax[3] + minmax[2]) / 2;
//		glw->d_transY = average;

		// adjust distance
		float dx = minmax[1] - minmax[0];
		float dy = minmax[3] - minmax[2];
		float dz = minmax[5] - minmax[4];

		float d = dx;
		if (dy > d)
			d = dy;

		if (dz > d)
			d = dz;

		glw->d_transZ = d * 1.2f;
		glw->d_transX = 0;
		glw->d_rotX = glw->d_rotY = 0.0f;
	}
}



bool
MDXViewer::loadModel (const char *ptr, int pos)
{
	mdx_model_t *model = glw->loadModel (ptr,  pos);
	if (!model)
		return false;

	static char path2[256];

	static char path[256];

	_splitpath (path, 0, path2, 0, 0);

	strcpy (path, path2);
	SetCurrentDirectory (path);

	if (pos == 0)
	{	
		initAnimation (model, -1);
		setModelInfo (model, 0);
		glw->loadTexture (0, TEXTURE_MODEL);
		setRenderMode (0);
		centerModel ();					
	}
	else if (pos == 1)
	{
		setModelInfo (model, 1);
		glw->loadTexture (0, TEXTURE_WEAPON);
	}
	else if (pos == 2)
	{
		setModelInfo (model, 2);
		glw->loadTexture (0, TEXTURE_MODEL3);
	}
	else if (pos == 3)
	{
		setModelInfo (model, 3);
		glw->loadTexture (0, TEXTURE_MODEL4);
	}
	else if (pos == 4)
	{
		setModelInfo (model, 4);
		glw->loadTexture (0, TEXTURE_MODEL5);
	}
	else if (pos == 5)
	{
		setModelInfo (model, 5);
		glw->loadTexture (0, TEXTURE_MODEL6);
	}

	glw->redraw ();

	return true;
}



void
MDXViewer::setModelInfo (mdx_model_t *model, int pos)
{
	static char str[1024];

	if(pos==0)
	{
		if (model)
		{
			sprintf (str,
				"Skins: %d\n"
				"Vertices: %d\n"
				"Triangles: %d\n"
				"GlCommands: %d\n"
				"Frames: %d\n",
				model->header.numSkins,
				model->header.numVertices,
				model->header.numTriangles,
				model->header.numGlCommands,
				model->header.numFrames
				);
				Skins = model->header.numSkins;
				Vertices = model->header.numVertices;
				Triangles = model->header.numTriangles;
				GlCommands = model->header.numGlCommands;
				Frames = model->header.numFrames;
		}
		else
			strcpy (str, "No Models.");
		
		
	}
	else //rest of models
	{
		if (model)
		{
			Skins += model->header.numSkins;
			Vertices += model->header.numVertices;
			Triangles += model->header.numTriangles;
			GlCommands += model->header.numGlCommands;
			sprintf (str,
				"Skins: %d\n"
				"Vertices: %d\n"
				"Triangles: %d\n"
				"GlCommands: %d\n"
				"Frames: %d\n",
				Skins,
				Vertices,
				Triangles,
				GlCommands,
				Frames
				);
		}
	}
	lModelInfo1->setLabel (str);
}



void
MDXViewer::initAnimation (mdx_model_t *model, int animation)
{
	cAnim->removeAll ();

	if (!model)
		return;

	int count = mdx_getAnimationCount (model);

	cAnim->add ("<All Animations>");

	for (int i = 0; i < count; i++)
		cAnim->add (mdx_getAnimationName (model, i));

	int startFrame, endFrame;
	mdx_getAnimationFrames (model, animation, &startFrame, &endFrame);
	glw->setFrameInfo (startFrame, endFrame);

	if (animation == -1)
		glw->setFrameInfo (0, model->header.numFrames - 1);

	cAnim->select (animation + 1);
}

void
MDXViewer::initAVIAnimation (mdx_model_t *model, int animation, int *startFrame, int *endFrame)
{
	if (!model)
		return;

	mdx_getAnimationFrames (model, animation, startFrame, endFrame);
	
}


int MDXViewer::MakeAVI(int start, int end)
{
	if(!glw->getModel(0)) return 0;
		
	char *outfn = (char *)malloc(256);
	int fps = 0;
	int img_width, img_height;
	int frame_num, avi_frame;
	char *pattern = (char *)malloc(256);
	int frame_begin, frame_end, frame_step;
	char fn[1024];

	mxImage *in = new mxImage ();
	mxImage *tga = new mxImage ();

	LPBITMAPINFOHEADER bih;
	PAVIFILE af = NULL;
	AVISTREAMINFO asi;
	PAVISTREAM as = NULL, ascomp = NULL;
	AVICOMPRESSOPTIONS opts;
	AVICOMPRESSOPTIONS FAR * aopts[1] = {&opts};
	HANDLE dib;
	int memsize;
	int test2 = NULL;
	char *test3 = NULL;

	outfn = (char *)mxGetSaveFileName (this, 0, "*.avi");
	if(!outfn)
		return 0;

	if((test3 = strstr(outfn, ".avi"))==NULL)
 			strcat(outfn, ".avi");
	
	fps = 10;
	strcpy(pattern, "shot%04d.tga");

	//frame_begin = 1;
	frame_begin = start;
	//frame_end = glw->getModel(0)->header.numFrames;
	frame_end = end;
	frame_step = 1;

	if (frame_end < frame_begin) ERR("Invalid end frame!");
	if (frame_step < 1) ERR("Invalid frame step!");
	
	//check for existance and format of first frame 
	sprintf(fn, pattern, frame_begin);
	char *test = (char *)malloc(256);
	GetTempPath (256, test);
	strcat(test, "/");
	strcat(test, fn);
	makeScreenShot (test);
	
	tga = mxTgaRead(test);
	if (!tga) return 0;

	img_width = tga->width;
	img_height = tga->height;
	remove (test);

	// allocate DIB 
	memsize = sizeof(BITMAPINFOHEADER) + (img_width*img_height*3);
	dib = GlobalAlloc(GHND,memsize);
	bih = (LPBITMAPINFOHEADER)GlobalLock(dib);

	bih->biSize = sizeof(BITMAPINFOHEADER);
	bih->biWidth = img_width;
	bih->biHeight = img_height; // negative = top-down 
	bih->biPlanes = 1;
	bih->biBitCount = 24; // B,G,R 
	bih->biCompression = BI_RGB;
	bih->biSizeImage = memsize - sizeof(BITMAPINFOHEADER);
	bih->biXPelsPerMeter = 0;
	bih->biYPelsPerMeter = 0;
	bih->biClrUsed = 0;
	bih->biClrImportant = 0;

	if (HIWORD(VideoForWindowsVersion()) < 0x010a)
		ERR("VFW is too old");

	AVIFileInit();
	AVIERR( AVIFileOpen(&af, outfn, OF_WRITE | OF_CREATE, NULL) );

	// header 
	memset(&asi, 0, sizeof(asi));
	asi.fccType	= streamtypeVIDEO;// stream type
	asi.fccHandler	= 0;
	asi.dwScale	= 1;
	asi.dwRate	= fps;
	asi.dwSuggestedBufferSize  = bih->biSizeImage;
	SetRect(&asi.rcFrame, 0, 0, img_width, img_height);

	AVIERR( AVIFileCreateStream(af, &as, &asi) );

	memset(&opts, 0, sizeof(opts));

	if (!AVISaveOptions(NULL, 0, 1, &as,
		(LPAVICOMPRESSOPTIONS FAR *) &aopts))
	{
		return 0;
	}

	AVIERR( AVIMakeCompressedStream(&ascomp, as, &opts, NULL) );

	AVIERR( AVIStreamSetFormat(ascomp, 0,
			       bih,	    // stream format
			       bih->biSize) ); // format size

	avi_frame = 0;
	frame_num = 1;

	int current = glw->getCurrFrame ();
	
	//bar->setTotalSteps(glw->getModel(0)->header.numFrames);
	bar->setTotalSteps(end-start);

	mxImage *flip = new mxImage ();

	int cnt=0;
	//for (int frame = 1;frame<=glw->getModel(0)->header.numFrames;frame++,frame_num++)
	for (int frame = start;frame<=end;frame++,frame_num++, cnt++)
	{		
		//Increment progress bar
		bar->setValue(cnt);
				
		//init strings
		char *filename = (char *)malloc(256);
		char *str = (char *)malloc(32);
		char *path = (char *)malloc(256);

		//Set to first frame and take a shot
		glw->setFrameInfo (frame, frame);
		sprintf (str, "%d", glw->getCurrFrame ());
		leFrame->setLabel (str);
		glw->redraw ();
		sprintf (filename, "/shot%04d.tga", frame);
		GetTempPath (256, path);
		strcat (path, filename);
		makeScreenShot (path);

		//Create an AVI file
		in = mxTgaRead(path);
		if (!in) return 0;

		//Flip the image
		flip->data = (unsigned char *)malloc(in->height*in->width*3);
		flip->height = in->height;
		flip->width = in->width;

		int len = (flip->height*flip->width*3)-1;

		for(int i=0;i<=(flip->height*flip->width*3)-1;i++,len--)
			flip->data[i]=in->data[len];
		
		for (long y=0; y<flip->height; y++) 
		{ 
			long left = y*flip->width*3; 
			long right = left + flip->width*3 - 3; 
			for (long x=0; x<flip->width*0.5; x++) 
			{ 
				unsigned char tempRed   = flip->data[left]; 
				unsigned char tempGreen = flip->data[left+1]; 
				unsigned char tempBlue  = flip->data[left+2]; 
				
				flip->data[left]   = flip->data[right]; 
				flip->data[left+1] = flip->data[right+1]; 
				flip->data[left+2] = flip->data[right+2]; 
				
				flip->data[right]   = tempRed; 
				flip->data[right+1] = tempGreen; 
				flip->data[right+2] = tempBlue; 
				
				left  += 3; 
				right -= 3; 
			} 
		} 

		memcpy((LPBYTE)(bih) + sizeof(BITMAPINFOHEADER), 
			flip->data, bih->biSizeImage);

		AVIERR( AVIStreamWrite(ascomp,	// stream pointer
			avi_frame,		// time of this frame
			1,			// number of frames to write
			(LPBYTE)(bih) + sizeof(BITMAPINFOHEADER),
			bih->biSizeImage,	// size of this frame
			0,			// flags
			NULL,
			NULL) );
	
		avi_frame++;

		//Clean up the mess
		remove (path);
		delete [] str;
		delete [] filename;
		delete [] path;

	}

	//Close AVI Stuff
	if (ascomp) AVIStreamClose(ascomp);
	if (as) AVIStreamClose(as);
	if (af) AVIFileClose(af);
	GlobalUnlock(dib);
	AVIFileExit();

	//Set to initial frame
	char *str = (char *)malloc(32);
	glw->setFrameInfo (current, current);
	sprintf (str, "%d", glw->getCurrFrame ());
	leFrame->setLabel (str);
	glw->redraw ();
	delete [] str;

	free(in->data);
	free(tga->data);
	free(flip->data);
	
	in->~mxImage();
	tga->~mxImage();
	flip->~mxImage();

	delete in;
	delete tga;
	delete flip;
	
	bar->setValue(0);
	int n = _heapmin();
	return 1;
}


int
main (int argc, char *argv[])
{
	//
	// make sure, we start in the right directory
	//
	SetCurrentDirectory (mx::getApplicationPath ());

	mx::init (argc, argv);

	if(argc>1)
	{
		loadmod = (char *)malloc(256);
		strcpy(loadmod, argv[1]);
	}

	g_mdxViewer = new MDXViewer ();
	g_mdxViewer->setMenuBar (g_mdxViewer->getMenuBar ());

	return mx::run ();
}
