#ifndef INCLUDED_MD2
#define INCLUDED_MD2

#define MD2_MAX_TRIANGLES		4096
#define MD2_MAX_VERTICES		2048
#define MD2_MAX_TEXCOORDS		2048
#define MD2_MAX_FRAMES			1024
#define MD2_MAX_SKINS			32
#define MD2_MAX_FRAMESIZE		(MD2_MAX_VERTICES * 4 + 128)

typedef struct 
{ 
   int magic; 
   int version; 
   int skinWidth; 
   int skinHeight; 
   int frameSize; 
   int numSkins; 
   int numVertices;
   //mdx tri
   int numTexCoords; 
   int numTriangles; 
   int numGlCommands; 
   int numFrames; 
   int offsetSkins; 
   int offsetTexCoords; 
   int offsetTriangles; 
   int offsetFrames; 
   int offsetGlCommands; 
   int offsetEnd; 
} md2_header_t;

typedef struct
{
   byte vertex[3];
   byte lightNormalIndex;
} md2_alias_triangleVertex_t;

typedef struct
{
   float vertex[3];
   float normal[3];
} md2_triangleVertex_t;

typedef struct
{
   short vertexIndices[3];
   short textureIndices[3];
} md2_triangle_t;

typedef struct
{
	short s;
	short t;
} md2_textureCoordinate_t; //md2 only. software tex cords(per pixel)

typedef struct
{
   float scale[3];
   float translate[3];
   char name[16];
   md2_alias_triangleVertex_t alias_vertices[1];
} md2_alias_frame_t;

typedef struct
{
	float scale[3]; //hypov8
	float translate[3]; //hypov8
	char name[16];
	md2_triangleVertex_t *vertices;
} md2_frame_t;

typedef char md2_skin_t[64];

typedef struct
{
	float s;
	float t;
   int vertexIndex;
} md2_glCommandVertex_t;

typedef struct
{
	md2_header_t			header;
	md2_skin_t				*skins;
	md2_textureCoordinate_t	*texCoords;
	md2_triangle_t			*triangles;
	md2_frame_t				*frames;
	byte					*framesBuffer;
	int						*glCommandBuffer;
	int						isMD2;
	float					min[3];
	float					max[3];
} md2_model_t;


#ifdef __cplusplus
extern "C" {
#endif

md2_model_t *md2_readModel (const char *filename);
mdx_model_t *md2_Parse_readModel(const char *filename); //hypov8

void md2_freeModel (md2_model_t *model);


#ifdef __cplusplus
}
#endif



#endif /* INCLUDED_MD2 */
