/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <iostream.h>
#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>

#include "md2.h"

CMD2::CMD2 ()
{
	m_index_list = NULL;
	m_frame_list = NULL;
	m_iFrames = m_iVertices = m_iTriangles = 0;
}

CMD2::~CMD2 ()
{
	int i;

	if (m_frame_list != NULL) {

		for (i = 0; i < m_iFrames; i++)
			delete [] m_frame_list[i].vertex;

		delete [] m_frame_list;
	}

	if (m_index_list != NULL)
		delete [] m_index_list;
}

void CMD2::Destroy (void)
{
	int i;

	if (m_frame_list != NULL) {

		for (i = 0; i < m_iFrames; i++)
			delete [] m_frame_list[i].vertex;

		delete [] m_frame_list;
		m_frame_list = NULL;
	}

	if (m_index_list != NULL) {
		delete [] m_index_list;
		m_index_list = NULL;
	}
}

int CMD2::Read (char filename[])
{
	FILE		*modelfile = NULL;
	char		g_skins[MAX_MD2SKINS][64];
	dstvert_t	base_st[MAX_VERTS];
	byte		buffer[MAX_VERTS*4+128];
	dmdl_t		modelheader;

	dtriangle_t     tri;
	daliasframe_t	*out;

	int i, j;

	if ((modelfile = fopen (filename, "rb")) == NULL)
		return 0;

	SafeRead (modelfile, &modelheader, sizeof(modelheader));

	modelheader.framesize = (int)&((daliasframe_t *)0)->verts[modelheader.num_xyz];

	////////////////////////////////////////////////////

	m_iFrames		= modelheader.num_frames;
	m_iVertices		= modelheader.num_xyz;
	m_iTriangles	= modelheader.num_tris;

	m_index_list = new make_index_list [modelheader.num_tris];
	m_frame_list = new make_frame_list [modelheader.num_frames];

	for (i = 0; i < modelheader.num_frames; i++)
		m_frame_list[i].vertex = new make_vertex_list [modelheader.num_xyz];

	////////////////////////////////////////////////////

	SafeRead (modelfile, g_skins, modelheader.num_skins * MAX_SKINNAME);

	SafeRead (modelfile, base_st, modelheader.num_st * sizeof(base_st[0]));

	for (i = 0; i < modelheader.num_tris; i++) {
		SafeRead (modelfile, &tri, sizeof(dtriangle_t));

		(m_index_list)[i].a = tri.index_xyz[2];
		(m_index_list)[i].b = tri.index_xyz[1];
		(m_index_list)[i].c = tri.index_xyz[0];

		(m_index_list)[i].a_s = base_st[tri.index_st[2]].s;
		(m_index_list)[i].a_t = base_st[tri.index_st[2]].t;
		(m_index_list)[i].b_s = base_st[tri.index_st[1]].s;
		(m_index_list)[i].b_t = base_st[tri.index_st[1]].t;
		(m_index_list)[i].c_s = base_st[tri.index_st[0]].s;
		(m_index_list)[i].c_t = base_st[tri.index_st[0]].t;
	}

	for (i = 0; i < modelheader.num_frames; i++) {

		out = (daliasframe_t *)buffer;

		SafeRead (modelfile, out, modelheader.framesize);

		for (j = 0; j < modelheader.num_xyz; j++) {

			(m_frame_list)[i].vertex[j].x = out->verts[j].v[0] * out->scale[0] + out->translate[0];
			(m_frame_list)[i].vertex[j].y = out->verts[j].v[1] * out->scale[1] + out->translate[1];
			(m_frame_list)[i].vertex[j].z = out->verts[j].v[2] * out->scale[2] + out->translate[2];
		}
	}

	fclose (modelfile);
	return 1;
}