/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>
#include <stdio.h>

static OPENFILENAME ofn ;

void LoadMD2FileInitialize (HWND hwnd)
{
     static char szFilter[] = "Quake2 MD2 Model (*.MD2)\0*.md2\0";

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hwnd ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;          // Set in Open and Close functions
     ofn.nMaxFile          = _MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;          // Set in Open and Close functions
     ofn.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = "Open .MD2 File";
     ofn.Flags             = 0 ;             // Set in Open and Close functions
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = "md2" ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;
     }

BOOL LoadMD2FileOpenDlg (HWND hwnd, PSTR pstrFileName, PSTR pstrTitleName)
{
	/* initialize the OPENFILENAME structure members */
	LoadMD2FileInitialize (hwnd);

	ofn.hwndOwner         = hwnd ;
	ofn.lpstrFile         = pstrFileName ;
	ofn.lpstrFileTitle    = pstrTitleName ;
	ofn.Flags             = OFN_OVERWRITEPROMPT;

	return GetOpenFileName (&ofn) ;
}

void LoadPCXFileInitialize (HWND hwnd)
{
     static char szFilter[] = "Quake2 PCX Texture (*.PCX)\0*.pcx\0";

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hwnd ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;          // Set in Open and Close functions
     ofn.nMaxFile          = _MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;          // Set in Open and Close functions
     ofn.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = "Open .PCX File";
     ofn.Flags             = 0 ;             // Set in Open and Close functions
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = "pcx" ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;
     }

BOOL LoadPCXFileOpenDlg (HWND hwnd, PSTR pstrFileName, PSTR pstrTitleName)
{
	/* initialize the OPENFILENAME structure members */
	LoadPCXFileInitialize (hwnd);

	ofn.hwndOwner         = hwnd ;
	ofn.lpstrFile         = pstrFileName ;
	ofn.lpstrFileTitle    = pstrTitleName ;
	ofn.Flags             = OFN_OVERWRITEPROMPT;

	return GetOpenFileName (&ofn) ;
}