/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <stdio.h>
#include <iostream.h>

#include <windows.h>
#include <windowsx.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "wingl.h"

void COpenGLWindow::Create (HWND hWnd)
{
	m_hdc = ::GetDC(hWnd);
	SetupPixelFormat ();
	SetupPalette ();
	m_hGLRC = wglCreateContext (m_hdc);
	wglMakeCurrent(m_hdc, m_hGLRC);
}

void COpenGLWindow::SetSize (int iX, int iY)
{
	m_sizeX = iX;
	m_sizeY = iY;
}

void COpenGLWindow::GetSize (int *iX, int *iY)
{
	if (iX != NULL && iY != NULL)
	{
		m_sizeX = *iX;
		m_sizeY = *iY;
	}
}

void COpenGLWindow::Destroy (HWND hWnd)
{
	if (m_hGLRC) {
		wglMakeCurrent (NULL, NULL);
		wglDeleteContext(m_hGLRC);
	}

	if (m_hPalette) {
		DeleteObject (m_hPalette);
	}

	ReleaseDC(hWnd, m_hdc);
}

BOOL COpenGLWindow::GLRCValid ()
{
	if (m_hGLRC)
		return TRUE;
	else
		return FALSE;
}

BOOL COpenGLWindow::PaletteValid ()
{
	if (m_hPalette)
		return TRUE;
	else
		return FALSE;
}

HDC COpenGLWindow::GetDC ()
{
	return m_hdc;
}

void COpenGLWindow::RedoPalette ()
{
	UnrealizeObject (m_hPalette);
	SelectPalette (m_hdc, m_hPalette, FALSE);
	RealizePalette (m_hdc);
}

void COpenGLWindow::SetupPixelFormat ()
{
	PIXELFORMATDESCRIPTOR pfd = {
		sizeof(PIXELFORMATDESCRIPTOR),  /* size */
		1,                              /* version */
		PFD_SUPPORT_OPENGL |
		PFD_DRAW_TO_WINDOW |
		PFD_DOUBLEBUFFER,               /* support double-buffering */
		PFD_TYPE_RGBA,                  /* color type */
		16,                             /* prefered color depth */
		0, 0, 0, 0, 0, 0,               /* color bits (ignored) */
		0,                              /* no alpha buffer */
		0,                              /* alpha bits (ignored) */
		0,                              /* no accumulation buffer */
		0, 0, 0, 0,                     /* accum bits (ignored) */
		16,                             /* depth buffer */
		0,                              /* no stencil buffer */
		0,                              /* no auxiliary buffers */
		PFD_MAIN_PLANE,                 /* main layer */
		0,                              /* reserved */
		0, 0, 0,                        /* no layer, visible, damage masks */
	};
	int pixelFormat;

	pixelFormat = ChoosePixelFormat(m_hdc, &pfd);
	if (pixelFormat == 0) {
		MessageBox(WindowFromDC(m_hdc), "ChoosePixelFormat failed.", "Error",
			MB_ICONERROR | MB_OK);
		exit(1);
	}

	if (SetPixelFormat(m_hdc, pixelFormat, &pfd) != TRUE) {
		MessageBox(WindowFromDC(m_hdc), "SetPixelFormat failed.", "Error",
			MB_ICONERROR | MB_OK);
		exit(1);
	}
}

void COpenGLWindow::SetupPalette ()
{
	int pixelFormat = GetPixelFormat(m_hdc);
	PIXELFORMATDESCRIPTOR pfd;
	LOGPALETTE* pPal;
	int paletteSize;

	DescribePixelFormat(m_hdc, pixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

	if (pfd.dwFlags & PFD_NEED_PALETTE) {
		paletteSize = 1 << pfd.cColorBits;
	} else {
		return;
	}

	pPal = (LOGPALETTE*)
		malloc(sizeof(LOGPALETTE) + paletteSize * sizeof(PALETTEENTRY));
	pPal->palVersion = 0x300;
	pPal->palNumEntries = paletteSize;

	/* build a simple RGB color palette */
	{
		int redMask = (1 << pfd.cRedBits) - 1;
		int greenMask = (1 << pfd.cGreenBits) - 1;
		int blueMask = (1 << pfd.cBlueBits) - 1;
		int i;

		for (i=0; i<paletteSize; ++i)
		{
			pPal->palPalEntry[i].peRed =
				(((i >> pfd.cRedShift) & redMask) * 255) / redMask;
			pPal->palPalEntry[i].peGreen =
				(((i >> pfd.cGreenShift) & greenMask) * 255) / greenMask;
			pPal->palPalEntry[i].peBlue =
				(((i >> pfd.cBlueShift) & blueMask) * 255) / blueMask;
			pPal->palPalEntry[i].peFlags = 0;
		}
	}

	m_hPalette = (HPALETTE)CreatePalette(pPal);
	free(pPal);

	if (m_hPalette) {
		SelectPalette(m_hdc, m_hPalette, FALSE);
		RealizePalette(m_hdc);
	}
}
