//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "stdafx.h"
#include "MedDLe.h"
#include "MedDLeExp.h"
#include "MedDLeGif.h"

void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h);
void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h);
void write_gif(char *name, unsigned char *pic, unsigned w, unsigned h);


//  export mdl frame to :  asc,pov,wrl,raw,dfx,map,(3ds  almost)
void export_mdl_frame(char *filename, int frame, CMedDLeDoc *pDoc)
{
	#include "normals.h"

	// frame is really frame-1 since indices start at 0

	strlwr(filename);
	char  *ptr;


	///////////////////////////////// asc (3ds) out
	if(strstr(filename,".asc"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		//if(out==NULL) { printf("can't create file\n"); getch(); return; }


		fprintf(out,"Ambient light color: Red=0.039216 Green=0.039216 Blue=0.039216\n\n");
		fprintf(out,"Named object: \"%s\"\n",pDoc->Frames[frame]->name);
		fprintf(out,"Tri-mesh, Vertices: %d    Faces: %d\n",(int)pDoc->num.vertices,(int)pDoc->num.triangles);
		fprintf(out,"Vertex list:\n");
		for(int i=0; i<pDoc->num.vertices; i++)
		{
			fprintf(out,"Vertex %d:  X: %lf  Y: %lf  Z: %lf\n",i,
				pDoc->Frames[frame]->fv[i].v[1],
				-pDoc->Frames[frame]->fv[i].v[0],
				pDoc->Frames[frame]->fv[i].v[2]);
		}
		fprintf(out,"Face list:\n");
		for(i=0; i<pDoc->num.triangles; i++)
		{
			// reverse order and say that no sides lie in a plane
			fprintf(out,"Face %d:  A:%u B:%u C:%u AB:1 BC:1 CA:1\n",i,
			pDoc->Tris[i].vindex[0],
			pDoc->Tris[i].vindex[2],
			pDoc->Tris[i].vindex[1]);
//			fprintf(out,"Smoothing:  %d\n",1);
		}

		fclose(out);
	}
	///////////////////////////////// wrl out
	else if(strstr(filename,".wrl") || strstr(filename,".wrz"))
	{

		FILE *out;
		out=fopen(filename,"wt");
		if(out==NULL) { return;}
		fprintf(out,"#VRML V1.0 ascii\n\n# Created by MedDLe\n# by Brian Martin\n# brian@phyast.pitt.edu\n\n");
		fprintf(out,"Separator {\n");
		fprintf(out,"\tPerspectiveCamera {\n");
		fprintf(out,"\t\tposition    0. 0. 100.\n");
		fprintf(out,"\t}\n");
		fprintf(out,"\tDEF %s Separator {\n",pDoc->Frames[frame]->name );


		fprintf(out,"\t\tMaterial { diffuseColor [ 0.5 0.5 0.5 ] }\n");
		fprintf(out,"\t\tTexture2 {\n");
		fprintf(out,"\t\t\tfilename \"skin.gif\"\n");
		fprintf(out,"\t\t}\n");

		// these are all the 2d points including the seemed ones
		fprintf(out,"\t\tTextureCoordinate2 {\n");
		fprintf(out,"\t\t\tpoint [\n");
		for(int i=0; i<pDoc->num.vertices; i++)
		{
			float s,t;
			s=pDoc->Verts[i].x;
			t=pDoc->SkinH-pDoc->Verts[i].y;
			s/=(float)pDoc->SkinW;
			t/=(float)pDoc->SkinH;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		// add ones on seem plus extras
		for(i=0; i<pDoc->num.vertices; i++)
		{
			float s,t;
			s=pDoc->SkinW/2+pDoc->Verts[i].x;
			t=pDoc->SkinH-pDoc->Verts[i].y;
			s/=(float)pDoc->SkinW;
			t/=(float)pDoc->SkinH;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		fprintf(out,"\t\t\t]\n\t\t}\n");

		fprintf(out,"\t\tCoordinate3 {\n\t\tpoint [\n");
		for( i=0; i<pDoc->num.vertices ;i++)
		{
			// vrml wacky coordinate system...
			fprintf(out,"\t\t\t%lf %lf %lf,\n",
			-pDoc->Frames[frame]->fv[i].v[1],
			pDoc->Frames[frame]->fv[i].v[2],
			pDoc->Frames[frame]->fv[i].v[0]);
		}
/*
		fprintf(out,"\t\t\t]\n\t\t}\n");
		fprintf(out,"\t\tIndexedFaceSet {\n");
		fprintf(out,"\t\tcoordIndex [\n");
		for( int i=0; i<num.triangles ;i++)
		{
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			Tris[i].vindex[0],
			Tris[i].vindex[1],
			Tris[i].vindex[2] );
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\ttextureCoordIndex [\n");
		int x1,x2,x3;
		unsigned p1,p2,p3,p4;
		unsigned offset=num.vertices;
		for(int i=0;i<num.triangles;i++)
		{
			p1=Tris[i*4+1];
			p2=triangle[i*4+2];
			p3=triangle[i*4+3];
			p4=triangle[i*4];
			x1=x2=x3=0;
			if((vertex[3*p1]==32)&&(p4==0)) x1=1;
			if((vertex[3*p2]==32)&&(p4==0)) x2=1;
			if((vertex[3*p3]==32)&&(p4==0)) x3=1;

			BG_Line(vertex[p1*3+1]+x1,vertex[p1*3+2],vertex[p2*3+1]+x2,vertex[p2*3+2],8);
			BG_Line(vertex[p2*3+1]+x2,vertex[p2*3+2],vertex[p3*3+1]+x3,vertex[p3*3+2],8);
			BG_Line(vertex[p3*3+1]+x3,vertex[p3*3+2],vertex[p1*3+1]+x1,vertex[p1*3+2],8);
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			p1+x1*offset,
			p2+x2*offset,
			p3+x3*offset);
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\t}\n");

		fprintf(out,"\t}\n");
		fprintf(out,"}"); //end
*/
		fclose(out);
	}

	return;


}

void export_mdl_skin(char *filename, int skin, CMedDLeDoc *pDoc )
{
	strlwr(filename);
	char  *ptr;

	if(strstr(filename,".gif"))
	{
		int	i,j, Error, NumFiles, ExtCode;
		GifRecordType RecordType;
		GifByteType *Extension;
		GifRowType *ImageBuffer;
		GifFileType *GifFileOut = NULL;
		ColorMapObject CM;
		CM.Colors=new GifColorType[256];

		if((skin<pDoc->Skins.GetSize())&&(skin>=0))
		{
			write_gif(filename, pDoc->Skins[skin]->bitmap, pDoc->SkinW, pDoc->SkinH);
		}
		// new skin (polygon pic)
		if(skin<0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new unsigned char [pDoc->SkinW*pDoc->SkinH];

			for(j=0; j<pDoc->SkinH; j++)
			{
				for(i=0; i<pDoc->SkinW; i++)
				{
					pic[i+pDoc->SkinW*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<pDoc->num.triangles;i++)
			{
				p1=pDoc->Tris[i].vindex[0];
				p2=pDoc->Tris[i].vindex[1];
				p3=pDoc->Tris[i].vindex[2];
				p4=pDoc->Tris[i].flags;
				x1=x2=x3=0;
				if((pDoc->Verts[p1].Mflags&MDL_ONSEEM)&&(p4==0)) x1=pDoc->SkinW/2;
				if((pDoc->Verts[p2].Mflags&MDL_ONSEEM)&&(p4==0)) x2=pDoc->SkinW/2;
				if((pDoc->Verts[p3].Mflags&MDL_ONSEEM)&&(p4==0)) x3=pDoc->SkinW/2;
				v1[0]=pDoc->Verts[p2].x+x2;
				v1[1]=pDoc->Verts[p2].y;
				v2[0]=pDoc->Verts[p3].x+x3;
				v2[1]=pDoc->Verts[p3].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p3].x+x3;
				v1[1]=pDoc->Verts[p3].y;
				v2[0]=pDoc->Verts[p1].x+x1;
				v2[1]=pDoc->Verts[p1].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p1].x+x1;
				v1[1]=pDoc->Verts[p1].y;
				v2[0]=pDoc->Verts[p2].x+x2;
				v2[1]=pDoc->Verts[p2].y;
				vline(pic,v1,v2,pDoc);

			}

			write_gif(filename, pic, pDoc->SkinW, pDoc->SkinH);
			delete [] pic;
		}

		delete [] CM.Colors;

	}
	else if(strstr(filename,".bmp"))
	{
		FILE *out;
		int i,j;
		if((skin<pDoc->Skins.GetSize())&&(skin>=0))
		{
			out=fopen(filename,"wb");
			BG_WriteBMP(out, MedDLePalette, pDoc->Skins[skin]->bitmap, pDoc->SkinW, pDoc->SkinH);
			fclose(out);
		}
		// new skin (polygon pic)
		if(skin<0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new unsigned char [pDoc->SkinW*pDoc->SkinH];

			for(j=0; j<pDoc->SkinH; j++)
			{
				for(i=0; i<pDoc->SkinW; i++)
				{
					pic[i+pDoc->SkinW*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<pDoc->num.triangles;i++)
			{
				p1=pDoc->Tris[i].vindex[0];
				p2=pDoc->Tris[i].vindex[1];
				p3=pDoc->Tris[i].vindex[2];
				p4=pDoc->Tris[i].flags;
				x1=x2=x3=0;
				if((pDoc->Verts[p1].Mflags&S_ONSEEM)&&(p4==0)) x1=pDoc->SkinW/2;
				if((pDoc->Verts[p2].Mflags&S_ONSEEM)&&(p4==0)) x2=pDoc->SkinW/2;
				if((pDoc->Verts[p3].Mflags&S_ONSEEM)&&(p4==0)) x3=pDoc->SkinW/2;
				v1[0]=pDoc->Verts[p2].x+x2;
				v1[1]=pDoc->Verts[p2].y;
				v2[0]=pDoc->Verts[p3].x+x3;
				v2[1]=pDoc->Verts[p3].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p3].x+x3;
				v1[1]=pDoc->Verts[p3].y;
				v2[0]=pDoc->Verts[p1].x+x1;
				v2[1]=pDoc->Verts[p1].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p1].x+x1;
				v1[1]=pDoc->Verts[p1].y;
				v2[0]=pDoc->Verts[p2].x+x2;
				v2[1]=pDoc->Verts[p2].y;
				vline(pic,v1,v2,pDoc);
				
			}
			out=fopen(filename,"wb");
			BG_WriteBMP(out, MedDLePalette, pic, pDoc->SkinW, pDoc->SkinH);
			fclose(out);
			delete [] pic;
		}
	}

}

void vline(unsigned char *pic, int *v1, int *v2, CMedDLeDoc *pDoc)
{

			int i;
			register int inc_ah,inc_al;
			int dx,dy,long_d,short_d;
			int d,add_dh,add_dl;
			int inc_xh,inc_yh,inc_xl,inc_yl;

			dx=v2[0]-v1[0]; dy=v2[1]-v1[1];

			if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}
			else    {        inc_xh=1;  inc_xl=1; }

			if(dy<0){dy=-dy;inc_yh=-pDoc->SkinW;
					 inc_yl=-pDoc->SkinW;
					 }
			else    {       inc_yh= pDoc->SkinW;
					 inc_yl= pDoc->SkinW;
			}
			 if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;}
			else     {long_d=dy;short_d=dx;inc_xl=0;}

			inc_ah=inc_xh+inc_yh;
			inc_al=inc_xl+inc_yl;
			pic+=v1[1]*pDoc->SkinW+v1[0];

			d=2*short_d-long_d;
			add_dl=2*short_d;
			add_dh=2*short_d-2*long_d;

			for(i=0;i<=long_d;i++)
			{
				*pic=11;
				if(d>=0){pic+=inc_ah; d+=add_dh;}
				else    {pic+=inc_al; d+=add_dl;}
			}

}

void write_gif(char *fname, unsigned char *pic, unsigned w, unsigned h)
{
	int	i,j, Error, NumFiles, ExtCode;
	GifRecordType RecordType;
	GifByteType *Extension;
	GifRowType *ImageBuffer;
	GifFileType *GifFileOut = NULL;
	ColorMapObject CM;
	CM.Colors=new GifColorType [256];

	GifFileOut = EGifOpenFileName(fname,0);
	EGifSetGifVersion("87a");
	int expc=8;
	// set palette
	CM.ColorCount=256;
	CM.BitsPerPixel=8;
	for(i=0; i<256; i++)
	{
		CM.Colors[i].Red=MedDLePalette[i*3];
		CM.Colors[i].Green=MedDLePalette[i*3+1];
		CM.Colors[i].Blue=MedDLePalette[i*3+2];
	}
	EGifPutScreenDesc(GifFileOut,w,h,8,0,&CM);
	EGifPutImageDesc(GifFileOut,0, 0, w, h, 0, NULL);
	for (i = 0; i < h; i++)
	{
		EGifPutLine(GifFileOut, pic+i*w, w);
	}
	EGifCloseFile(GifFileOut);
}

struct BMP_HEADER{

	unsigned filesize;
	short int reserved1;
	short int reserved2;
	int headersize;
	int infosize;
	int width;
	int height;
	short int planes;
	short int bits;
	int compression;
	int sizeimage;
	int xpelspermeter;
	int ypelspermeter;
	int colorsused;
	int colorsimportant;

};


void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h)
{
	unsigned i, j, k;
	unsigned size;

	unsigned char *temp;
	int readsize;

	BMP_HEADER bmpfile;

	bmpfile.filesize = w*h + sizeof(bmpfile) + 1024L+2L;
	bmpfile.reserved1 = 0;
	bmpfile.reserved2 = 0;
	bmpfile.headersize =  sizeof(bmpfile) + 1024L + 2L;
	bmpfile.infosize = 40;

	bmpfile.width = w;
	bmpfile.height = h;

	bmpfile.planes = 1;
	bmpfile.compression = 0;
	bmpfile.bits = 8;
	bmpfile.xpelspermeter = 1181L;
	bmpfile.ypelspermeter = 1181L;
	bmpfile.colorsused = 256;
	bmpfile.colorsimportant = 256;

	bmpfile.sizeimage = w*h;

	fwrite("BM",2,1, out);
	fwrite(((char *)(&bmpfile)), sizeof(bmpfile), 1L, out);

	for (i = 0; i < 256; i++)
	{
		fputc(pal[i*3 + 2], out);
		fputc(pal[i*3 + 1], out);
		fputc(pal[i*3 + 0], out);
		fputc(0, out);
	}

	int ali;
	if(w<4)  ali=4-w;
	else ali=w%4;

		for(j=h;j>0;j--)
		{
			for(i=0;i<w;i++)
			{
				fwrite(pic+i+w*(j-1),1,1,out);

			}
			for(i=0;i<ali;i++)
			{
				fputc(0,out);
			}
		}


}

void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h)
{
    unsigned i, j;
    unsigned size;
    unsigned x,y;

    char t[2];
    int readsize;
    unsigned char ch;

    rewind(in);
	fseek(in,18,SEEK_SET);
    fread(&x,4,1,in);
    fread(&y,4,1,in);
    fseek(in,28,SEEK_CUR);

    w[0]=x;
    h[0]=y;

    for (i = 0; i < 256; i++)
    {
		fread(pal+i*3 + 2,1,1,in);
		fread(pal+i*3 + 1,1,1,in);
		fread(pal+i*3 + 0,1,1,in);
		fseek(in,1,SEEK_CUR);
	}
	unsigned char junk[4];
	int ali;
	if(x<4) ali=4-x;
	else ali=x%4;


	for(j=y;j>0;j--)
	{
		for(i=0;i<x;i++)
		{
			fread(pic+i+x*(j-1),1,1,in);
		}
		if(ali!=0) fread(&junk[0],ali,1,in);
	}

}
