#include "stdafx.h"
#include "..\MedDLeGFX\MedDLeTypes.h"
#include "..\MedDLeGFX\MedDLe3D.h"
#include "IOASC.h"

BOOL IOASCRead(LPCSTR fname, CMedDLeObject &mo)
{
	FILE *in;
	in=fopen(fname,"rt");
	if(in==NULL) return FALSE;

	CStdioFile sin(in);

	//while(Read3DOTag(sin,mo));

	sin.Close();



	return 0;
}

BOOL IOASCWrite(LPCSTR fname,CMedDLeObject &mo)
{

	CString str;
	str.Format("start");
//	AfxMessageBox(str);

	FILE *out;

	out=fopen(fname,"wt");
	if(out==NULL)  return 0;

	int v=mo.m_BaseFrame->v.GetSize();
	int f=mo.m_BaseFrame->f.GetSize();
	fprintf(out,"Ambient light color: Red=0.039216 Green=0.039216 Blue=0.039216\n\n");
	fprintf(out,"Named object: \"%s\"\n","Object1");
	fprintf(out,"Tri-mesh, Vertices: %d    Faces: %d\n",v,f);
	fprintf(out,"Vertex list:\n");
	str.Format("%d %d",v,f);

	for(int i=0; i<v; i++)
	{
		fprintf(out,"Vertex %d:  X: %lf  Y: %lf  Z: %lf\n",i,
			mo.m_Frames[0]->v[i].x[1],
			-mo.m_Frames[0]->v[i].x[0],
			mo.m_Frames[0]->v[i].x[2]);
	}
	fprintf(out,"Face list:\n");
	for(i=0; i<f; i++)
	{
		// reverse order and say that no sides lie in a plane
		fprintf(out,"Face %d:  A:%u B:%u C:%u AB:1 BC:1 CA:1\n",i,
		mo.m_BaseFrame->f[i].vindex[0],
		mo.m_BaseFrame->f[i].vindex[2],
		mo.m_BaseFrame->f[i].vindex[1]);
	}

	fclose(out);
	
	return TRUE;
}

