// CMedDLeTypes.h
#include <afxwin.h>		// template header for CArray
#include <afxtempl.h>		// template header for CArray
//#include <d3d.h>

#define V_GROW_N 500
#define F_GROW_N 500
#define L_GROW_N 500

#ifndef __MEDDLETYPES_H
#define __MEDDLETYPES_H

// 3d primative things
class CMedDLePoint3D
{
public:
	CMedDLePoint3D();
	CMedDLePoint3D(float, float, float);
	CMedDLePoint3D(const CMedDLePoint3D &);
	CMedDLePoint3D& operator= (const CMedDLePoint3D &);
	float x[3];
	float wx[3];
};

typedef CMedDLePoint3D CMedDLeVector;


class CMedDLeMatrix
{
public:
	CMedDLeMatrix();
	CMedDLeMatrix(const CMedDLeMatrix&);
	CMedDLeMatrix(const float);
//	CMedDLeMatrix& operator =(const CMedDLeMatrix&);
	CMedDLeMatrix& operator =(const float);
	float& operator()(int iRow, int iColumn) { return m[iRow][iColumn]; }
	const float& operator()(int iRow, int iColumn) const { return m[iRow][iColumn]; }
	
	float m[4][4];
};


class CMedDLePosition // viewer orientation
{
public:
	CMedDLePosition();
	CMedDLePosition(const CMedDLePosition&);
	CMedDLePosition& operator =(const CMedDLePosition&);

	void SetTargert(CMedDLePoint3D &);
	void SetTargert(CMedDLePosition *);

	CMedDLePosition *pTarget;		// position
	CMedDLePoint3D	Target;
	CMedDLeMatrix	Orientation;	// direction matrix
};

// Vertex-----------------------
// flags
#define V_SELECTED	1
#define V_VISIBLE	2
#define V_TEMP_SELECTED	4

class CMedDLeVertex : public CMedDLePoint3D
{

public:
	CMedDLeVertex();
	~CMedDLeVertex();
	CMedDLeVertex(float x, float y, float z);
	CMedDLeVertex(const CMedDLeVertex&);
	CMedDLeVertex& operator= (const CMedDLeVertex &);

	// All Vertex Related Data
	CMedDLeVector n;			// Light/Normal Index

};
class CMedDLeBaseVertex 
{

public:
	CMedDLeBaseVertex();
	~CMedDLeBaseVertex();
	CMedDLeBaseVertex(float x, float y, float z);
	CMedDLeBaseVertex(const CMedDLeBaseVertex&);
	CMedDLeBaseVertex& operator= (const CMedDLeBaseVertex &);

	//BYTE vnormal;			// Light/Normal Index
	DWORD flags;				// Flags
	DWORD group;				// Object & Group ID#s
	DWORD bone;				// Skeleton Segment ID#
	DWORD color;

};

class CMedDLeFace
{			// Triangle Definition
public:
	CMedDLeFace();
	CMedDLeFace(UINT n1, UINT n2, UINT n3);
	CMedDLeFace(const CMedDLeFace&);
	CMedDLeFace& operator= (const CMedDLeFace &);

	DWORD vindex[3];		// Three Vertexes
	DWORD flags;			// Flags Including FRONT
	//DWORD Vflags;			// View Based Flags
	// surface appearence
	DWORD linecolor[3];			// Line segment colors
	DWORD group;				// Object & Group ID#s
	DWORD color;			// face color
	DWORD bone;				// Skeleton Segment ID#
	//POINT pt[3];			// texture coord
	float tx[3][2];
	DWORD texture;
};

class CMedDLeLine
{			// Triangle Definition
public:
	CMedDLeLine();
	CMedDLeLine(UINT n1, UINT n2);
	CMedDLeLine(const CMedDLeLine&);
	CMedDLeLine& operator= (const CMedDLeLine &);

	DWORD vindex[2];		// Three Vertexes
	DWORD flags;			// Flags Including FRONT
	DWORD color;			// Line segment colors
};

#define T_UNKNOWN	0
#define T_8BIT		1
#define T_15BIT		2
#define T_24BIT		3

class CMedDLeTexture
{	
public:
	CMedDLeTexture();
	~CMedDLeTexture();
	CMedDLeTexture(const CMedDLeTexture&);
	CMedDLeTexture& operator= (const CMedDLeTexture &);

	CString name;
	DWORD size[2];
	BYTE *header;
	BITMAPINFOHEADER *bmpheader; // Image Data For Skin
	RGBQUAD *colors;
	BYTE *bitmap;			// Image Data For Skin
	BOOL Read(LPCSTR Filename);
	BOOL Write(LPCSTR Filename, int quality=100);
	BOOL Attach();
	BOOL Detach();
	int count;
};

// flags
#define G_SELECTED	1
#define G_VISIBLE	2
#define G_TEMP_SELECTED	4
#define G_LOCKED	8

class CMedDLeGroup
{				
public:
	CMedDLeGroup();
	CMedDLeGroup(const CMedDLeGroup&);
	CMedDLeGroup& operator= (const CMedDLeGroup &);
	CString name;
	DWORD color;
	DWORD flags;
	int bone;

};

class CMedDLeFrame
{				// Frame

public:
	CMedDLeFrame();
	~CMedDLeFrame();
	CMedDLeFrame(const TCHAR *n);
	CMedDLeFrame(const CMedDLeFrame&);
	CMedDLeFrame& operator= (const CMedDLeFrame &);
	CMedDLeFrame operator+ (const CMedDLeFrame &);
	void GetMinMax();

	CMedDLeVertex min;
	CMedDLeVertex max;
	CString name;			// Frame's Name
	CArray <CMedDLeVertex, CMedDLeVertex&> v;
	CString	animation;
	DWORD   duration;

};

class CMedDLeMeshAnimation
{

public:
	CMedDLeMeshAnimation();
	~CMedDLeMeshAnimation();
	CMedDLeMeshAnimation(const CMedDLeMeshAnimation&);

	CString name;
	CArray <int, int&> framelist;
	CArray <int, int&> durationlist;
};

// flags
#define B_SELECTED	1
#define B_VISIBLE	2
#define B_TEMP_SELECTED	4
#define B_LOCKED	8
#define B_FAKE		16
#define B_HSEL		32
#define B_TSEL		64

class CMedDLeBone 
{	
public:
	CMedDLeBone();
	~CMedDLeBone();
	CMedDLeBone(const CMedDLeBone&);
	CMedDLeBone& operator= (const CMedDLeBone &);

	CMedDLePoint3D head;
	CMedDLePoint3D tail;
	CMedDLeMatrix  orientation;

	CString			name;
	int 			parent;
	CArray <int, int&> kid;

	DWORD			flags;
	float			length;
	float			twist;
};

class CMedDLeBaseFrame
{				// Frame

public:
	CMedDLeBaseFrame();
	~CMedDLeBaseFrame();
	CMedDLeBaseFrame(const TCHAR *n);
	CMedDLeBaseFrame(const CMedDLeBaseFrame&);
	CMedDLeBaseFrame& operator= (const CMedDLeBaseFrame &);
	CMedDLeBaseFrame operator+ (const CMedDLeBaseFrame &);
	CMedDLeBaseFrame operator& (const DWORD flag);

	void ClearAll();
//	void DeleteSelected();
//	void CopySelected(const CMedDLeBaseFrame &);
//	void AddFace(CMedDLeVertex &,CMedDLeVertex &,CMedDLeVertex &);

	CString name;
	CArray <CMedDLeBaseVertex, CMedDLeBaseVertex&> v;
	CArray <CMedDLeFace, CMedDLeFace&> f;
	CArray <CMedDLeLine, CMedDLeLine&> l;
	CArray <CMedDLeGroup, CMedDLeGroup&> g;

	CArray <CMedDLeBone, CMedDLeBone&> b;

	CArray <CMedDLeTexture*, CMedDLeTexture*> t;
};


struct CGrid {				// Grid Object
	float fSpacing;
	BOOL bSnap;	
	BOOL bVisible;
	BOOL bAxis;				// draw axis
	//float fSize[3];			// Range
	DWORD flags;			// Flags
};

#endif