// medDLe Math.h
#define PI 3.141592653

#ifndef __MEDDLEMATH_H
#define __MEDDLEMATH_H
#include <math.h>

CMedDLePoint3D Normalize(CMedDLePoint3D &a);
float DotProduct (const CMedDLePoint3D& v1, const CMedDLePoint3D& v2);
CMedDLePoint3D CrossProduct (const CMedDLePoint3D& v1, const CMedDLePoint3D& v2);
CMedDLePoint3D operator + (const CMedDLePoint3D &p1, const CMedDLePoint3D &p2);
CMedDLePoint3D operator - (const CMedDLePoint3D &p1, const CMedDLePoint3D &p2);





CMedDLeMatrix MatrixMultiply(const CMedDLeMatrix &m0,const CMedDLeMatrix &m1);
CMedDLeMatrix Translate(const float dx, const float dy, const float dz);
CMedDLeMatrix RotateX(const float rads);
CMedDLeMatrix RotateY(const float rads);
CMedDLeMatrix RotateZ(const float rads);
CMedDLeMatrix Scale(const float size);
CMedDLeMatrix ViewMatrix(const CMedDLePoint3D from,      // camera location
                            const CMedDLePoint3D at,        // camera look-at target
                            const CMedDLePoint3D world_up,  // worlds up, usually 0, 1, 0
                            const float roll);          // clockwise roll around
CMedDLeMatrix ProjectionMatrix(const float near_plane,     // distance to near clipping plane
                                  const float far_plane,      // distance to far clipping plane
                                  const float fov);            // field of view angle, in radians

#endif