// 2DView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// C2DView view
#ifndef __2DVIEW_H
#define __2DVIEW_H

enum ViewAction {VA_NULL,
	VA_SELECT,VA_ZOOM,VA_SCALE,VA_ROTATE,VA_TRANSLATE,
	VA_SNAPTRI,VA_SNAPTRANS,VA_STARTTRI,VA_MOVETRI,
	VA_MOVEBONE};
class CChildFrame;
class C2DView : public CView
{
protected:
	C2DView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(C2DView)

// Attributes
public:
	//selection variables
	int HitPointIndex(CPoint &pt);
	int m_nLastHitIndex;
	void SelectRect(CRect &rc);
	CRect m_rcSelection;
	CPoint m_ptSelection0;
	CPoint m_ptSelection1;
	BOOL m_bHittingVert;


	ViewAction m_ViewAction;

	BOOL m_bLStarted, m_bRStarted;
	BOOL m_bMotion;
	CPoint m_ptOld;
	CPoint m_ptClicked;
	
	int ViewNum;
	CChildFrame* Parent;
	int row, col;
	BOOL Init;
	int PClicked;
	int ObjN, GrpN;
	BOOL IsSelected;
	int PMapped;
	BOOL DeSel;


public:
	void TriHit(CPoint point);
// was in doc
//	CPoint m_ptCenter;				// View Centers
//	float m_fZoom;					// Zoom Level
//	float m_fScale;					// Global Scale Value
	
	int AxisMap[2];				// Axis Maps
	int AxisDir[2];				// Axis Direction
	DWORD Vflags;				// View Flags

//	BOOL Restrict[3];				// Axis Motion Restrictions
//	BOOL ClearBlue;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(C2DView)
	public:
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~C2DView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(C2DView)
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnViewIn();
	afx_msg void OnViewOut();
	afx_msg void OnUpdateViewIn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewOut(CCmdUI* pCmdUI);
	afx_msg void OnViewSolid();
	afx_msg void OnUpdateViewSolid(CCmdUI* pCmdUI);
	afx_msg void OnViewVerts();
	afx_msg void OnUpdateViewVerts(CCmdUI* pCmdUI);
	afx_msg void OnAddselbone();
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif