// StdTranslators.cpp : Defines the entry point for the DLL application.
//

#include "StdAfx.h"

#include <IL/il.h>

#include "ModelGeneric.h"

#include "StdTranslators.h"

#include "3DSTranslator.h"
#include "MD2Translator.h"
#include "MD3Translator.h"
#include "MD3CompleteTranslator.h"
#include "ASETranslator.h"
#include "OBJTranslator.h"
#include "DotGraphExporter.h"

#include "PCDTranslator.h"
#include "LBMTranslator.h"
#include "PICTranslator.h"
#include "CUTTranslator.h"
#include "WALTranslator.h"
#include "LIFTranslator.h"
#include "LWOTranslator.h"

#include "DevilTranslator.h"

#ifdef WIN32
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }

    // Initialize the DevIL, don't touch any IL function before calling
    // this one or your computer will explode
    ilInit();

    // Check if we're using the correct version of the DevIL
    if (ilGetInteger(IL_VERSION_NUM) < IL_VERSION)
    {
       // NOTE: Should actually print this to the logging file..
       OutputDebugString("WARNING: The DevIL DLL doesn't match the internal version");
       return false;
    }

    return true;
}

STDTRANSLATORS_API int ModQueryVersion(long *Dest) {
   memcpy(Dest, MODEL_API_VERSION, 4);
   return 1;
}

STDTRANSLATORS_API int ModQueryDesc(char *Dest) {
   strcpy(Dest, "This is the description for the Standard Translators dll file");
   return 1;
}

STDTRANSLATORS_API int ModQueryCount() {
   return 24;
}

STDTRANSLATORS_API int ModRegister(MSystemManager *SysMan, int IDNo) {

   switch (IDNo)
   {
   case 0:
     return SysMan->getPluginManager()->registerSceneTranslator(new MMD2Translator);
     break;
   case 1:
     return SysMan->getPluginManager()->registerSceneTranslator(new MMD3Translator);
     break;
   case 2:
     return SysMan->getPluginManager()->registerSceneTranslator(new MMD3CompleteTranslator);
     break;
   case 3:
     return SysMan->getPluginManager()->registerSceneTranslator(new M3DSTranslator);
     break;
   case 4:
     return SysMan->getPluginManager()->registerSceneTranslator(new MASETranslator);
     break;
   case 5:
     return SysMan->getPluginManager()->registerImageTranslator(new MWALTranslator);
     break;
   case 6:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::TGA));
     break;
   case 7:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::TIF));
     break;
   case 8:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::SGI));
     break;
   case 9:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::RAW));
     break;
   case 10:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::PNM));
     break;
   case 11:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::PNG));
     break;
   case 12:
     return SysMan->getPluginManager()->registerImageTranslator(new MPICTranslator);
     break;
   case 13:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::PCX));
     break;
   case 14:
     return SysMan->getPluginManager()->registerImageTranslator(new MPCDTranslator);
     break;
   case 15:
     return SysMan->getPluginManager()->registerImageTranslator(new MLIFTranslator);
     break;
   case 16:
     return SysMan->getPluginManager()->registerImageTranslator(new MLBMTranslator);
     break;
   case 17:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::JPG));
     break;
   case 18:
     return SysMan->getPluginManager()->registerImageTranslator(new MCUTTranslator);
     break;
   case 19:
     return SysMan->getPluginManager()->registerImageTranslator(new DevilTranslator(DevilTranslator::BMP));
     break;
   case 20:
     return SysMan->getPluginManager()->registerSceneTranslator(new MOBJTranslator);
     break;
   case 21:
     return SysMan->getPluginManager()->registerSceneTranslator(new MLWOTranslator);
     break;
   case 22:
     return SysMan->getPluginManager()->registerSceneTranslator(new DotGraphExporter);
     break;
   }

   return 0;
}
#endif
