#include "StdAfx.h"
#include "LWOTranslator.h"

#include "MBaseObject.h"
#include "MSystemManager.h"
#include "MAnimMesh.h"
#include "MMeshShape.h"
#include "HelperFuncs.h"
#include "MMath.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>
#include <sys/stat.h>
#include <assert.h>


/*#define GEN_ID(a,b,c,d) ((((long)(a))<<24)| \
			(((long)(b))<<16)| \
			(((long)(c))<< 8)| \
			(((long)(d)) ))

#define FORM GEN_ID('F','O','R','M')
#define LWOB GEN_ID('L','W','O','B')
#define PNTS GEN_ID('P','N','T','S')
#define SRFS GEN_ID('S','R','F','S')
#define SURF GEN_ID('S','U','R','F')
#define POLS GEN_ID('P','O','L','S')
#define COLR GEN_ID('C','O','L','R')
#define FLAG GEN_ID('F','L','A','G')
#define DIFF GEN_ID('D','I','F','F')
#define VDIF GEN_ID('V','D','I','F')
#define SMAN GEN_ID('S','M','A','N')*/

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



MLWOTranslator::MLWOTranslator()
{
}

MLWOTranslator::~MLWOTranslator()
{
}

// Class related
MTranslatorPtr MLWOTranslator::createNew() const {
  MLWOTranslator   *NewTranslator;
  
  NewTranslator = new MLWOTranslator;
  
  return NewTranslator;
}

bool MLWOTranslator::canImportFile(MStr Filename) {
  FILE *hFile;
  
  Filename.Replace('/', '\\');
  hFile = fopen(Filename, "rb");
  
  if (!hFile)
    return false;

  char chunk[5];
  fread(chunk, 1, 4, hFile);
  chunk[4]= 0;
  if (strcmp(chunk,"FORM") != 0)
    {
	  fclose(hFile);
      return false;
    }
  
  fread(chunk, 1, 4, hFile);  //Read past the filesize 

  fread(chunk, 1, 4, hFile);
  chunk[4]= 0;
  if (strcmp(chunk,"LWOB") != 0)
    {
	  fclose(hFile);
      return false;
    }
  
  fclose(hFile);
  
  return true;
}

bool MLWOTranslator::importFile(MStr Filename, MScenePtr Scene) {
  int pt_count;
  int poly_count;
  int surf_count =0;
  Vec3Df *AllPts;
  poly **AllPolys;
  lwoSurface *AllSurfs;
  read_lwo(Filename.c_str(), AllPts, AllPolys, AllSurfs, pt_count, poly_count, surf_count);
  
  
  MAnimMeshPtr Mesh;
  Mesh = new MAnimMesh;
  MEditableMeshPtr SkinMesh;
  SkinMesh = new MEditableMesh;

  MVector3 *verts = new MVector3[pt_count];
  MStr MasterObjName = "Temp"; // Temp for now
  
  // Add vertices
  for (int i = 0; i < pt_count; i++)
  {
    verts[i].x = AllPts[i].x;
    verts[i].y = AllPts[i].y;
    verts[i].z = AllPts[i].z;
  }

  Mesh->addVertexArray(verts, pt_count);

  
  // Add triangles
  {
    MTriangle *tris = new MTriangle[poly_count];

    for (int i = 0; i < poly_count; ++i) {
      tris[i].setVertex(0, AllPolys[i]->vert[0]);
      tris[i].setVertex(1, AllPolys[i]->vert[1]);
      tris[i].setVertex(2, AllPolys[i]->vert[2]);
    }

    Mesh->addTriangleArray(tris, poly_count);
    delete[] tris;
  }


  // Add colour values for each triangle
  {
    MVector3 colour;
    int surfIndex;


    for (int i = 0; i < poly_count; i++)
	{
      surfIndex = AllPolys[i]->surf - 1;
	  colour.set(AllSurfs[surfIndex].r, AllSurfs[surfIndex].g, AllSurfs[surfIndex].b);
    
      Mesh->setTriangleColour(i, colour);
	}
  }


  Mesh->setTextureMesh(SkinMesh);
  Mesh->setName(MasterObjName + "Mesh");
  Mesh->calculateNormals();

  MMeshShapePtr meshShape;
  meshShape = new MMeshShape(Mesh);
  Mesh->setName(MasterObjName + "Shape");

  MSceneObjectPtr sceneObj =  new MSceneObject (meshShape);
  //sceneObj->setTextureMaterial(SkinMaterial);
  sceneObj->setName(MasterObjName);

  MTreeObjectNodePtr NewObjNode;

  NewObjNode = Scene->addObject(sceneObj);

  delete[] verts;
	
  return true;
}

bool MLWOTranslator::exportFile(MStr Filename, MScenePtr Scene) {
  return false;
}

/*******************/

signed long MLWOTranslator::rev(signed long &value) {
// changes order of the 4 bytes in the longword
// necessary because of the lwo-specs

  signed long old_value;
  old_value= value;
  char *l1,*l2;
  l1= (char *) &value;
  l2= (char *) &old_value;
  l1[0]= l2[3];
  l1[1]= l2[2];
  l1[2]= l2[1];
  l1[3]= l2[0];
  return value;
}


float MLWOTranslator::rev(float &value) {
// changes order of the 4 bytes in the longword
// necessary because of the lwo-specs

  float old_value;
  old_value= value;
  char *l1,*l2;
  l1= (char *) &value;
  l2= (char *) &old_value;
  l1[0]= l2[3];
  l1[1]= l2[2];
  l1[2]= l2[1];
  l1[3]= l2[0];
  return value;
}


unsigned long MLWOTranslator::rev(unsigned long &value) {
// changes order of the 4 bytes in the longword
// necessary because of the lwo-specs

  unsigned long old_value;
  old_value= value;
  char *l1,*l2;
  l1= (char *) &value;
  l2= (char *) &old_value;
  l1[0]= l2[3];
  l1[1]= l2[2];
  l1[2]= l2[1];
  l1[3]= l2[0];
  return value;
}

signed short MLWOTranslator::rev(signed short &value) {
// changes order of the 4 bytes in the longword
// necessary because of the lwo-specs

  signed short old_value;
  old_value= value;
  char *l1,*l2;
  l1= (char *) &value;
  l2= (char *) &old_value;
  l1[0]= l2[1];
  l1[1]= l2[0];
  return value;
}

unsigned short MLWOTranslator::rev(unsigned short &value) {
// changes order of the 4 bytes in the longword
// necessary because of the lwo-specs

  unsigned short old_value;
  old_value= value;
  char *l1,*l2;
  l1= (char *) &value;
  l2= (char *) &old_value;
  l1[0]= l2[1];
  l1[1]= l2[0];
  return value;
}


void MLWOTranslator::read_chunk_PNTS(FILE *lwo_file, Vec3Df *&AllPts, int &pt_count) {
// reads the list of all points in a chunk
 
  unsigned long length;

  fread(&length, 1, 4, lwo_file); rev(length);
  AllPts= (Vec3Df *) malloc(length);
  pt_count= length / 12;    // every vector is three floats in size
 
  fread(AllPts, 12, pt_count, lwo_file);

  // every floats read have to be converted again...
  Vec3Df *coordinate;
  coordinate= (Vec3Df *) AllPts;
  for (long pt= 0; pt < pt_count; pt++)
    {
     rev(coordinate->x);
     rev(coordinate->y);
     rev(coordinate->z);
     coordinate++;
    }

  // and perhaps read a pad-byte
  if (length & 1)
    {
     int pad;
     fread(&pad, 1, 1, lwo_file);
    }
}


void MLWOTranslator::read_chunk_POLS(FILE *lwo_file, poly **&AllPolys, int &poly_count) {
// reads the polygon-data-chunk
 
  unsigned long length;
  poly_count= 0; // number of polygons

  fread(&length, 1, 4, lwo_file); rev(length);
  char *PolyMem= (char *) malloc(length);  // temporary memory for data
  fread(PolyMem, 1, length, lwo_file);

  int dataoffs= 0;

  // extract polygon data
  unsigned short us_temp;
  AllPolys= NULL;
  do {
      // add new polygon to list
      poly_count++;

      AllPolys= (poly **) realloc(AllPolys, 4*poly_count);
      AllPolys[poly_count-1]= (poly *) malloc(sizeof(poly));
      
      // extract number of vertices
      memcpy(&us_temp,&PolyMem[dataoffs],2);
      rev(us_temp);
      AllPolys[poly_count-1]->numvert= us_temp;
      dataoffs += 2;
      
      // allocate vertex-list
      AllPolys[poly_count-1]->vert= (unsigned short *) malloc(us_temp*2);
      // copy vertice-numbers in list
      memcpy(AllPolys[poly_count-1]->vert,&PolyMem[dataoffs],us_temp*2);
      dataoffs += us_temp*2;
      for (long i= 0; i < AllPolys[poly_count-1]->numvert; i++)
        {
         rev(AllPolys[poly_count-1]->vert[i]);
	}
      memcpy(&AllPolys[poly_count-1]->surf,&PolyMem[dataoffs],2);
      rev(AllPolys[poly_count-1]->surf);
      dataoffs += 2;
     } while (dataoffs < (signed int) length-1);
   
  if (length & 1)
    {
     int pad;
     fread(&pad, 1, 1, lwo_file);
    }
  free(PolyMem);
}


void MLWOTranslator::read_chunk_SRFS(FILE *lwo_file, lwoSurface *&AllSurfs, int &surf_count) {
  
  unsigned long length;

  AllSurfs = (lwoSurface *) malloc(sizeof(0));

  surf_count = 0 ;

  fread(&length, 1, 4, lwo_file); rev(length);

  char *SurfList= (char *) malloc(length);
  fread(SurfList,1,length,lwo_file);

  int strindx= 0;
  char *str= &SurfList[strindx];
  
  do {
	  surf_count++;
      str= &SurfList[strindx];
      
	  AllSurfs = (lwoSurface *) realloc(AllSurfs, sizeof(lwoSurface)*surf_count);
	  AllSurfs[surf_count-1].name = (char *)malloc(strlen(str)+1);
	  strncpy (AllSurfs[surf_count-1].name, str, strlen(str));
	  AllSurfs[surf_count-1].name[strlen(str)] = 0;

      strindx += strlen(str)+1;
      if (strlen(str+1) & 1)
        strindx++;
     } while ((strindx < (signed int) length) && (strlen(str) > 0));

  if (length & 1)
    {
     int pad;
     fread(&pad, 1, 1, lwo_file);
    }
}

void MLWOTranslator::read_chunk_SURF(FILE *lwo_file, lwoSurface *&AllSurfs, const int surf_count) {

  long length;
  
  int i;
  char name[LW_MAX_NAME_LEN];
  lwoSurface *material = NULL;

  fread(&length, 1, 4, lwo_file); 
  rev(length);

  // get surface name
  char c;
  int n;
  int cnt = 0;
  do {
	fread (&c, 1, 1, lwo_file);
    if (cnt < LW_MAX_NAME_LEN)
      name[cnt] = c;
    else
      name[LW_MAX_NAME_LEN-1] = 0;
    cnt++;
  } while (c != 0);
  
  // check for pad byte
  if (cnt%2) 
  {
	fread(&c, 1, 1, lwo_file);
    cnt++;
  }

  length -= cnt;

  /* find material */
  for (i=0; i< surf_count; i++) 
  {
    if (strcmp(AllSurfs[i].name,name) == 0) 
	{
      material = &AllSurfs[i];
      break;
    }
  }

  // read in values
  while (length > 0) 
  {
	char id[5];
	fread(&id, 1, 4, lwo_file);
	id[4] = 0;
	
	unsigned short len;
	fread(&len, 1, 2, lwo_file);
	rev(len);
	
	length -= 6 + len + (len%2);
	
    if (strcmp(id,"COLR") == 0) 
	{
	  // Read in RGB values for surface
	  n = fgetc(lwo_file);
      material->r = n / 255.0f;
	  
	  n = fgetc(lwo_file);
      material->g = n / 255.0f;
	  
	  n = fgetc(lwo_file);
      material->b = n / 255.0f;
      
	  // Get ride of extra byte pad
	  fread (&c, 1, 1, lwo_file); 	
    }
	else if (strcmp(id,"FLAG") == 0)
	{
      //TODO
	  fseek(lwo_file, len+(len%2), SEEK_CUR);
	}
	else if (strcmp(id,"DIFF") == 0)
	{
	  //TODO
	  fseek(lwo_file, len+(len%2), SEEK_CUR);
	}
	else if (strcmp(id,"VDIF") == 0)
	{
	  fseek(lwo_file, len+(len%2), SEEK_CUR);
	}
	else if (strcmp(id,"SMAN") == 0)
	{
	  //TODO
	  fseek(lwo_file, len+(len%2), SEEK_CUR);
	}
	else
	{
	  //TODO
      fseek(lwo_file, len+(len%2), SEEK_CUR);
    }
  }
}


void MLWOTranslator::read_chunk(FILE *lwo_file, Vec3Df *&AllPts, poly **&AllPolys, lwoSurface *&AllSurfs, int &pt_count, int &poly_count, int &surf_count) {
  char chunk[5];
  fread(chunk, 1, 4, lwo_file);
  if (feof(lwo_file))
    return;     // end of file reached
  chunk[4]= 0;  // "convert" chunk-name into string
  
  if (strcmp(chunk,"PNTS") == 0)
    read_chunk_PNTS(lwo_file,AllPts,pt_count);
  else
    if (strcmp(chunk,"POLS") == 0)
      read_chunk_POLS(lwo_file,AllPolys,poly_count);
    else
      if (strcmp(chunk,"SRFS") == 0)
	  {
		//Crashes here usually
        read_chunk_SRFS(lwo_file,AllSurfs,surf_count);
	  }
      else
        if (strcmp(chunk,"SURF") == 0)
          read_chunk_SURF(lwo_file,AllSurfs, surf_count);
    else
      {
       // Unknown chunk - just read through it
       unsigned long length;
       fread(&length, 1, 4, lwo_file); 
	   rev(length);
       
       char *data= (char *) malloc(length);
       fread(data,1,length,lwo_file);
       if (length & 1)
         {
          int pad;
          fread(&pad, 1, 1, lwo_file);
         }
      }
}


bool MLWOTranslator::read_lwo(const char *filename, Vec3Df *&AllPts, poly **&AllPolys, lwoSurface *&AllSurfs, int &pt_count, int &poly_count, int &surf_count) {
  pt_count= poly_count= 0;

  FILE *lwo_file;
  if ((lwo_file= fopen(filename,"rb")) == NULL)
    {
     return 1;
    }
  

  char chunk[5];
  fread(chunk, 1, 4, lwo_file);
  chunk[4]= 0;
  if (strcmp(chunk,"FORM") == 0)
    {
      // TODO
    }
  else
    {
      return 1; 
    }
  unsigned long filesize;
  fread(&filesize, 1, 4, lwo_file); 
  rev(filesize);
  
  fread(chunk, 1, 4, lwo_file);
  chunk[4]= 0;
  if (strcmp(chunk,"LWOB") == 0)
    {
      // TODO
    }
  else
    {
      return 1;
    }

  while (!feof(lwo_file))
    read_chunk(lwo_file, AllPts, AllPolys, AllSurfs, pt_count, poly_count, surf_count);

  fclose(lwo_file);
  return 0;
}