#include "Stdafx.h"

#include <stdio.h>
#include <stdlib.h>


#include "PrimCSG.h"
#include "MSystemManager.h"

#include "Polycsg.h"

#include <params/MParameterFactory.h>


#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef WIN32
#define OutputDebugString(x) printf(x)
#endif

static char sbuf[512];

// ICK - having to refer to a global sucks.  However, since I want a subdiv to
// reference existing meshes, I need a way to get at them.
#include "MSystemManager.h"
extern MSystemManager *primSysMan;

MPrimitiveCSG::MPrimitiveCSG()
{
    // add in the mesh override parameter
  m_CSGOpParam = MParameterFactory::createChoice("csgOp", "csgOp", "CSG Op");
    m_CSGOpParam->addChoice("Collection");		// (A + B) Perform splits, but keep all triangles
    m_CSGOpParam->addChoice("Union");			// Remove internal pieces (A + B) - (A * B)
    m_CSGOpParam->addChoice("Intersection");	// Keep only internal pieces (A * B)
    m_CSGOpParam->addChoice("Difference1");		// (A - B)
    m_CSGOpParam->addChoice("Difference2");		// (B - A)
    m_CSGOpParam->setValueString("Collection");
	addParameter(m_CSGOpParam);

	int numChoices = m_CSGOpParam->getNumChoices();

	// Add two parameter objects that this CSG prim will operate upon.
	addParameter(m_InMeshParam1 = MParameterFactory::createObject("inMesh1", "inMesh1", "Mesh1"));
	addParameter(m_InMeshParam2 = MParameterFactory::createObject("inMesh2", "inMesh2", "Mesh2"));

    // add in the mesh override parameter
    // m_BuildBtn = new MButtonParameterObject("buildMesh", "buildMesh", "Build Mesh");
	// addParameter(m_BuildBtn);

	m_Mesh = NULL;
	m_Op = Union;
	m_RebuildFlag = false;

}

MPrimitiveCSG::~MPrimitiveCSG() {
}

MBaseObjectPtr MPrimitiveCSG::createNew() {
   MPrimitiveCSG *NewObj;

   NewObj = new MPrimitiveCSG;
   NewObj->m_ParamList->setFromList(getParamList());

   return NewObj;
}

MMeshPtr MPrimitiveCSG::convertToMesh() {
  updateObject();
  return m_Mesh;
}

// Get the mesh of the child, as transformed into world coordinates
MMeshPtr MPrimitiveCSG::
getChildMesh(MSceneObjectPtr sceneObj)
{
	MVector3 Vec;
	MTransformObjectPtr XForm;
	MScenePtr scene = primSysMan->getScene();

	if (sceneObj == NULL) {
		return NULL;
	}

	MShapeObjectPtr Child = sceneObj->getShapeObject();
	if (Child == NULL) {
		return NULL;
	}

	MEditableMeshPtr childMesh = new MEditableMesh(Child->convertToMesh());
	if (childMesh != NULL) {
		// Got a good mesh for this child.  Now get the transformation
		// from object coordinates to world coordinates.
		MMatrix4 Mat;
		MTreeObjectNodePtr ObjNode =
			scene->getObjectList()->findObject(sceneObj);
		if (ObjNode == NULL) {
			return NULL;
		}

		scene->getWorldTransformMatrix(ObjNode, Mat);

		int vcount = childMesh->getNumVerts();
		for (int vindex = 0; vindex < vcount; vindex++) {
			MVector3 vert = childMesh->getVertexPosition(vindex);
			vert = Mat * vert;
      childMesh->setVertexPosition(vindex, vert);
		}
	} else {
		return NULL;
	}

	return childMesh;
}

int MPrimitiveCSG::determineCSGOp()
{
	int choice = m_CSGOpParam->getCurrentChoice();

	switch (choice) {
	case 0:
		return CSG_COLLECTION;
	case 1:
		return CSG_UNION;
	case 2:
		return CSG_INTERSECTION;
	case 3:
		return CSG_DIFFERENCE1;
	case 4:
		return CSG_DIFFERENCE2;
	default:
		OutputDebugString("Bad CSG op, using collection\n");
		return CSG_COLLECTION;
	}
}

// TBD: track materials, u/v, and normals during the CSG operation.
void MPrimitiveCSG::rebuildMesh()
{

	MScenePtr scene = primSysMan->getScene();

#if 0
	if (!m_RebuildFlag) {
		// We only rebuild the mesh in response to a click of the button in
		// the channel bar.
		return m_Mesh;
	}
	m_RebuildFlag = false;
#endif

	MSceneObjectPtr sceneObj1, sceneObj2;
	sceneObj1 = AZTEC_CAST(MSceneObject, m_InMeshParam1->getValue());
	sceneObj2 = AZTEC_CAST(MSceneObject, m_InMeshParam2->getValue());
	if (sceneObj1 == NULL && sceneObj2 == NULL) {
		return;
	}

	// Create the mesh from a CSG operation on it's children
	MMeshPtr childMesh1, childMesh2;

	childMesh1 = getChildMesh(sceneObj1);
	childMesh2 = getChildMesh(sceneObj2);

	// If just one child, then make the mesh out of it.
	if (childMesh1 != NULL && childMesh2 == NULL) {
		// This is ok - just return the mesh for the one child.
	    m_Mesh = new MEditableMesh();
		m_Mesh->setFromMesh(childMesh1);
		return;
	} else if (childMesh1 == NULL && childMesh2 != NULL) {
		// This is ok - just return the mesh for the one child.
	    m_Mesh = new MEditableMesh();
		m_Mesh->setFromMesh(childMesh2);
		return;
	}


	// We now have the set of base meshes, converted into world coordinates.
	// Take the first and second entry in the array and perform the selected
	// CSG operation.  Repeat this process until all meshes have been whacked
	// against the first one.
	m_Mesh = new MEditableMesh();

#if 1
	PolyTriList child1, child2;

	int tindex, tcnt;
	MVector3 W[3];

	// Collect all triangles in the first mesh
	tcnt = childMesh1->getNumTris();
	for (tindex=0;tindex<tcnt;tindex++) {
		W[0] = childMesh1->getVertexPosition(childMesh1->getTriangleVertex(tindex, 0));
		W[1] = childMesh1->getVertexPosition(childMesh1->getTriangleVertex(tindex, 1));
		W[2] = childMesh1->getVertexPosition(childMesh1->getTriangleVertex(tindex, 2));

		child1.Push(new PolyTri(W, W, NULL, NULL));
	}

	// Collect all triangles in the second mesh
	tcnt = childMesh2->getNumTris();
	for (tindex=0;tindex<tcnt;tindex++) {
		W[0] = childMesh2->getVertexPosition(childMesh2->getTriangleVertex(tindex, 0));
		W[1] = childMesh2->getVertexPosition(childMesh2->getTriangleVertex(tindex, 1));
		W[2] = childMesh2->getVertexPosition(childMesh2->getTriangleVertex(tindex, 2));

		child2.Push(new PolyTri(W, W, NULL, NULL));
	}

	// Perform the actual CSG operation.
	PolyTriList resultTris;
	int op = determineCSGOp();
	MeshCSG(op, child1, child2, resultTris);

	// Now take the result of the CSG operation and glue the pieces back
	// into a single object.
	int numV, numT, offT, offV;
	numT = resultTris.size();
	numV = 3 * numT;
	MTriangle *triArray = new MTriangle[numT];
	MVector3 *vertArray = new MVector3[numV];

	offV = 0;
	offT = 0;
	PolyTriList::iterator triItr;
	for (triItr=resultTris.begin();triItr!=resultTris.end();triItr++) {
		PolyTriPtr tptr = *triItr;

		triArray[offT].setVertex(0, offV);
		vertArray[offV++] = tptr->Vertex(0);
		triArray[offT].setVertex(1, offV);
		vertArray[offV++] = tptr->Vertex(1);
		triArray[offT].setVertex(2, offV);
		vertArray[offV++] = tptr->Vertex(2);
		offT++;
	}

	// Add all the newly created vertices and faces to the mesh
	m_Mesh->addVertsAndTriangles(vertArray, triArray, numV, numT);

	delete[] vertArray;
	delete[] triArray;

	m_Mesh->weldVertices(0, 0.0);

	m_Mesh->calculateNormals();

#else
	// Quick hack: add all triangles from the child meshes into a bucket to see if
	// the transforms are working correctly.

	int numV = childMesh1->getNumVerts() + childMesh2->getNumVerts();
	int numT = childMesh1->getNumTris() + childMesh2->getNumTris();

	// Create array to hold all vertices and triangles
	MTriangle *triArray = new MTriangle[numT];
	MVector3 *vertArray = new MVector3[numV];

	// Copy vertices & triangles into arrays
	int offV = 0;
	int offT = 0;
	int vcnt1, tcnt1, vcnt2, tcnt2;

	// Copy from child mesh 1
#if 0
OutputDebugString("Child 1\n");
OutputDebugString("  Verts:\n");
#endif
	vcnt1 = childMesh1->getNumVerts();
	for (int vindex =0;vindex<vcnt1;vindex++) {
		vertArray[offV++] = *childMesh1->getVert(vindex);
#if 0
sprintf(sbuf, "  {%f, %f, %f}\n",
		vertArray[offV-1].x, vertArray[offV-1].y, vertArray[offV-1].z);
OutputDebugString(sbuf);
#endif
	}
	tcnt1 = childMesh1->getNumTris();
	for (int tindex =0;tindex<tcnt1;tindex++) {
		triArray[offT++] = *childMesh1->getTriangle(tindex);
	}

	// Add all the newly created vertices and faces to the mesh
	m_Mesh->addVertsAndTriangles(vertArray, triArray, vcnt1, tcnt1);

	// Copy from child mesh 2.  While doing so, make sure to update the
	// vertex indices so that they point to the vertices that came from
	// child mesh 2.
#if 0
OutputDebugString("Child 1\n");
OutputDebugString("  Verts:\n");
#endif
	vcnt2 = childMesh2->getNumVerts();
	for (int vindex =0;vindex<vcnt2;vindex++) {
		vertArray[offV++] = *childMesh2->getVert(vindex);
#if 0
sprintf(sbuf, "  {%f, %f, %f}\n",
		vertArray[offV-1].x, vertArray[offV-1].y, vertArray[offV-1].z);
OutputDebugString(sbuf);
#endif
	}
	tcnt2 = childMesh2->getNumTris();
	for (int tindex =0;tindex<tcnt2;tindex++) {
		triArray[offT++] = *childMesh2->getTri(tindex);
	}

	// Add all the newly created vertices and faces to the mesh
	m_Mesh->addVertsAndTriangles(&vertArray[vcnt1], &triArray[tcnt1], vcnt2, tcnt2);

	delete[] vertArray;
	delete[] triArray;
#endif
}

bool MPrimitiveCSG::doUpdateObject()
{
	MMeshCreator::doUpdateObject();
	rebuildMesh();
  getOutputParameter()->setValue(convertToMesh());
	return true;
}
