// ParticleParamDlg.cpp: implementation of the CParticleParamDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include "dialogs/ParticleParamDlg.h"
#include "dialogs/ParticleActionEditDlg.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleParamDlg::CParticleParamDlg()
{
	upBitmap = LoadBitmap(_Module.m_hInst, MAKEINTRESOURCE(IDB_UPARROW_BITMAP));
	downBitmap = LoadBitmap(_Module.m_hInst, MAKEINTRESOURCE(IDB_DOWNARROW_BITMAP));
	deleteBitmap = LoadBitmap(_Module.m_hInst, MAKEINTRESOURCE(IDB_DELETE_BITMAP));
	newBitmap = LoadBitmap(_Module.m_hInst, MAKEINTRESOURCE(IDB_NEW_BITMAP));

}

CParticleParamDlg::~CParticleParamDlg()
{
	DeleteObject(upBitmap);
	DeleteObject(downBitmap);
	DeleteObject(deleteBitmap);
	DeleteObject(newBitmap);
}

void  CParticleParamDlg::updateFromObject(MParticlePtr object)
{
	particleObj = object;

	if (particleObj == NULL) {
		return;
	}

	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_RESETCONTENT, NULL, NULL);

	// Quick check to see what is going on...
	char buf[128];
	OutputDebugString("Action List:\n");
	MPrimitiveParticle::actionListType::iterator alItr;
	for (alItr=particleObj->m_ActionList.begin();alItr!=particleObj->m_ActionList.end();alItr++) {
		sprintf(buf, "  %s", particleObj->actionEnumToString((*alItr).action));
		OutputDebugString(buf);
		SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_ADDSTRING, NULL, (LPARAM)buf);
		OutputDebugString("\n");

	}
	OutputDebugString("End Action List\n\n");
}

LRESULT CParticleParamDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	SendDlgItemMessage(IDC_MOVE_ACTION_UP_BUTTON, BM_SETIMAGE, IMAGE_BITMAP, (LPARAM)upBitmap);
	SendDlgItemMessage(IDC_MOVE_ACTION_DOWN_BUTTON, BM_SETIMAGE, IMAGE_BITMAP, (LPARAM)downBitmap);
	SendDlgItemMessage(IDC_DELETE_ACTION_BUTTON, BM_SETIMAGE, IMAGE_BITMAP, (LPARAM)deleteBitmap);
	SendDlgItemMessage(IDC_NEW_ACTION_BUTTON, BM_SETIMAGE, IMAGE_BITMAP, (LPARAM)newBitmap);

	return 0;
}

LRESULT CParticleParamDlg::OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	return 0;
}

LRESULT CParticleParamDlg::OnBnClickedDeleteActionButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// Which action did the user select?
	int selNum = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCURSEL, 0, 0);

	if (selNum == LB_ERR) {
		// Nothing selected - therefore nothing to delete.
		return 0;
	}

	// Remove the action itself
	particleObj->m_ActionList.erase(particleObj->m_ActionList.begin() + selNum);

	// Remove the name of the action from the list box
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_DELETESTRING, selNum, 0);

	return 0;
}

LRESULT CParticleParamDlg::OnBnClickedMoveActionDownButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if (particleObj == NULL) {
		return 0;
	}

	// How many actions currently in the list
	int selCount = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCOUNT, 0, 0);

	// Which action did the user select?
	int selNum = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCURSEL, 0, 0);

	if (selNum >= (selCount-1)) {
		// This entry is already at the bottom, don't need to do anything.
		return 0;
	}

	// Move the list box entry up one
	char buf[64];
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETTEXT, selNum, (LPARAM)buf);
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_DELETESTRING, selNum, 0);
	if (selNum == (selCount - 2)) {
		// Moving it to the last entry in the list - makes more sense to
		// add it rather than try to insert before a non-existant entry.
		SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_ADDSTRING, 0, (LPARAM)buf);
	} else {
		SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_INSERTSTRING, selNum+1, (LPARAM)buf);
	}

	// Reselect the item
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_SETCURSEL, selNum+1, 0);

	MPrimitiveParticle::actionType tempAction = particleObj->m_ActionList[selNum];
	particleObj->m_ActionList[selNum] = particleObj->m_ActionList[selNum+1];
	particleObj->m_ActionList[selNum+1] = tempAction;

	::InvalidateRect(GetDlgItem(IDC_PARTICLE_ACTION_LIST), NULL, FALSE);

	return 0;
}

LRESULT CParticleParamDlg::OnBnClickedMoveActionUpButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if (particleObj == NULL) {
		return 0;
	}

	// How many actions currently in the list
	int selCount = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCOUNT, 0, 0);

	// Which action did the user select?
	int selNum = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCURSEL, 0, 0);

	if (selNum == 0) {
		// This entry is already at the top, don't need to do anything.
		return 0;
	}

	// Move the list box entry up one
	char buf[64];
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETTEXT, selNum, (LPARAM)buf);
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_DELETESTRING, selNum, (LPARAM)buf);
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_INSERTSTRING, selNum-1, (LPARAM)buf);

	// Reselect the item
	SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_SETCURSEL, selNum-1, 0);

	// Move the actual action data up one
	MPrimitiveParticle::actionType tempAction = particleObj->m_ActionList[selNum];
	particleObj->m_ActionList[selNum] = particleObj->m_ActionList[selNum-1];
	particleObj->m_ActionList[selNum-1] = tempAction;



	::InvalidateRect(GetDlgItem(IDC_PARTICLE_ACTION_LIST), NULL, FALSE);

	return 0;
}

LRESULT CParticleParamDlg::OnBnClickedNewActionButton(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if (particleObj == NULL) {
		return 0;
	}

	CParticleActionEditDlg dlg;
	MPrimitiveParticle::actionType action;

	if (SUCCEEDED(dlg.DoModal())) {
		action.action = dlg.getActionType();
		dlg.getParams(action.m_params);
		particleObj->m_ActionList.push_back(action);

		char buf[64];
		sprintf(buf, "  %s", particleObj->actionEnumToString(action.action));
		SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_ADDSTRING, NULL, (LPARAM)buf);
	}

	return 0;
}

LRESULT CParticleParamDlg::OnLbnDblclkParticleActionList(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if (particleObj == NULL) {
		return 0;
	}

	// Which action did the user select?
	int selNum = SendDlgItemMessage(IDC_PARTICLE_ACTION_LIST, LB_GETCURSEL, 0, 0);

	if (selNum == LB_ERR) {
		// Nothing selected.
		return 0;
	}

	MPrimitiveParticle::actionType &action = particleObj->m_ActionList[selNum];

	// Prevent the user from selecting a different type of action.  This forces the user to
	// delete and then add if they want a change.  The benefit of this restriction is that
	// coding becomes much easier.
	CParticleActionEditDlg dlg(action.action, true);

	dlg.setParams(action.m_params);

	if (SUCCEEDED(dlg.DoModal())) {
		dlg.getParams(action.m_params);
	}

	return 0;
}
