#include "stdafx.h"

#include "MMath.h"
#include "ParticleShapePlugin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


ParticleShapePlugin::ParticleShapePlugin() {
	dlg = NULL;
	channelDlg = NULL;
}

ParticleShapePlugin::~ParticleShapePlugin() {
}


// MParameterPlugin methods
std::string ParticleShapePlugin::getFriendlyName() {
	return "Particle Shape";
}

bool ParticleShapePlugin::isUIForObject(const Aztec::MBaseObjectPtr &obj) {
	return AZTEC_CAST(MPrimitiveParticle, obj) != NULL;
}

void ParticleShapePlugin::createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object) {
	particleShape = AZTEC_CAST(MPrimitiveParticle, object);
	
	// if we don't have a scene object, we shouldn't create anything.
	if (particleShape == NULL) {
		return;
	}
	
	dlg = new CParticleParamDlg();
	dlg->Create(parentWnd);
	dlg->ShowWindow(SW_SHOW);
	
	RECT totalRect;
	dlg->GetClientRect(&totalRect);
	
	SetWindowPos(parentWnd, NULL, 0, 0, totalRect.right, totalRect.bottom, SWP_NOZORDER | SWP_NOMOVE);
}

void ParticleShapePlugin::destroyControls() {
	if (dlg != NULL) {
		dlg->DestroyWindow();
		delete dlg;
		dlg = NULL;
	}
}

// The particle system shape has specialized editing controls intended for the channel
// bar.  This returns true so that Aztec will know to use them.
bool ParticleShapePlugin::hasChannelControls()
{
	return true;
}

int ParticleShapePlugin::getChannelControlsHeight()
{
	// By defalt there are no controls, therefore need 0 vertical space for them.
	return 210;
}

// Build the editing controls for the Aztec channel bar
void ParticleShapePlugin::createChannelControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object)
{
	particleShape = AZTEC_CAST(MPrimitiveParticle, object);
	
	// if we don't have a scene object, we shouldn't create anything.
	if (particleShape == NULL) {
		return;
	}
	
	channelDlg = new CParticleParamDlg();
	channelDlg->Create(parentWnd);
	channelDlg->updateFromObject(particleShape);
	channelDlg->ShowWindow(SW_SHOW);
	
	RECT totalRect;
	channelDlg->GetClientRect(&totalRect);
	
	SetWindowPos(parentWnd, NULL, 0, 0, totalRect.right, totalRect.bottom, SWP_NOZORDER | SWP_NOMOVE);
}

// Delete the channel bar editing controls
void ParticleShapePlugin::destroyChannelControls()
{
	if (channelDlg != NULL) {
		if (channelDlg->IsWindow()) {
			channelDlg->ShowWindow(SW_HIDE);
			channelDlg->DestroyWindow();
		}
		delete channelDlg;
		channelDlg = NULL;
	}
}

void ParticleShapePlugin::cancelChanges() {
}

void ParticleShapePlugin::updateGUIValues(const Aztec::MBaseObjectPtr &object)
{
	particleShape = AZTEC_CAST(MPrimitiveParticle, object);
	
	// if we don't have a scene object, we shouldn't create anything.
	if (particleShape == NULL) {
		return;
	}
	
	// TBD: how do we propagate changes between the channel bar controls and
	// the parameter window controls?  Seems likely we will need to catch
	// cr/tab/esc keys within the two windows.

	// Update values based on any changes to the channel bar controls
	if (channelDlg != NULL) {
		channelDlg->updateFromObject(particleShape);
	}

	// Update values based on changes to the parameter window controls
	if (dlg != NULL) {
	}
}

