// ParticleActionEditDlg.h: interface for the CParticleActionEditDlg class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PARTICLEACTIONEDITDLG_H__968C861D_0F0E_4249_B199_B27B260A1E7A__INCLUDED_)
#define AFX_PARTICLEACTIONEDITDLG_H__968C861D_0F0E_4249_B199_B27B260A1E7A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "dialogs/ParticleSourceEditDlg.h"
#include "dialogs/ParticleColorEditDlg.h"
#include "dialogs/ParticleVelocityEditDlg.h"
#include "dialogs/ParticleBounceEditDlg.h"
#include "dialogs/ParticleSinkEditDlg.h"
#include "dialogs/VortexEditDlg.h"
#include "dialogs/ParticleKillOldDlg.h"
#include "PrimParticle.h"

class CParticleActionEditDlg : public CDialogImpl<CParticleActionEditDlg>
{
public:
	CParticleActionEditDlg(MPrimitiveParticle::actionType::actionEnum actionType = MPrimitiveParticle::actionType::source, bool edit_existing = false);
	virtual ~CParticleActionEditDlg();

	void setParams(std::vector< float > &entries);
	void getParams(std::vector< float > &params);

	// What particle action was chosen (or was set when the dialog was created)?
	MPrimitiveParticle::actionType::actionEnum getActionType() { return m_ActionType; }

protected:
	// Local storage of the type of action and its parameters.
	MPrimitiveParticle::actionType::actionEnum m_ActionType;
	std::vector< float > m_params;

	// Are we editing an action that already exists?
	bool m_EditExisting;

	// Canned sets of controls we can put into the dialog based on the type
	// of action is selected.
	CParticleSourceEditDlg sourceDlg;
	CDomainEditDlg domainDlg;
	CParticleColorEditDlg colorDlg;
	CParticleVelocityEditDlg velocityDlg;
	CParticleBounceEditDlg bounceDlg;
	CParticleSinkEditDlg sinkDlg;
	CVortexEditDlg vortexDlg;
	CParticleKillOldDlg killoldDlg;

	HWND paramBox;
	RECT paramRect;
	CParticleActionDlgBase *currentParamWnd;

	void selectEditLayout(MPrimitiveParticle::actionType::actionEnum actionEntry);
	CParticleActionDlgBase *selectEditDlg(MPrimitiveParticle::actionType::actionEnum actionEntry);
	char *selectComboEntry(MPrimitiveParticle::actionType::actionEnum actionEntry);

public:
	enum { IDD = IDD_ACTION_EDIT_DIALOG };

	BEGIN_MSG_MAP(CParticleParamDlg)
	   	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)

		COMMAND_HANDLER(IDOK, BN_CLICKED, OnOk)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnCancel)
		COMMAND_HANDLER(IDC_ACTION_COMBO, CBN_SELCHANGE, OnActionComboChange)
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnOk(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnCancel(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnActionComboChange(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
};

#endif // !defined(AFX_PARTICLEACTIONEDITDLG_H__968C861D_0F0E_4249_B199_B27B260A1E7A__INCLUDED_)
