#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MLabel.h>
#include <gui/MFlowLayout.h>

class HelloWorld : public Aztec::MApp {
public:

  bool initApp() {
    Aztec::MWindowPtr mainWindow = new Aztec::MWindow("Hello World");

    // we have to explicitly create top level windows. All other controls are auto created.
    if (!mainWindow->create()) {
      // if the window creation failed, bail out.
      return false;
    }

    mainWindow->setSize(300,300);

    // The layout manager takes care of the placement of components. See some 
    // other examples to see this in action.
    mainWindow->setLayoutManager(new Aztec::MFlowLayout());

    // make a lot of labels
    for (int i = 0; i < 20; ++i) {
      Aztec::MLabelPtr label = new Aztec::MLabel();
      mainWindow->addComponent(label);
      label->setValue("Hello World!");
    }

    // Now display our main window.
    mainWindow->setVisible(true);

    // return true to indicate that eveything started up okay.
    return true;
  }

  void cleanup() {
  }

};


AZTEC_USE_APP(HelloWorld)