#include <AztecMainPCH.h>
#include <MGraphSelectTool.h>

// AztecMain includes
#include <MDLGlobs.h>

#include <views/GraphViewWnd.h>

//-------------------
//  MGraphSelectTool
//-------------------
MGraphSelectTool::MGraphSelectTool() {
  setName("GraphSelectTool");
  m_Dragging = false;
}

static CGraphComponent* getGraph(MBaseViewWndPtr View) {
  CGraphComponent *graph = AZTEC_CAST(CGraphComponent, View);

  if (graph != NULL) {
    return graph;
  }

  // try and get our graph component
  CGraphViewWnd *graphView = AZTEC_CAST(CGraphViewWnd, View);
  if (graphView != NULL) {
    return graphView->getGraphComponent();
  }

  return NULL;
}

int MGraphSelectTool::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View) {
  CGraphComponent *graph = getGraph(View);

  if (graph == NULL) {
    return 0;
  }

  if (m_Dragging) {
    float x1,y1,x2,y2;

    graph->clientToGraph(m_DownX, m_DownY, x1,y1);
    graph->clientToGraph(m_CurX, m_CurY, x2,y2);

    glColor3f(0.1f, 1.0f, 0.7f);
    glBegin(GL_LINE_LOOP);
    glVertex2f(x1,y1);
    glVertex2f(x2,y1);
    glVertex2f(x2,y2);
    glVertex2f(x1,y2);

    glEnd();
  }

  return 1;
}

int MGraphSelectTool::onMouseDown(int mouseX, int mouseY, const MShiftState &Shift) {
  MToolType::onMouseDown(mouseX, mouseY, Shift);

  m_Dragging = true;
  m_CurX = m_DownX = mouseX;
  m_CurY = m_DownY = mouseY;
  
  return TOOLRESULT_DRAWALL;
}

int MGraphSelectTool::onMouseUp(int mouseX, int mouseY, const MShiftState &Shift)
{
  MToolType::onMouseUp(mouseX, mouseY, Shift);

  CGraphComponent *graph = getGraph(g_CurView);

  if (graph == NULL) {
    return TOOLRESULT_DRAWNONE;
  }
  
  m_Dragging = false;

  m_UpX = mouseX;
  m_UpY = mouseY;

  std::vector<CGraphComponent::ListKey> keys;
  std::vector<GraphPair> graphValues;

  graph->getGraphValues(graphValues);

  // If we are holding down control or alt, that means we are either
  // adding or subtracting from our selection, so we don't clear it
  if (!Shift.m_Shift && !Shift.m_Ctrl) {
    for (int i = 0; i < graphValues.size(); ++i) {
      MFloatKeyListPtr keyList = AZTEC_CAST(MFloatKeyList, graphValues[i].value);
    
      if (keyList == NULL) {
        continue;
      }
      // loop over the keys
      for (int keyIndex = 0; keyIndex < keyList->getKeyCount(); ++keyIndex) {
        keyList->getKeyAtIndex(keyIndex)->setSelected(false);
      }
    }
  }

  bool selectionTarget = true;

  if (Shift.m_Shift) {
    selectionTarget = false;
  }

  RECT selectionRect;

  selectionRect.left = m_DownX;
  selectionRect.top = m_DownY;
  selectionRect.right  = m_UpX;
  selectionRect.bottom = m_UpY;

  if (selectionRect.left > selectionRect.right) {
    std::swap(selectionRect.left, selectionRect.right);
  }
  if (selectionRect.top > selectionRect.bottom) {
    std::swap(selectionRect.top, selectionRect.bottom);
  }

  selectionRect.left -= 3;
  selectionRect.top -= 3;
  selectionRect.right += 3;
  selectionRect.bottom += 3;

  graph->getKeysInRect(selectionRect, keys);

  for (int i = 0; i < keys.size(); ++i) {
    keys[i].first->getKeyAtIndex(keys[i].second)->setSelected(selectionTarget);
  }
  
  return TOOLRESULT_DRAWALL;
}

int MGraphSelectTool::onMouseMove(int mouseX, int mouseY, const MShiftState &Shift)
{
  MToolType::onMouseMove(mouseX, mouseY, Shift);
  
  m_CurX = mouseX;
  m_CurY = mouseY;
  
  if (m_Dragging) {
    return TOOLRESULT_DRAWALL;
  }
  
  return TOOLRESULT_DRAWNONE;
}


