#include <AztecMainPCH.h>

#include "KeyFuncUVEdit.h"

#include "MdlMsgs.h"

#include "MdlGlobs.h"
#include "DlgGlobs.h"

#include "MEditableMesh.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void InitUVActionList(MActionListType *AL) {
   g_SysMan->logOutput("Initialising UV Edit Action List");

   // Viewport functions
   AL->Add("KUVEditDetachFaces", "UV Detach Faces", "UV Edit", KUVEditDetachFaces, g_MainDlg, ID_UVEDIT_DETACHFACES);
   AL->Add("KUVEditWeldVertices", "UV Weld Vertices", "UV Edit", KUVEditWeldVertices, g_MainDlg, ID_UVEDIT_WELDVERTICES);
   AL->Add("KUVEditCollapseVertices", "UV Collapse Vertices", "UV Edit", KUVEditCollapseVertices, g_MainDlg, ID_UVEDIT_COLLAPSEVERTICES);
}

int KUVEditDetachFaces() {
   if (g_CurView == NULL)
      return 0;

   if (g_CurView->getClassName().compareNoCase("CUVEditViewWnd") != 0) {
      g_SysMan->logOutput("Error: KUVEditDetachFaces - Must be in a UV Edit view port");
      return 0;
   }

   MSceneObjectPtr Obj;

   Obj = AZTEC_CAST(MSceneObject, g_Scene->getSelectedObjectList()->getTail());

   if (Obj != NULL) {
      MMeshPtr Mesh = AZTEC_CAST(MMesh, Obj->getShapeObject()->convertToMesh());
      if (Mesh != NULL) {
         MEditableMeshPtr TextureMesh;

         Mesh = AZTEC_CAST(MMesh, Obj);
         TextureMesh = AZTEC_CAST(MEditableMesh, Mesh->getTextureMesh());

         if (TextureMesh != NULL) {
            if (!TextureMesh->separateFaces(TRIANGLE_SELECTED)) {
               g_SysMan->logOutput("Warning: KUVEditDetachFaces - No changes made");
            }
         } else {
            g_SysMan->logOutput("Error: KUVEditDetachFaces - No Texture Mesh found for the Selected Object");
         }
      } else {
         g_SysMan->logOutput("Error: KUVEditDetachFaces - Selected Object is not a basic Mesh type");
      }
   } else {
      g_SysMan->logOutput("Error: KUVEditDetachFaces - No Object Selected");
   }

   ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
   ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);

   return 1;
}


int KUVEditWeldVertices() {
   return 0;
}

int KUVEditCollapseVertices()
{
   if (g_CurView == NULL)
      return 0;

   if (g_CurView->getClassName().compareNoCase("CUVEditViewWnd") != 0)
   {
      g_SysMan->logOutput("Error: KUVEditCollapseVertices - Must be in a UV Edit view port");
      return 0;
   }

   MSceneObjectPtr sceneObj;

   sceneObj = AZTEC_CAST(MSceneObject, g_Scene->getSelectedObjectList()->getTail());

   if (sceneObj != NULL) {
     MMeshPtr mesh = AZTEC_CAST(MMesh, sceneObj->getShapeObject()->convertToMesh());
     if (mesh != NULL) {
       MEditableMeshPtr TextureMesh = AZTEC_CAST(MEditableMesh, mesh->getTextureMesh());
       if (TextureMesh != NULL) {
          if (!TextureMesh->collapseVertices(VERTEX_SELECTED)) {
             g_SysMan->logOutput("Warning: KUVEditCollapseVertices - No changes made");
          }
       } else {
          g_SysMan->logOutput("Error: KUVEditCollapseVertices - No Texture Mesh found for the Selected Object");
       }
     } else {
       g_SysMan->logOutput("Error: KUVEditCollapseVertices - Selected Object is not a basic Mesh type");
     }
   } else {
      g_SysMan->logOutput("Error: KUVEditCollapseVertices - No Object Selected");
   }

   ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
   ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);

   return 1;
}
