#include "StdAfx.h"

#include "MSystemManager.h"
#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MVector3Parameter
  //---------------------
  MVector3ParameterImpl::MVector3ParameterImpl(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    int meaning) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL) 
  {
    this->meaning = meaning;
  }
  
  MVector3ParameterImpl::~MVector3ParameterImpl() {
  }

  MVector3 MVector3ParameterImpl::getValue() {
    updateObject();
    return m_Value;
  }

  MVector3 MVector3ParameterImpl::getValue(long time) {
    updateObject();
    return m_Value;
  }
  
  int MVector3ParameterImpl::getDataMeaning() const {
    return meaning;
  }

  bool MVector3ParameterImpl::getValueString(MStr &value) {
    value = getValue().convertToString();
    return true;
  }

  bool MVector3ParameterImpl::getValueInteger(int &value) {
    return false;
  }

  bool MVector3ParameterImpl::getValueFloat(float &value) {
    return false;
  }

  bool MVector3ParameterImpl::getValueBoolean(bool &value) {
    return false;
  }

  bool MVector3ParameterImpl::getValueVector(MVector3 &value) {
    value = getValue();
    return true;
  }


  bool MVector3ParameterImpl::setValueString(const MStr &value) {
    MVector3 val;
    val.convertFromString(value);
    return setValueVector(val);
  }

  bool MVector3ParameterImpl::setValueInteger(int value) {
    return false;
  }

  bool MVector3ParameterImpl::setValueFloat(float value) {
    return false;
  }

  bool MVector3ParameterImpl::setValueBoolean(bool value) {
    return false;
  }

  bool MVector3ParameterImpl::setValueVector(const MVector3 &value) {
    m_Value = value;

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }
 
  bool MVector3ParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    MVector3 val;

    if (value->getValueVector(val)) {
      return setValueVector(val);
    }
    
    return false;
  }

  MParameterObjectPtr MVector3ParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

}
