#include "StdAfx.h"

#include "MSystemManager.h"
#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  using namespace std;

  //---------------------------------------
  //  MObjectListParameterImpl
  //---------------------------------------
  MObjectListParameterImpl::MObjectListParameterImpl( const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MStringParameterImpl(shortName, longName, friendlyName)
  {
    m_ObjectsFound = false;
  }

  MObjectListParameterImpl::~MObjectListParameterImpl() {
  }

  void MObjectListParameterImpl::setValue(const vector<MNamedObjectPtr> &value) {
  }

  vector<MNamedObjectPtr> MObjectListParameterImpl::getValue() {
    vector<MNamedObjectPtr> result;

    // if we cant get our objects, just return nothing
    if (!ensureObjects()) {
      return result;
    }

    return m_Objects;
  }


  int MObjectListParameterImpl::getObjectCount() {
    if (!ensureObjects()) {
      return m_ObjectNames.size();
    }

    return m_Objects.size();
  }

  MNamedObjectPtr MObjectListParameterImpl::getObject(int index) {
    if (!ensureObjects()) {
      return NULL;
      // return m_ObjectNames[index];
    }

    return m_Objects[index];
  }


  void MObjectListParameterImpl::addObject(MNamedObjectPtr obj) {
    // if we don't have the objects, search for the names
    if (!ensureObjects()) {
      vector<string>::iterator it;

      it = find(m_ObjectNames.begin(), m_ObjectNames.end(), obj->getName().c_str());

      if (it == m_ObjectNames.end()) {
        m_ObjectNames.push_back(obj->getName().c_str());
      }
      return;
    }

    // if the object is already in the list,
    // don't try and add it
    if (isObjectInList(obj)) {
      return;
    }

    m_Objects.push_back(obj);
  }

  void MObjectListParameterImpl::removeObject(MNamedObjectPtr obj) {
    // if we don't have the objects, search for the names
    if (!ensureObjects()) {
      vector<string>::iterator it;

      it = find(m_ObjectNames.begin(), m_ObjectNames.end(), obj->getName().c_str());

      if (it != m_ObjectNames.end()) {
        m_ObjectNames.erase(it);
      }
      return;
    }

    // if the object isn't already in the list
    // don't try and remove it.
    vector<MNamedObjectPtr>::iterator it;

    it = find(m_Objects.begin(), m_Objects.end(), obj);

    if (it != m_Objects.end()) {
      m_Objects.erase(it);
    }
  }

  bool MObjectListParameterImpl::isObjectInList(MNamedObjectPtr obj) {
    // if we don't have the actual objects, try and
    // find them in the name list.
    if (!ensureObjects()) {
      vector<string>::iterator it;

      it = find(m_ObjectNames.begin(), m_ObjectNames.end(), obj->getName().c_str());

      return (it != m_ObjectNames.end());
    }

    vector<MNamedObjectPtr>::iterator it;

    it = find(m_Objects.begin(), m_Objects.end(), obj);

    return (it != m_Objects.end());
  }


  // MParameterObject methods
  bool MObjectListParameterImpl::setValueString(const MStr &Value) {
    // reset the objects found flag
    m_ObjectsFound = false;

    m_ObjectNames.clear();
    m_Objects.clear();

    // got through our value and try and extract the names
    MStr values[100];
    int count; 
    count = Value.Separate(values, 100);

    for (int i = 0; i < count; i++) {
      m_ObjectNames.push_back(values[i].c_str());
    }

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);

    return true;
  }

  bool MObjectListParameterImpl::getValueString(MStr &Value) {
    // if we don't have the objects, just use the names
    if (!ensureObjects()) {
      if (m_ObjectNames.size() == 0) {
        Value = "";
        return true;
      }
      Value = m_ObjectNames[0].c_str();

      for (unsigned i = 1; i < m_ObjectNames.size(); i++) {
        Value += " ";
        Value += m_ObjectNames[i].c_str();
      }

      return true;
    }

    if (m_Objects.size() == 0) {
      Value = "";
      return true;
    }
    Value = m_Objects[0]->getName().c_str();
    
    for (unsigned i = 1; i < m_Objects.size(); i++) {
      Value += " ";
      Value += m_Objects[i]->getName().c_str();
    }
    
    return true;
  }

  bool MObjectListParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    MObjectListParameterImpl *srcList = AZTEC_CAST(MObjectListParameterImpl, value);

    if (srcList == NULL) {
      MStr str;
      if (value->getValueString(str)) {
        return setValueString(str);
      }

      return false;
    }

    m_ObjectNames = srcList->m_ObjectNames;
    m_Objects = srcList->m_Objects;
    m_ObjectsFound = srcList->m_ObjectsFound;

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }

  MParameterObjectPtr MObjectListParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  bool MObjectListParameterImpl::ensureObjects() {
    if (m_ObjectsFound) {
      return true;
    }

    MSystemManagerPtr sysMan = Aztec::getSystemManager();
    MScenePtr scene = sysMan->getScene();

    m_Objects.clear();
    for (unsigned i = 0; i < m_ObjectNames.size() ; ++i) {
      MNamedObjectPtr obj = AZTEC_CAST(MNamedObject, scene->getObjectList()->findObject(m_ObjectNames[i].c_str()));

      if (obj == NULL) {
        return false;
      }
      m_Objects.push_back(obj);
    }

    m_ObjectsFound = true;

    return true;
  }

}
