#include "StdAfx.h"

#include "MSystemManager.h"
#include "params/MMatrix4Parameter.h"

#include "MDAGraph.h"

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MMatrix4Parameter
  //---------------------
  MMatrix4ParameterImpl::MMatrix4ParameterImpl(const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL) {
  }
  
  MMatrix4ParameterImpl::~MMatrix4ParameterImpl() {
  }

  const MMatrix4& MMatrix4ParameterImpl::getValue() {
    updateObject();
    return m_Value;
  }

  bool MMatrix4ParameterImpl::getValueMatrix(MMatrix4 &value) {
    updateObject();
    value = m_Value;
    return true;
  }

  bool MMatrix4ParameterImpl::setValueMatrix(const MMatrix4 &value) {
    m_Value = value;
    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }

  bool MMatrix4ParameterImpl::getValueString(MStr &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::getValueInteger(int &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::getValueFloat(float &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::getValueBoolean(bool &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::getValueVector(MVector3 &value) {
    return false;
  }


  bool MMatrix4ParameterImpl::setValueString(const MStr &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::setValueInteger(int value) {
    return false;
  }

  bool MMatrix4ParameterImpl::setValueFloat(float value) {
    return false;
  }

  bool MMatrix4ParameterImpl::setValueBoolean(bool value) {
    return false;
  }

  bool MMatrix4ParameterImpl::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MMatrix4ParameterImpl::setValueParameter(const MParameterObjectPtr &src) {
    MParameterObjectImpl::setFromParameter(src);

    MMatrix4ParameterPtr param = AZTEC_CAST(MMatrix4Parameter, src);
    
    if (param == NULL) {
      return false;
    }
    
    setValueMatrix(getValue());
    
    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }

  MParameterObjectPtr MMatrix4ParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  bool MMatrix4ParameterImpl::doUpdateObject() {
    MParameterObject::doUpdateObject();

    // if we have a controller input, we must get that value
    if (getInputParameter() != NULL) {
      MMatrix4ParameterPtr param;
    
      param = AZTEC_CAST(MMatrix4ParameterImpl, getInputParameter());

      // we must only ever have a parameter which can output a matrix
      assert(param != NULL);

      unsetFlag(OBJECTFLAG_NEEDS_UPDATE);
      return param->getValueMatrix(m_Value);
    }

    // otherwise there is no change for us
    return true;
  }
 
  
}
