#include "StdAfx.h"
#include "MBone.h"
#include "MSystemManager.h"

#include <math.h>

#include <GL/gl.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MBoneObject::MBoneObject() {
  }
  
  MBoneObject::~MBoneObject() {
  }
  
  // Class related
  MBaseObjectPtr MBoneObject::createNew() {
    MBoneObjectPtr NewObj;
    
    NewObj = new MBoneObject;
    
    return NewObj;
  }
  
  
  // Draws the object using open gl commands
  bool MBoneObject::drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags) {
    MSystemManagerPtr SysMan;
    MTreeObjectNodePtr ObjNode;
    
    SysMan = Aztec::getSystemManager();
    
    glPushAttrib(GL_ENABLE_BIT);
    glDisable(GL_LIGHTING);
    glDisable(GL_CULL_FACE);
    
    ObjNode = SysMan->getScene()->getObjectList()->findObject(baseObj);
    
    glColor3f(1,0.5,0);
    if (ObjNode != NULL) {
      if (ObjNode->isChildOfFlagged(OBJECTFLAG_SELECTED)) {
        glColor3f(1,0.75,0);
      }
    }
    if (baseObj->isFlagged(OBJECTFLAG_SELECTED)) {
      glColor3f(1,1,0);
    }
    
    {
      float Ang;
      glBegin(GL_LINE_LOOP);
      for (Ang = 0; Ang < 360; Ang += 36) {
        glVertex3d(5.0*cos(Ang*3.141592653589/180.0), 5.0*sin(Ang*3.141592653589/180.0), 0);
      }
      glEnd();
      
      glBegin(GL_LINE_LOOP);
      for (Ang = 0; Ang < 360; Ang += 36) {
        glVertex3d(5.0*cos(Ang*3.141592653589/180.0), 0, 5.0*sin(Ang*3.141592653589/180.0));
      }
      glEnd();
      
      glBegin(GL_LINE_LOOP);
      for (Ang = 0; Ang < 360; Ang += 36) {
        glVertex3d(0, 5.0*cos(Ang*3.141592653589/180.0), 5.0*sin(Ang*3.141592653589/180.0));
      }
      glEnd();
    }
    
    
    {
      // Draw a connection to the parent if the parent is a bone
      
      MSystemManagerPtr SysMan;
      MScenePtr Scene;
      MBaseObjectPtr ParentObj;
      MTreeObjectNodePtr ObjNode, ParentNode;
      
      SysMan = Aztec::getSystemManager();
      Scene = SysMan->getScene();
      
      ObjNode = Scene->getObjectList()->findObject(baseObj);
      if (ObjNode != NULL) {
        ParentNode = ObjNode->getParent();
        if (ParentNode != NULL) {
          ParentObj = ParentNode->getObject();
          if (ParentObj != NULL) {
            MVector3    pnts[4];
            float dist = (float)sqrt((5.0*5.0) / 2.0);
            
            pnts[0].set( dist,-dist,0);
            pnts[1].set(-dist,-dist,0);
            pnts[2].set(-dist, dist,0);
            pnts[3].set( dist, dist,0);

            glBegin(GL_LINES);
            for (int i = 0; i < 4; i++) {
              MVector3 Trans;
              Trans = Scene->objectToWorldSpace(ParentNode, pnts[i]);
              Trans = Scene->worldToObjectSpace(ObjNode, Trans);
            
            
              glVertex3f(0,0,0);
              glVertex3f(Trans.x, Trans.y, Trans.z);
            }            
            glEnd();

          }
        }
      }
      
    }
    
    
    glPopAttrib();
    return 1;
  }
  
  
}