#ifndef MParentObjectParameter_Header
#define MParentObjectParameter_Header

#include "MObjectParameter.h"
#include "MSceneObject.h"

#include <vector>
#include <string>

namespace Aztec {
  
  class MParentObjectParameter;
  typedef MRefCountedPtr<MParentObjectParameter> MParentObjectParameterPtr;

  //---------------------------------------
  //  MParentObjectParameter
  //---------------------------------------
  class MGENEXPORT MParentObjectParameter : public MObjectParameterImpl {
  public:
    MParentObjectParameter( 
                      MSceneObject *owner = NULL,
                      const MStr &shortName = "", 
                      const MStr &longName = "", 
                      const MStr &friendlyName = "");
    ~MParentObjectParameter();

    // MObjectParameter methods
    void setValue(MNamedObjectPtr value);
    MNamedObjectPtr getValue();

    // MParameterObject methods.
    bool isInputParameter();
    bool createKeyAt(long time);
    bool setFromParameter(MParameterObjectPtr src);
    MParameterObjectPtr createCopy();
    
    // MBaseObject methods
    MStr getClassName() { return MStr("MParentObjectParameter"); }

  protected:
    MSceneObject *thisSceneObject;

    void updateParentInfo();
  };


}

#endif
