#include <AztecGUICommonPCH.h>

#include <gui/win32/MDIBImage.h>

#include <MSystemManager.h>

namespace Aztec {

  MDIBImage::MDIBImage()
  {
    m_Palette = NULL;
    m_Pixels = NULL;
    
    m_hBitmap = NULL;
    
    m_Width = NULL;
    m_Height = NULL;
    
    m_CompleteHeader = NULL;

    ZeroMemory(&m_BitmapInfoHeader, sizeof(m_BitmapInfoHeader));
  }
  
  
  MDIBImage::~MDIBImage()
  {
    DeleteBitmap();
    if (m_Palette)
    {
      delete[] m_Palette;
      m_Palette = NULL;
    }
  }
  
  int MDIBImage::SetFromBitmap(const MDIBImage &Bmp, HDC hDC)
  {
    if (CreateEmptyBitmap(hDC, Bmp.m_Width, Bmp.m_Height, Bmp.m_Depth, Bmp.m_Palette) == 0)
      return 0;
    
    memcpy(m_Pixels, Bmp.m_Pixels, m_Width*m_Height*m_Depth/8);
    
    return 1;
  }
  
  int MDIBImage::CreateEmptyBitmap(HDC hDC, int Width, int Height, int Depth, RGBQUAD *SrcPalette)
  {
    if (Width <= 0 || Height <= 0  || Depth <= 0) {
      DeleteBitmap();
      return 0;
    }
    
    // Delete any previous bitmap.
    if (m_BitmapInfoHeader.biWidth != Width || 
      m_BitmapInfoHeader.biHeight != Height || 
      m_BitmapInfoHeader.biBitCount != Depth) 
    {
      DeleteBitmap();
    
      // Fill out the BITMAPINFOHEADER structure with the correct values.
      m_BitmapInfoHeader.biSize = sizeof(BITMAPINFOHEADER);
      m_BitmapInfoHeader.biWidth = Width;
      m_BitmapInfoHeader.biHeight = Height;
      m_BitmapInfoHeader.biBitCount = Depth;
      m_BitmapInfoHeader.biPlanes = 1;
      m_BitmapInfoHeader.biCompression = BI_RGB;
      m_BitmapInfoHeader.biSizeImage = Width*Height*Depth/8;
      m_BitmapInfoHeader.biXPelsPerMeter = 72;
      m_BitmapInfoHeader.biYPelsPerMeter = 72;
      m_BitmapInfoHeader.biClrUsed = 0;
      m_BitmapInfoHeader.biClrImportant = 0;
    
    
      // Create an array that contians the bitmap info header, and the palette if necessary in one contigous chunk
      int      NumCols = 0;
    
      if (Depth < 16)
      {
        NumCols = 1 << Depth;
        if (m_Palette)
          delete[] m_Palette;
        m_Palette = new RGBQUAD[NumCols];
      
        if (SrcPalette == NULL)
        {
          GetSystemPaletteEntries(hDC, 0, NumCols, (PALETTEENTRY*)m_Palette);
        }
        else
        {
          memcpy(m_Palette, SrcPalette, sizeof(RGBQUAD)*NumCols);
        }
      
      }     
    
      m_CompleteHeader = new BYTE[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD)*NumCols];
      memcpy(m_CompleteHeader, &m_BitmapInfoHeader, sizeof(BITMAPINFOHEADER));
      memcpy(m_CompleteHeader + sizeof(BITMAPINFOHEADER), m_Palette, sizeof(RGBQUAD)*NumCols);
    
      m_hBitmap = CreateDIBSection(hDC, (BITMAPINFO*)m_CompleteHeader, DIB_RGB_COLORS, (void**)&m_Pixels, NULL,0);
    }
      
    m_Width = Width;
    m_Height = Height;
    m_Depth = Depth;
    m_DataWidth = (m_Width * m_BitmapInfoHeader.biBitCount) >> 3;

    // Make the data width align on the 4 byte boundary.
    while ((m_DataWidth % 4) != 0) {
      ++m_DataWidth;
    }
    
    return (m_hBitmap != NULL)? 1 : 0;
  }
  
  void MDIBImage::DeleteBitmap() {
    if (m_hBitmap == NULL) {
      return;
    }
    
    DeleteObject(m_hBitmap);
    m_hBitmap = NULL;
    m_Width = 0;
    m_Height = 0;
    m_Depth = 0;
    
    if (m_Palette)
      delete[] m_Palette;
    m_Palette = NULL;
    
    if (m_CompleteHeader)
    {
      delete[] m_CompleteHeader;
      m_CompleteHeader = NULL;
    }
  }
  
  int MDIBImage::Draw(HDC hDC, int x, int y, int w, int h)
  {
    if (!m_hBitmap)
      return 0;
    
    if (w == -1)
      w = m_Width;
    if (h == -1)
      h = m_Height;
    
    return StretchDIBits(hDC, x, y, w, h, 0, 0, w, h, m_Pixels, (BITMAPINFO*)m_CompleteHeader, DIB_RGB_COLORS, SRCCOPY);
    //   return SetDIBitsToDevice(hDC, x, y, w, h, 0,m_Height-h,0, h, m_Pixels, (BITMAPINFO*)m_CompleteHeader, DIB_RGB_COLORS);
  }
  
  int MDIBImage::Draw(HDC hDC, int destx, int desty, int srcx, int srcy, int w, int h)
  {
    if (!m_hBitmap)
      return 0;
    
    if (w > m_Width - srcx)
      w = m_Width - srcx;
    if (h > m_Height - srcy)
      h = m_Height - srcy;
    
    return StretchDIBits(hDC, destx, desty, w, h, srcx, srcy, w, h, m_Pixels, (BITMAPINFO*)m_CompleteHeader, DIB_RGB_COLORS, SRCCOPY);
    //   return SetDIBitsToDevice(hDC, destx, desty, w, h, srcx, srcy, srcy, h, m_Pixels, (BITMAPINFO*)m_CompleteHeader, DIB_RGB_COLORS);
  }
  
  
  int MDIBImage::LoadFromBMP(const char *Filename, HDC hDC)
  {
    Aztec::MImagePtr image = Aztec::MSystemManager::getInstance()->loadImage(Filename);
    
    if (image != NULL) {
      setFromImage(image, hDC);
      return 1;
    }
    
    return 0;
  }
  
  void MDIBImage::setFromImage(const Aztec::MImagePtr &newImage, HDC hDC) {
    if (newImage == NULL) {
      DeleteBitmap();
      return;
    }
    if (CreateEmptyBitmap(hDC, newImage->getWidth(), newImage->getHeight(), 24))
    {
      
      // the unfortunate part there is that RGB needs to be conveted to BGR, and
      // the image also needs to be turned upside down
      int imageSize = newImage->getWidth()*newImage->getHeight()*3;

      const BYTE *src = newImage->getPixelData();
      for (int y = m_Height - 1; y >= 0; --y) {
        BYTE *dest = m_Pixels + (y * m_DataWidth);

        for (int x = 0; x < m_Width; ++x) {
          dest[2] = *src; ++src;
          dest[1] = *src; ++src;
          dest[0] = *src; ++src;

          dest += 3;
        }
      }
      
    }
  }

}

