/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include "gui/qt3/MLabelImpl.h"
#include "gui/qt3/MAppImpl.h"

#include <assert.h>


namespace Aztec {

  MLabel::MLabel(const std::string &label)
    : MComponent(),
      minSize(-1,-1),
      m_Value(label)
  {
  }

  MLabel::~MLabel() {
  }

  bool MLabel::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    m_Handle = new QLabel(parentWnd);

    if (m_Handle != 0) {
      // Don't lose us
      app->registerComponent(m_Handle, this);

      onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      //::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }

  void MLabel::setValue(const std::string &value) {
    if (value == m_Value) {
      return;
    }

    // reset the size calculations so for the call to getMinimumSize().
    minSize.setHeight(-1);
    minSize.setWidth(-1);

    m_Value = value;
    if (m_Handle != 0l) {
      // TODO: Cache the casted handle, or so..
      QLabel* label = dynamic_cast<QLabel*>(m_Handle);
      if (label != 0l) label->setText(value.c_str());
    }
  }

  std::string MLabel::getValue() {
    return m_Value;
  }

  bool MLabel::isMinimumSizeSet() {
    return true;
  }

  MSize2D MLabel::getMinimumSize() {
    // Hahah, eat that you Windows users! (see MLabelImpl.cpp - win32)
    // Yes, getting the font metrics is this easy when using Qt :P
    QFontMetrics fm = m_Handle->fontMetrics();

    // TODO: Check (0 < blah)
    QRect rc = fm.boundingRect(m_Value.c_str());
    return MSize2D(rc.width(), rc.height());
  }

  bool MLabel::onChanged() {
    return false;
  }

}

