#ifndef MLabelImpl_Header
#define MLabelImpl_Header

#include <gui/MLabel.h>
#include <gui/win32/MComponentImpl.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MLabel : public virtual Aztec::IMLabel, public MComponent {
  public:
    MLabel(const std::string &label = "");
    ~MLabel();

    /**
     * This sets the internal value of the label, without 
     * setting the value in the concrete win32 object, and
     * without firing any events.
     *
     * @param value The new value for the text field.
     */
    void setInternalValue(const std::string &value);

    // MComponentImpl methods
    bool createImpl();

    // MLabel Methods
    void setValue(const std::string &value);
    std::string getValue();
    bool onChanged();

    // MComponent methods
    bool isMinimumSizeSet();
    MSize2D getMinimumSize();

  protected:
    /// This is the value in the label.
    std::string m_Value;

    /// The minimum size of the text
    MSize2D minSize;

  };

}


#endif