
#ifndef QPushButton_Header
#define QPushButton_Header

#include <string>
#include <iostream>

#include <qpushbutton.h>

#include "gui/MApplication.h"
#include "gui/MButton.h"


/**
 * Custom QPushButton class for passing signals into AztecGUI
 */
class CQPushButton_ : public QPushButton {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQPushButton_(QWidget* parent, const Aztec::MButtonPtr ref)
    : QPushButton(parent),
      m_Ref(ref) {
    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(pressed()), SLOT(onPressed()));

    // Most buttons in Aztec are currently used
    // for toggle-type-stuff, so we enable it here..
    setToggleType(QButton::Toggle);
  };

  ~CQPushButton_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MButton that is using us
   */
  Aztec::MButtonPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);

protected slots:
  /**
   * These methods pass the signals back into AGUI
   */
  void onResize(QResizeEvent* ev) {
    QButton::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onPressed() {
    //QPushButton::pressed();
    Aztec::MApp* app = Aztec::MApp::getInstance();

    bool handled = app->onCommand(m_Ref->getCommand(), m_Ref);
    if (!handled) handled = m_Ref->onClick();
  };

};


#endif

