#ifndef MWindow_Header
#define MWindow_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MWindow;
  class IMWindow;

  typedef MRefCountedPtr<MWindow> MWindowPtr;
  typedef MRefCountedPtr<IMWindow> IMWindowPtr;

}

#include <gui/MContainer.h>

#include <gui/MMenu.h>

#include <string>


namespace Aztec {


  /**
   * This MWindow class is a framed window object. That is a top level, 
   * floating window that usually represents a single running application.
   */
  class AZTECGUI_EXPORT IMWindow : public virtual IMContainer {
  protected:
    IMWindow() { }
    ~IMWindow() { }

  public:
    typedef IMWindowPtr Ptr;

    /**
     * This creates the window so it is ready to use, but does not display it. 
     * The onCreate() method will be called shortly after.
     *
     * @return true if the create was succesful, false if it wasn't.
     */
    virtual bool create() = 0;

    /**
     * Sets the title that typically appears at the top of the window.
     */
    virtual void setTitle(const std::string &title) = 0;

    /**
     * Gets the title that appears at the top of the window.
     */
    virtual std::string getTitle() = 0;

    /**
     * This sets the menu used for this window. 
     *
     * TODO: possibly reconsider this, as menus could potentitally be places 
     * on any container, not just a floating window.
     */
    virtual void setMenu(MMenuPtr menu) = 0;

    /**
     * This gets the menu used for this window. 
     *
     * TODO: possibly reconsider this, as menus could potentitally be places 
     * on any container, not just a floating window.
     */
    virtual MMenuPtr getMenu() = 0;

    /**
     * This attempts to close the window. It firstt calls onClose(), and if 
     * this returns true (as in the message was handled), then the close 
     * operation stops, and noting changes. If the onClose() method returns 
     * false, as in the message was NOT handled, the close operation 
     * continues, and the window is closed. If this window is the main 
     * application window, the window may terminate.
     */
    virtual void close() = 0;

    /**
     * Called when the close() method of the window has been called, or the 
     * user attempts to close the window some other way.
     * This methd can be used to control what happens when the window is 
     * attempted to be closed. If we return false, then the message is considerd
     * to not have been handled, and the window will be closed. If the return 
     * value is true, then the message is handled, and the window does not close.
     *
     * @return true if the window should not close, false if it should close.
     */
    virtual bool onClose() = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MWindowImpl.h>


#endif

