#ifndef Aztec_MKeyEvent_Header
#define Aztec_MKeyEvent_Header

#include <gui/MGuiBase.h>

namespace Aztec {

  class MKeyEvent;
  typedef MRefCountedPtr<MKeyEvent> MKeyEventPtr;

  class MComponent;
  typedef MRefCountedPtr<MComponent> MComponentPtr;

}

#include <gui/MPoint2D.h>
#include <gui/MShiftState.h>

namespace Aztec {

  /**
   * The mouse event class represents the occurrance of some event happening 
   * with the mouse. It could be a mouse button press or release, or the mouse 
   * moving inside a control. The coordinates of the mouse event are the screen 
   * coordinates in pixels relative to the top left of the component the event 
   * occurrs in.
   */
  class AZTECGUI_EXPORT MKeyEvent {
  public:
    typedef enum { KEY_DOWN, KEY_UP } KeyMessageType;

    /**
     * List of key codes. These are not garauneteed to have the same value 
     * as the underlying system, so dn't use them interchangably.
     */
    typedef enum { 
      
      Key_None,
      Key_Unknown,
      Key_LeftButton,
      Key_RightButton,
      Key_MiddleButton,
      Key_Escape,
      Key_Tab,
      Key_Backtab,
      Key_Backspace,
      Key_Return,
      Key_Insert,
      Key_Delete,
      Key_Pause,
      Key_Print,
      Key_SysReq,
      Key_Home,
      Key_End,
      Key_Left,
      Key_Up,
      Key_Right,
      Key_Down,
      Key_Prior,
      Key_Next,
      Key_Shift,
      Key_Control,
      Key_Meta,
      Key_Alt,
      Key_CapsLock,
      Key_NumLock,
      Key_ScrollLock,
      Key_Clear,
      Key_F1,
      Key_F2,
      Key_F3,
      Key_F4,
      Key_F5,
      Key_F6,
      Key_F7,
      Key_F8,
      Key_F9,
      Key_F10,
      Key_F11,
      Key_F12,
      Key_F13,
      Key_F14,
      Key_F15,
      Key_F16,
      Key_F17,
      Key_F18,
      Key_F19,
      Key_F20,
      Key_F21,
      Key_F22,
      Key_F23,
      Key_F24,
      Key_F25,
      Key_F26,
      Key_F27,
      Key_F28,
      Key_F29,
      Key_F30,
      Key_F31,
      Key_F32,
      Key_F33,
      Key_F34,
      Key_F35,
      Key_Menu,
      Key_Help,
      Key_Space,
      Key_Any,
      Key_QuoteDbl,
      Key_NumberSign,
      Key_Dollar,
      Key_Percent,
      Key_Ampersand,
      Key_Apostrophe,
      Key_ParenLeft,
      Key_ParenRight,
      Key_Asterisk,
      Key_Plus,
      Key_Comma,
      Key_Minus,
      Key_Period,
      Key_Slash,
      Key_0,
      Key_1,
      Key_2,
      Key_3,
      Key_4,
      Key_5,
      Key_6,
      Key_7,
      Key_8,
      Key_9,
      Key_Colon,
      Key_Semicolon,
      Key_Less,
      Key_Equal,
      Key_Greater,
      Key_Question,
      Key_At,
      Key_A,
      Key_B,
      Key_C,
      Key_D,
      Key_E,
      Key_F,
      Key_G,
      Key_H,
      Key_I,
      Key_J,
      Key_K,
      Key_L,
      Key_M,
      Key_N,
      Key_O,
      Key_P,
      Key_Q,
      Key_R,
      Key_S,
      Key_T,
      Key_U,
      Key_V,
      Key_W,
      Key_X,
      Key_Y,
      Key_Z,
      Key_BracketLeft,
      Key_Backslash,
      Key_BracketRight,
      Key_AsciiCircum,
      Key_Underscore,
      Key_QuoteLeft,
      Key_BraceLeft,
      Key_Bar,
      Key_BraceRight,
      Key_AsciiTilde,
      Key_nobreakspace,
      Key_exclamdown,
      Key_cent,
      Key_sterling,
      Key_currency,
      Key_yen,
      Key_brokenbar,
      Key_section,
      Key_diaeresis,
      Key_copyright,
      Key_ordfeminine,
      Key_guillemotleft,
      Key_notsign,
      Key_hyphen,
      Key_registered,
      Key_macron,
      Key_degree,
      Key_plusminus,
      Key_twosuperior,
      Key_threesuperior,
      Key_acute,
      Key_mu,
      Key_paragraph,
      Key_periodcentered,
      Key_cedilla,
      Key_onesuperior,
      Key_masculine,
      Key_guillemotright,
      Key_onequarter,
      Key_onehalf,
      Key_threequarters,
      Key_questiondown,
      Key_Agrave,
      Key_Aacute,
      Key_Acircumflex,
      Key_Atilde,
      Key_Adiaeresis,
      Key_Aring,
      Key_AE,
      Key_Ccedilla,
      Key_Egrave,
      Key_Eacute,
      Key_Ecircumflex,
      Key_Ediaeresis,
      Key_Igrave,
      Key_Iacute,
      Key_Icircumflex,
      Key_Idiaeresis,
      Key_ETH,
      Key_Ntilde,
      Key_Ograve,
      Key_Oacute,
      Key_Ocircumflex,
      Key_Otilde,
      Key_Odiaeresis,
      Key_multiply,
      Key_Ooblique,
      Key_Ugrave,
      Key_Uacute,
      Key_Ucircumflex,
      Key_Udiaeresis,
      Key_Yacute,
      Key_THORN,
      Key_ssharp,
      Key_agrave,
      Key_aacute,
      Key_acircumflex,
      Key_atilde,
      Key_adiaeresis,
      Key_aring,
      Key_ae,
      Key_ccedilla,
      Key_egrave,
      Key_eacute,
      Key_ecircumflex,
      Key_ediaeresis,
      Key_igrave,
      Key_iacute,
      Key_icircumflex,
      Key_idiaeresis,
      Key_eth,
      Key_ntilde,
      Key_ograve,
      Key_oacute,
      Key_ocircumflex,
      Key_otilde,
      Key_odiaeresis,
      Key_division,
      Key_oslash,
      Key_ugrave,
      Key_uacute,
      Key_ucircumflex,
      Key_udiaeresis,
      Key_yacute,
      Key_thorn,
      Key_ydiaeresis
        
    } KeyCode;

    MKeyEvent(KeyMessageType type, unsigned long time, KeyCode code, char ascii, const MShiftState &state, const MComponentPtr &component);
    MKeyEvent(KeyMessageType type, unsigned long time, KeyCode code, const MShiftState &state, const MComponentPtr &component);
    MKeyEvent(const MKeyEvent &src);

    /**
     * Gets the type of event that occurred. For example, a key press or 
     * release.
     */
    KeyMessageType getType() const;

    const MShiftState & getShiftState() const;
    bool isShiftDown() const;
    bool isControlDown() const;
    bool isAltDown() const;

    /**
     * This gets the component that the event occurred in.
     */
    MComponentPtr getComponent() const;

    KeyCode getCode() const;

    char getChar() const;

    static std::string keyCodeToStr(KeyCode code);
    static KeyCode strToKeyCode(const std::string &str);

  protected:
    /// The type of the key message.
    const KeyMessageType type;

    /// The time the mouse event occurred.
    const unsigned long time;

    /// The key code that the key message occurred with
    const KeyCode code;
    
    /// The ascii character associated with the message
    char ascii;

    /// The component that the event occurred in.
    const MComponentPtr component;

    const MShiftState state;
  };

  class AZTECGUI_EXPORT MKeyEventListener : public virtual IMGuiBase {
  public:
    virtual void onKeyEvent(const MComponentPtr &component, const MKeyEvent &event) = 0;
  };

  typedef MRefCountedPtr<MKeyEventListener> MKeyEventListenerPtr;


}

#include <gui/MComponent.h>


#endif

