
function textBoxListener(event, value){
  var text = "Key Event: " + event.type + " " + MKeyEvent.keyCodeToStr(event.code) + " " + event.ascii;
  output.setValue(text);
}


function labelledSliderListener(slider, output, functionCall, redraw){
  var text = slider.getValue();
  output.setValue(text);
  aztecFunction(functionCall, text);
  if(redraw) Scene.redraw();
}

function labelledCheckBoxListener(checkbox, output, functionCall, redraw){
  var text = slider.getValue();
  output.setValue(text);
  aztecFunction(functionCall, text);
  if(redraw) Scene.redraw();
}

function createLabelledTextField(container, caption, units, value, functionCall) {
  var label = new MLabel(caption);
  var component = new MTextField(value,8);
  var units = new MLabel(units);
  container.addComponent(label);
  container.addComponent(component);
  container.addComponent(units);
  component.addAcceptListener(textFieldListener, functionCall, 1);
}

function createLabelledCheckBox(container, caption, units, value, functionCall) {

  if(units==0) { units = "OFF";}
  else { units = "ON";}
  var label = new MLabel(caption);
  var checkBox = new MCheckbox();
  var units = new MLabel(units);
  container.addComponent(label);
  container.addComponent(checkBox);
  container.addComponent(units);
  units.setMinimumSize(30,20);
  checkBox.setValue(value);
  checkBox.addListener(checkBoxListener, checkBox, functionCall, units, 1);
}

function createLabelledSlider(container, caption,units, min, max, value,functionCall) {
  var label = new MLabel(caption);
  var slider = new MSlider(min, max, value);
  var units = new MLabel(units);
  var sliderValue = new MTextField(value, 5);

  container.addComponent(label);
  container.addComponent(sliderValue);
  container.addComponent(slider);
  container.addComponent(units);

  slider.addListener(labelledSliderListener, slider, sliderValue, functionCall, 1);
  slider.setMinimumSize(150,1);
  sliderValue.setMinimumSize(10,1);
  sliderValue.addAcceptListener(sliderTextFieldListener, slider);

}

function textFieldListener(field, functionCall, redraw){
  var value = field.getValue();
  aztecFunction(functionCall, value);
  if(redraw) Scene.redraw();
}

function sliderTextFieldListener(textField, slider){
    var fieldValue = textField.getValue();
	slider.setValue(fieldValue);
}


function checkBoxListener(field, functionCall, units, redraw){
  var value = field.getValue();
  var text = "OFF";
  aztecFunction(functionCall, value);
  if(value) text = "ON"; 
  units.setValue(text);
  if(redraw) Scene.redraw();
}

function createLabel(container,label){
	var label = new MLabel(label);
    container.addComponent(label);
}

function createHeadLine(container,headline){
  //var headline2 = "____________________" + headine + "____________________";
  var headline = new MLabel(headline);

  var blank = new MLabel("");
  var blank2 = new MLabel("");
  var blank3 = new MLabel("");
  container.addComponent(headline);
  container.addComponent(blank);
  container.addComponent(blank2);
  container.addComponent(blank3);
}

function aztecFunction(command, value) {
	eval(command + '(' + value + ')');
}

function displayOptionsWindow() {

  var mainWindow = new MToolWindow("Display Options");
  var gridRange = Scene.scene3DViewGetGridRange();
  var gridSpacing = Scene.scene3DViewGetGridSpacing();
  var gridMajorSpacing = Scene.scene3DViewGetGridMajorSpacing();
  var backfaceState = Scene.scene3DViewGetBackfaceState();

  mainWindow.setLayoutManager(new MFlowLayout(10,2,4));
  createHeadLine(mainWindow,"_______________________Display__Options_____________________");

  createLabelledCheckBox(mainWindow, "Back Face Culling", backfaceState, backfaceState, "Scene.scene3DViewToggleBackface")
  createLabel(mainWindow," ");  
  createHeadLine(mainWindow,"_________________________Grid Options______________________");

  createLabelledTextField(mainWindow,  "Grid Range +/-","units",gridRange,"Scene.scene3DViewSetGridRange");
  createLabel(mainWindow," ");
  createLabelledTextField(mainWindow, "Grid Spacing","units",gridSpacing,"Scene.scene3DViewSetGridSpacing");
  createLabel(mainWindow," ");
  createLabelledSlider(mainWindow, "Major Lines every","units",1,25,gridMajorSpacing,"Scene.scene3DViewSetGridMajorSpacing");

  mainWindow.setSize(300,100);
  mainWindow.setVisible(true);	

}
displayOptionsWindow();
