#ifndef Aztec2_DeletingView_Header
#define Aztec2_DeletingView_Header

namespace AztecGUI {

  /**
   * This interface exposes methods to allow a view to provide special ways 
   * of handing object deleting. This is done because each view may have 
   * special deleting needs. For example, in a 3D view, when the user hits the 
   * delete key, they want the selected 3D object deleting, but when they are 
   * in the graph view, and they want to delete things, they want the selected 
   * key frames deleted, not the selected object.
   */
  class DeletingView {
  public:
    /**
     * This is called when the user tries to do a editDeleteSelected().
     *
     * @returns true If the view has implemented this, false if it hasn't.
     */
    virtual bool deleteSelected() = 0;
  };

}

#endif 
