#ifndef AztecGLUtils_Header
#define AztecGLUtils_Header

#include <MMath.h>

#include <utils/OGLFT.h>


namespace AztecGUI {

  typedef OGLFT::Translucent AztecGLFont;

  float getWidgetSize();

  static const int GL_FONT_START = 1000;

  static const int DRAWAXIS_X = 0x0001;
  static const int DRAWAXIS_Y = 0x0002;
  static const int DRAWAXIS_Z = 0x0004;
  static const int DRAWAXIS_W = 0x0008;
  static const int DRAWAXIS_ALLAXES = 0x000F;
  static const int DRAWAXIS_XGRAY = 0x0010;
  static const int DRAWAXIS_YGRAY = 0x0020;
  static const int DRAWAXIS_ZGRAY = 0x0040;
  static const int DRAWAXIS_WGRAY = 0x0080;
  static const int DRAWAXIS_ALLGRAY = 0x00F0;
  static const int DRAWAXIS_LABELS = 0x0100;
  static const int DRAWAXIS_ARROWS = 0x0200;

  static const int DRAWAXIS_MIDDLE_NORMAL_X = 0x1000;
  static const int DRAWAXIS_MIDDLE_NORMAL_Y = 0x2000;
  static const int DRAWAXIS_MIDDLE_NORMAL_Z = 0x3000;

  static const int DRAWAXIS_MIDDLE_TYPE = 0x7000;

  static const int DRAWAXIS_NORMAL = 0x010F;

  /**
   * Draws the standard RGB axis icon using the given attributes. If 
   * ArrowHeads == true, arrow heads are placed on the end of the three 
   * lines, and a Yellow square is drawn parrallel to the screen. If Select 
   * == true then The manipulatros are drawn using glRenderMode(GL_SELECT)
   */
  int glDrawAxisIcon(AztecGLFont *font, float Size = 1.0, float Alpha = 1.0, float LineWidth = 2, bool Select = false, DWORD Flags = DRAWAXIS_NORMAL, const char *xLabel="X", const char *yLabel="Y", const char *zLabel="Z");
  int glDrawAxisIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 2, bool Select = false, Aztec::AztecFlags Flags = DRAWAXIS_NORMAL);

  /**
   * Draws the Rotate manipulator. Consiting of a RGB circles for rotation, 
   * and a yellow circle parellel to the screen for normal rotation.
   */
  int glDrawRotateIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 1.0, bool Select = false);
  /**
   * Draws the scale manipulator simlar to the move manipulator except with boxes on the end of each
   * line, rather than arrow heads.
   */
  int glDrawScaleIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 2, bool Select = false);
  /**
   * Draws a cuve at the origin with a side length of Size
   */
  int glDrawCube(float Size);
  /**
   * Draws an Arrow head who's fat end is at the origin, and point in the X direction
   * It has the given length, radius and alpha
   */
  int glDrawArrowHead(float Length, float Radius);

  /**
   * Draws a line of text
   */
  void glDrawText(float x, float y, const char *text);
  void glDrawText(float x, float y, const std::string &text);

  void glDrawText(float x, float y, const char *text, AztecGLFont *font);
  void glDrawText(float x, float y, const std::string &text, AztecGLFont *font);


}

#endif

