#ifndef QuickSliceTool_Header
#define QuickSliceTool_Header

#include <tools/MXYZToolType.h>

// AztecLib includes
#include <MLineShape.h>
#include <MLineMesh.h>

namespace AztecGUI {
  class QuickSliceTool : public MXYZToolType {
  public:
    QuickSliceTool();

    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    void initialise();
    bool finish();
    bool cancel();
    bool inProgress();
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int getDefaultManip();

  private:
    bool doingFirstPoint;
    Aztec::MVector3 firstPoint;
    Aztec::MVector3 secondPoint;

    Aztec::MVector3 getPositionFromMouse(const Aztec::MMouseEvent &event);
    void sliceSelectedMeshes(const Aztec::MVector3 &origin, const Aztec::MVector3 &normal);
  };
}
#endif