#ifndef MXYZToolType_Header
#define MXYZToolType_Header

#include <tools/M3DToolType.h>
#include <controls/AztecGLCanvas.h>

#include <MMesh.h>
#include <MMath.h>

namespace AztecGUI {
   
  class MConstraintType {
  public:
    void setConstraint(const Aztec::MPlane &plane);
    void setConstraint(const Aztec::MRay &ray);

    Aztec::MVector3 getConstrainedPoint(const Aztec::MRay &srcRay);

    Aztec::MVector3 getConstraintNormal();
  public:
    typedef enum {ctPlane, ctRay} Type;

    Type constraintType;
    Aztec::MPlane m_Plane;
    Aztec::MRay m_Ray;
  };

  class MXYZToolType : public M3DToolType {
  public:
    void MarkMeshVerticesComponents(Aztec::MMeshPtr Mesh, Aztec::AztecFlags CompMode);
    void PrepareSelectedObjects(Aztec::MVector3 &Origin, Aztec::MMatrix4 &SelObjXFormMat);
    void getPlaneParams(const AztecGLCanvasPtr &canvas, Aztec::MVector3 &Origin, Aztec::MVector3 &Dir, Aztec::MVector3 &ViewNorm, Aztec::MMatrix4 &XFormMat);
    void getPlaneParams(const AztecGLCanvasPtr &canvas, MConstraintType &con, const Aztec::MMatrix4 &axisTransform, Aztec::AztecFlags flags = 0);
    void getPlaneParams(const AztecGLCanvasPtr &canvas, MConstraintType &con, const Aztec::MMatrix4 &axisTransform, const Aztec::MVector3 &origin, Aztec::AztecFlags flags = 0);
  
    void UpdateKeys(const MStr &UndoName, Aztec::AztecFlags KeyFlags, bool holdValues = true);
  
    // MToolType methods
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);

    // Make these methods method pure virtual to ensure it is being overridden.
    int drawTool(bool Select, const Aztec::MComponentPtr &comp) = 0;
    virtual int getDefaultManip() = 0;


    void getAxisMatrix(const AztecGLCanvasPtr &canvas = NULL);
  protected:
    /**
     * This is the constraint which controls how rays are mapped to coordinate.
     */
    MConstraintType m_Constraint;

    /**
     * This is the matrix that represents the current axis we are moving along
     * going form world space to axis space.
     */
    Aztec::MMatrix4 m_AxisTransform;

    /**
     * This is the inverse of m_AxisTransform
     */
    Aztec::MMatrix4 m_AxisTransformInv;

    Aztec::MVector3 m_DownVec, m_UpVec, m_CurVec;    // The cursor coordinates in world space, if necessary

    void updateVectors();

    Aztec::MVector3 getSelectionCentre(const Aztec::MComponentPtr &component);
    bool anythingSelected(const Aztec::MComponentPtr &component);
    void prepareSceneObject(const Aztec::MSceneObjectPtr &sceneObj);
    static bool is3DView(const Aztec::MComponentPtr &component);
  };

}
#endif

