
#ifndef CUTTRANSLATOR_H
#define CUTTRANSLATOR_H

#include <translator/MImageTranslator.h>


using namespace Aztec;



class MCUTTranslator : public MImageTranslator {
protected:

public:
   MCUTTranslator();
   virtual ~MCUTTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MCUTTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.CUT"; }
   std::string getFilterDescription() { return "Dr. Halo CUT Files"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
