#include "Stdafx.h"

#include "PrimSphere.h"

#include "MBaseObject.h"
#include "MShapeObject.h"
#include "MMesh.h"
#include "MEditableMesh.h"

#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------
//  MPrimitiveSphere
//----------------------------------------------------------------------------------------
MPrimitiveSphere::MPrimitiveSphere() {
  addParameter(radiusParam = Aztec::MParameterFactory::createFloat("R", "Radius", "Radius"));
  addParameter(sectionsParam = Aztec::MParameterFactory::createInteger("s", "sections", "Sections"));
  addParameter(vertSectionsParam = Aztec::MParameterFactory::createInteger("vs", "vertSections", "Vertical Sections"));
  
  radiusParam->setValueFloat(10.0f);
  sectionsParam->setValueInteger(16);
  vertSectionsParam->setValueInteger(12);
  
  setFlag(OBJECTFLAG_NOCOMPONENTS);
  
  m_LastMesh = NULL;
  
}

MPrimitiveSphere::~MPrimitiveSphere()
{
  m_LastMesh = NULL;
}

Aztec::MBaseObjectPtr MPrimitiveSphere::createNew() {
  MPrimitiveSphere    *NewObj;
  
  NewObj = new MPrimitiveSphere;
  
  NewObj->m_ParamList->setFromList(getParamList());
  
  return NewObj;
}

// MBaseObject methods
bool MPrimitiveSphere::doUpdateObject() {
  MMeshCreator::doUpdateObject();
  
  getOutputParameter()->setValue(convertToMesh());

  return true;
}

#include <math.h>

inline int getVert(int around, int down, int sections) {
  return (around % (sections)) + down*sections + 1;

}

Aztec::MMeshPtr MPrimitiveSphere::convertToMesh() {

  if (radiusParam->getValue() != lastRadius ||
      sectionsParam->getValue() != lastSections ||
      vertSectionsParam->getValue() != lastVertSections) 
  {
    lastRadius = radiusParam->getValue();
    lastSections = sectionsParam->getValue();
    lastVertSections = vertSectionsParam->getValue();

    Aztec::MEditableMeshPtr mesh = new Aztec::MEditableMesh;
    double stepAlpha = 360.0 / (double)lastSections;
    double stepBeta = 180 / (double)lastVertSections;

    // add the top
    mesh->addVertex(0, 0, lastRadius);

      
    for (int j = 1; j < lastVertSections; ++j) {
      for (int i = 0; i < lastSections; ++i) {
        Aztec::MVector3 u(lastRadius,0,0);
        Aztec::MVector3 res, res1;
        Aztec::rotateWithVector(u, Aztec::MVector3(0,1,0), (-90 + stepBeta * (double)j)*3.14159/180.0, res);
        Aztec::rotateWithVector(res, Aztec::MVector3(0,0,1), (stepAlpha * (double)i)*3.14159/180.0, res1);

        mesh->addVertex(res1.x, res1.y, res1.z);
      }

    }



    // add the bottom
    mesh->addVertex(0, 0, -lastRadius);

    // now add all the triangles.
    for (int i = 0; i < lastSections; ++i) {
      mesh->addTriangle(0, getVert(i, 0, lastSections), getVert(i+1, 0, lastSections));
    }

    std::vector<int> quad;
    quad.resize(4);
    for (int i = 0; i < lastSections; ++i) {
      for (int j = 0; j < lastVertSections - 2; ++j) {
        quad[3] = getVert(i, j, lastSections);
        quad[2] = getVert(i+1, j, lastSections);
        quad[1] = getVert(i+1, j+1, lastSections);
        quad[0] = getVert(i, j+1, lastSections);

        mesh->triangulatePolygon(quad);
      }
    }


    for (int i = 0; i < lastSections; ++i) {
      mesh->addTriangle(mesh->getNumVerts() - 1, getVert(i+1, lastVertSections-2, lastSections), getVert(i, lastVertSections-2, lastSections));
    }

    Aztec::MMeshPtr realMesh = new Aztec::MMesh(mesh);

    realMesh->calculateNormals();
    m_LastMesh = realMesh;
  }
  
  return m_LastMesh;
}

