#include "Stdafx.h"
#include <stdlib.h>


#include "PrimCube.h"
#include "MSystemManager.h"
#include <params/MParameterFactory.h>

#include "MEditableMesh.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MPrimitiveCube::MPrimitiveCube()
{
   addParameter(MParameterFactory::createFloat("Wd", "Width", "Width"));
   addParameter(MParameterFactory::createFloat("Hi", "Height", "Height"));
   addParameter(MParameterFactory::createFloat("Dp", "Depth", "Depth"));
   addParameter(MParameterFactory::createInteger("WdDv", "WidthDiv", "Width Divisions"));
   addParameter(MParameterFactory::createInteger("HiDv", "HeightDiv", "Height Divisions"));
   addParameter(MParameterFactory::createInteger("DpDv", "DepthDiv", "Depth Divisions"));

   setParamByName("Wd", "10");
   setParamByName("Hi", "10");
   setParamByName("Dp", "10");
   setParamByName("WdDv", "1");
   setParamByName("HiDv", "1");
   setParamByName("DpDv", "1");

   m_LastDX = m_LastDY = m_LastDZ = 0;

   setFlag(OBJECTFLAG_NOCOMPONENTS);

   m_LastMesh = NULL;

}

MPrimitiveCube::~MPrimitiveCube() {
}

MBaseObjectPtr MPrimitiveCube::createNew() {
   MPrimitiveCube *NewObj;

   NewObj = new MPrimitiveCube;
   NewObj->m_ParamList->setFromList(getParamList());

   return NewObj;
}

bool MPrimitiveCube::doUpdateObject() {
  MMeshCreator::doUpdateObject();
  
  m_ParamList->getParameter("Wd")->getValueFloat(m_Size.x);
  m_ParamList->getParameter("Hi")->getValueFloat(m_Size.y);
  m_ParamList->getParameter("Dp")->getValueFloat(m_Size.z);

  getOutputParameter()->setValue(convertToMesh());

  return true;
}

// Generates a 2D plane based on the two basis vectors, and the starting point. NumX and NumY are the number
// of subdivisions.
static void CubeGeneratePlane(const MVector3 &Start, const MVector3 &BasisX, const MVector3 &BasisY, int NumX, int NumY, MVector3 **pVerts, MTriangle **pTris, int &NumVerts, int &NumTris)
{
   MVector3 *Verts, *Vert;
   MTriangle   *Tris, *Tri;
   int         x, y;

   NumVerts = (NumX + 1) * (NumY + 1);
   NumTris = 2 * (NumX) * (NumY);

   Verts = new MVector3[NumVerts];
   Tris = new MTriangle[NumTris];

   *pVerts = Verts;
   *pTris = Tris;

   Vert = Verts;


   for (y = 0; y<NumY+1; y++)
   {
      for (x = 0; x<NumX+1; x++)
      {
         MVector3     Pos;
         Pos = Start;
         Pos += (BasisX * (float)x) + (BasisY * (float)y);

         *Vert = Pos;

         Vert++;
      }
   }
   Tri = Tris;
   for (y = 0; y < NumY; y++)
   {
      for (x = 0; x < NumX; x++)
      {
         Tri->setVertex(2, (y) * (NumX+1) + x);
         Tri->setVertex(1, (y) * (NumX+1) + x + 1);
         Tri->setVertex(0, (y+1) * (NumX+1) + x);
         Tri->unsetEdgeFlag(0, EDGE_VISIBLE);
         Tri++;
         Tri->setVertex(2, (y) * (NumX+1) + x + 1);
         Tri->setVertex(1, (y+1) * (NumX+1) + x + 1);
         Tri->setVertex(0, (y+1) * (NumX+1) + x);
         Tri->unsetEdgeFlag(2, EDGE_VISIBLE);
         Tri++;
      }
   }
}

MMeshPtr MPrimitiveCube::convertToMesh() {
  
  // Create the mesh
  MMeshPtr    Mesh;
  MVector3 *Verts;
  MTriangle   *Tris;
  MVector3    Step, Start;
  int         NumVerts, NumTris, NumTotalVerts;
  
  int         DX, DY, DZ;
  
  DX = getParamByName("WdDv").ToInt();
  DY = getParamByName("HiDv").ToInt();
  DZ = getParamByName("DpDv").ToInt();
  
  if (m_LastMesh != NULL) {
    if (m_LastDX == DX && m_LastDY == DY && m_LastDZ == DZ && m_Size == m_LastSize) {
      return m_LastMesh;
    }
  }
  
  m_LastSize = m_Size;
  m_LastDX = DX;
  m_LastDY = DY;
  m_LastDZ = DZ;
  
  MEditableMeshPtr tempMesh = new MEditableMesh();
  
  Start = -0.5 * m_Size;;
  Step = m_Size;
  Step.x *= 1.0f / DX;
  Step.y *= 1.0f / DY;
  Step.z *= 1.0f / DZ;
  
  MVector3    BasisX, BasisY, BasisZ;
  
  BasisX.set(Step.x, 0, 0);
  BasisY.set(0, Step.y, 0);
  BasisZ.set(0, 0, Step.z);
  
  NumTotalVerts = 0;
  NumTotalVerts = 0;
  
  CubeGeneratePlane(Start, BasisX, BasisY, DX, DY, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  CubeGeneratePlane(Start, BasisZ, BasisX, DZ, DX, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  CubeGeneratePlane(Start, BasisY, BasisZ, DY, DZ, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  Start *= -1.0;
  BasisX *= -1.0;
  BasisY *= -1.0;
  BasisZ *= -1.0;
  
  CubeGeneratePlane(Start, BasisY, BasisX, DY, DX, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  CubeGeneratePlane(Start, BasisX, BasisZ, DX, DZ, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  CubeGeneratePlane(Start, BasisZ, BasisY, DZ, DY, &Verts, &Tris, NumVerts, NumTris);
  tempMesh->addVertsAndTriangles(Verts, Tris, NumVerts, NumTris);
  delete[] Verts;
  delete[] Tris;
  
  tempMesh->weldVertices(0, 0.0);
  
  Mesh = new MMesh(tempMesh);
  m_LastMesh = Mesh;
  
  Mesh->calculateNormals();
  
  return Mesh;
}
