#ifndef PRIMCUBE_H
#define PRIMCUBE_H

#include <mesh/MMeshCreator.h>

#define PRIMITIVECUBE_CHAN_WIDTH       0x0001
#define PRIMITIVECUBE_CHAN_HEIGHT      0x0002
#define PRIMITIVECUBE_CHAN_DEPTH       0x0004

using namespace Aztec;

//----------------------------------------------------------------------------------------
//  MPrimitiveCube
//----------------------------------------------------------------------------------------
class MPrimitiveCube : public MMeshCreator {
protected:
   MVector3 m_Size, m_LastSize;
   int m_LastDX, m_LastDY, m_LastDZ;
   MMeshPtr m_LastMesh;

public:
  // Construction/Destruction
  MPrimitiveCube();
  ~MPrimitiveCube();

  // MMeshCreator methods

  // MBaseObject methods
  MStr getClassName() {return MStr("MPrimitiveCube");};
  MBaseObjectPtr createNew();
  bool doUpdateObject();

protected:
  MMeshPtr convertToMesh();
};

#endif
 
