#ifndef ParticleShapePlugin_Header
#define ParticleShapePlugin_Header

#include "AztecGUIMParameterPlugin.h"
#include "dialogs/ParticleParamDlg.h"
#include "PrimParticle.h"

class ParticleShapePlugin : public AztecGUI::MParameterPlugin {
public:
	ParticleShapePlugin();
	~ParticleShapePlugin();
	
	// MParameterPlugin methods
	std::string getFriendlyName();
	bool isUIForObject(const Aztec::MBaseObjectPtr &obj);
	void createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object);
	void destroyControls();
    bool hasChannelControls();
	int getChannelControlsHeight();
    void createChannelControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object);
    void destroyChannelControls();
	void cancelChanges();
	void updateGUIValues(const Aztec::MBaseObjectPtr &object);
	
private:
	MParticlePtr particleShape;
	CParticleParamDlg *dlg;
	CParticleParamDlg *channelDlg;
};



#endif