#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MLabel.h>
#include <gui/MBorderLayout.h>
#include <gui/MButton.h>

class HelloWorld : public Aztec::MApp {
public:

  bool initApp() {
    Aztec::MWindowPtr mainWindow = new Aztec::MWindow("Border Layout example");

    // we have to explicitly create top level windows. All other controls are auto created.
    if (!mainWindow->create()) {
      // if the window creation failed, bail out.
      return false;
    }

    mainWindow->setSize(500,500);

    // The layout manager takes care of the placement of components.
    mainWindow->setLayoutManager(new Aztec::MBorderLayout());


    Aztec::MContainerPtr container;

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(1.0, 0.0, 0.0));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    mainWindow->addComponent(container, Aztec::MBorderLayout::WEST);
    container->addComponent(new Aztec::MButton("West"));

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(0.0, 1.0, 0.0));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    mainWindow->addComponent(container, Aztec::MBorderLayout::EAST);
    container->addComponent(new Aztec::MButton("East"));

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(0.0, 0.0, 1.0));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    mainWindow->addComponent(container, Aztec::MBorderLayout::NORTH);
    container->addComponent(new Aztec::MButton("North"));

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(1.0, 1.0, 0.0));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    mainWindow->addComponent(container, Aztec::MBorderLayout::SOUTH);
    container->addComponent(new Aztec::MButton("South"));

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(0.0, 1.0, 1.0));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    mainWindow->addComponent(container, Aztec::MBorderLayout::NORTH_INNER);
    container->addComponent(new Aztec::MButton("Inner North"));

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(1.0, 0.0, 1.0));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    mainWindow->addComponent(container, Aztec::MBorderLayout::SOUTH_INNER);
    container->addComponent(new Aztec::MButton("Inner South"));

    container = new Aztec::MContainer();
    container->setMinimumSize(Aztec::MSize2D(64,64));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    mainWindow->addComponent(container, Aztec::MBorderLayout::CENTRE);
    container->addComponent(new Aztec::MButton("Centre"));

    


    // Now display our main window.
    mainWindow->setVisible(true);

    // return true to indicate that eveything started up okay.
    return true;
  }

  void cleanup() {
  }

};


AZTEC_USE_APP(HelloWorld)