#include <BasicParamGUIPCH.h>

#include <SceneObjectPlugin.h>
#include <MMath.h>
#include <AztecGUIMPluginManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


SceneObjectPlugin::SceneObjectPlugin() {
  dlg = NULL;
}

SceneObjectPlugin::~SceneObjectPlugin() {
}


// MParameterPlugin methods
std::string SceneObjectPlugin::getFriendlyName() {
  return "Scene Object";
}

bool SceneObjectPlugin::isUIForObject(const Aztec::MBaseObjectPtr &obj) {
  return AZTEC_CAST(Aztec::MSceneObject, obj) != NULL;
}

void SceneObjectPlugin::createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object) {
  sceneObject = AZTEC_CAST(Aztec::MSceneObject, object);

  // if we don't have a scene object, we shouldn't create anything.
  if (sceneObject == NULL) {
    return;
  }

  CWnd *pWnd = CWnd::FromHandle(parentWnd);

  dlg = new CSceneObjectDlg(pWnd);
  dlg->Create(CSceneObjectDlg::IDD, pWnd);
  dlg->ShowWindow(SW_SHOW);

  RECT totalRect;
  dlg->GetClientRect(&totalRect);

  Aztec::MShapeObjectPtr shapeObj = sceneObject->getShapeObject();

  AztecGUI::MPluginManager::ParameterPluginList pluginList;
  AztecGUI::MPluginManager::getPluginsForObject(shapeObj, pluginList);

  RECT newWindowRect;

  newWindowRect.left = 0;
  newWindowRect.right = 100;
  newWindowRect.top = totalRect.bottom;
  newWindowRect.bottom = newWindowRect.top + 100;

  pWnd->SetWindowPos(NULL, 0, 0, totalRect.right, totalRect.bottom, SWP_NOZORDER | SWP_NOMOVE);
}

void SceneObjectPlugin::destroyControls() {
  CWndPluginList::iterator wndIt;

  for (wndIt = shapeObjWnds.begin(); wndIt != shapeObjWnds.end(); ++wndIt) {
    wndIt->second->destroyControls();
    wndIt->first->DestroyWindow();
    delete wndIt->first;
  }

  shapeObjWnds.clear();

  if (dlg != NULL) {
    dlg->DestroyWindow();
    delete dlg;
    dlg = NULL;
  }
}

void SceneObjectPlugin::cancelChanges() {
}

void SceneObjectPlugin::updateGUIValues(const Aztec::MBaseObjectPtr &object) {
  char buf[1024];

  Aztec::MVector3 transVec = sceneObject->getParamVec("Tsl");

  sprintf(buf, "%.3f", transVec.x);
  dlg->m_TranslateX.SetWindowText(buf);
  sprintf(buf, "%.3f", transVec.y);
  dlg->m_TranslateY.SetWindowText(buf);
  sprintf(buf, "%.3f", transVec.z);
  dlg->m_TranslateZ.SetWindowText(buf);
}

