// GraphViewWnd.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include <views/RenderView.h>
#include <funcs/KeyFuncRender.h>

#include "MdlGlobs.h"

#include <misc/FileTools.h>
#include <misc/MSceneHelper.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int toolbarHeight = 33;
static const int borderWidth = 2;

static const int ParamListID = 10002;

static const int RENDER_CAMERA_MENU_BASE = 17000;

RenderView::RenderView()
{
  paintDC = NULL;
  imageViewer = NULL;
}

RenderView::~RenderView()
{
  if (imageViewer != NULL) {
    delete imageViewer;
  }

}


BEGIN_MESSAGE_MAP(RenderView, CWnd)
	//{{AFX_MSG_MAP(RenderView)
  ON_WM_SIZE()
  ON_WM_PAINT()
	ON_WM_CLOSE()
  ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void RenderView::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  paintDC = dc.m_hDC;
  DrawView();
  paintDC = NULL;
}

MBaseObjectPtr RenderView::createNew()
{
   RenderView  *Wnd;

   Wnd = new RenderView;
   Wnd->setName(getName());

   return (MBaseObject*)Wnd;
}

class RenderMenu : public MMenuBar::PopupMenu {
public:
  RenderMenu(DWORD resource) 
    : PopupMenu(resource)
  {
  }

  HMENU createMenu() {
    HMENU popup = PopupMenu::createMenu();
    
    // now modify the popup menu's render view sub menu so we add in all the views.
    HMENU viewsSubmenu = ::CreateMenu();

    MSceneHelper<MCamera>::SceneShapeVector cameras = MSceneHelper<MCamera>::findObjectsOfType(g_Scene);

    // now loop over the camers and add in our items
    if (cameras.size() == 0) {
      ::AppendMenu(viewsSubmenu, MF_STRING | MF_GRAYED, 0, "No cameras defined in scene");
    } else {
      for (int i = 0; i < cameras.size(); ++i) {
        ::AppendMenu(viewsSubmenu, MF_STRING, RENDER_CAMERA_MENU_BASE + i, cameras[i].first->getName().c_str());
      }
    }

    // now add in the sub menu to the popup menu
    MENUITEMINFO menuItemInfo;
    memset(&menuItemInfo, 0, sizeof(MENUITEMINFO));
    menuItemInfo.cbSize = sizeof(MENUITEMINFO);
    menuItemInfo.fMask = MIIM_SUBMENU;
    menuItemInfo.hSubMenu = viewsSubmenu;

    ::SetMenuItemInfo(popup, ID_POPUP_RENDERVIEW, FALSE, &menuItemInfo);


    // modify our render last menu to append the name to it.
    {
      MParameterObjectListPtr generalOptions = getDefaultGeneralOptions();

      readInRenderSettings("general", generalOptions);
      MStr cameraName;
      generalOptions->getParameter("camera")->getValueString(cameraName);

      if (cameraName.GetLength() > 0) {
        // try and find this camera in the scene. If we can't, then disable the menu item.
        MBaseObjectPtr camera = g_Scene->getObjectList()->findObject(cameraName);

        MENUITEMINFO menuItemInfo;
        memset(&menuItemInfo, 0, sizeof(MENUITEMINFO));
        menuItemInfo.cbSize = sizeof(MENUITEMINFO);

        MStr menuName = "Redo Last Render - ";
        menuName += cameraName;
        menuItemInfo.fMask = MIIM_TYPE;
        menuItemInfo.fType = MF_STRING;
        menuItemInfo.dwTypeData = const_cast<char*>(menuName.c_str());

        // if we couldn't find the camera, disable it.
        if (camera == NULL) {
          menuItemInfo.fMask |= MIIM_STATE;
          menuItemInfo.fState = MFS_GRAYED;

        }
        ::SetMenuItemInfo(popup, ID_POPUP_DORENDER, FALSE, &menuItemInfo);
      }
    }

    return popup;
  }
};


void RenderView::ViewCreate() {
  MBaseViewWnd::ViewCreate();

  CRect clientRect;
  getClientRect(&clientRect);

  MMenuBar *menuBar = getMenuBar();

  menuBar->addMenu("Render", new RenderMenu(IDR_RENDERVIEW_MENU), 0);

  if (imageViewer == NULL) {
    imageViewer = new ImageViewer();
    
    imageViewer->Create(CRect(clientRect.left,clientRect.top,clientRect.right,clientRect.bottom), 
                        this);
    imageViewer->ShowWindow(SW_SHOW);
  }

}


void RenderView::DrawView() {
  MBaseViewWnd::DrawView();

}

DWORD RenderView::ViewPopupMenu(int x, int y)
{
   CMenu    Menu;
   CMenu    *Popup;
   DWORD    Choice;

   Menu.LoadMenu(IDR_GRAPHVIEW_POPUP);
   Popup = Menu.GetSubMenu(0);
   InitPopupMenu(Popup);

   // Check the carious menu items depending on the current flags etc.

   Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);

   Popup->DestroyMenu();

   bool     Update;
   int      Result;

   Result = HandlePopupCommand(Choice);

   // The command was handled, but the view was changed, so we must return.
   if (Result == -1)
      return 1;
      
   if (Result == 1)
      Update = true;
   else 
      Update = false;

   if (Update) {
     Invalidate();
     UpdateWindow();
   }
   
   return Choice;
}

int RenderView::HandlePopupCommand(DWORD Cmd)
{
   int Result;

   Result = MBaseViewWnd::HandlePopupCommand(Cmd);

   if (Result) {
      return Result;
   }

   switch (Cmd)
   {
   case ID_POPUP_DORENDER:
     g_KeyList.ExecuteAction("doRender");
     return 1;
   case ID_POPUP_SAVEAS:
     saveCurrentImage();
     return 1;
   case ID_POPUP_RENDEROPTIONS:
     showRenderOptions();
     return 1;
   }

   // see if we have executed a render a camera action. I can't see us having more than 50 cameras
   if (Cmd >= RENDER_CAMERA_MENU_BASE && Cmd < RENDER_CAMERA_MENU_BASE + 50) {
     MSceneHelper<MCamera>::SceneShapeVector cameras = MSceneHelper<MCamera>::findObjectsOfType(g_Scene);
     doRender(cameras[Cmd - RENDER_CAMERA_MENU_BASE].first);
   }

   return 0;
}

ImageViewer* RenderView::getImageComponent() {
  return &*imageViewer;
}

void RenderView::doZoomToFit(bool doSelection) {
}

void RenderView::onMouseDown(int x, int y, MShiftState Shift) {
  MBaseViewWnd::onMouseDown(x,y,Shift);

}

void RenderView::onMouseUp(int x, int y, MShiftState Shift) {
  MBaseViewWnd::onMouseUp(x,y,Shift);

}


void RenderView::onMouseMove(int x, int y, MShiftState Shift) {
  ::SetCursor(LoadCursor(NULL, IDC_ARROW));

  MBaseViewWnd::onMouseMove(x,y,Shift);
}

void RenderView::zoomIn() {
}

void RenderView::zoomOut() {
}

void RenderView::zoomToFitAll() {
}

void RenderView::zoomToFitSelected() {
}

void RenderView::saveCurrentImage() {
  std::vector<MImageTranslatorPtr> translators = MSystemManager::getInstance()->getPluginManager()->getImageTranslators(MPluginManager::DONT_CARE, MPluginManager::MUST);
  std::string filter = 
    FileTools::createFilterString(
      translators, 
      false, 
      false);
  CFileDialog Dlg(FALSE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter.c_str());
//  Dlg.m_ofn.lpstrInitialDir = (LPCTSTR)LastModelDir;

  if (Dlg.DoModal() == IDOK) {
    MImageTranslatorPtr translator = translators[Dlg.m_ofn.nFilterIndex - 1];
    translator->exportFile((LPCTSTR)Dlg.GetPathName(), imageViewer->getImage());
  }

}

void RenderView::onSize() {
  MBaseViewWnd::onSize();

  CRect clientRect;
  GetClientRect((RECT*)&clientRect);
  GetClientRect(&m_PopupRect);

//  clientRect.left += borderWidth;
//  clientRect.top += borderWidth;
//  clientRect.right -= borderWidth;
//  clientRect.bottom -= borderWidth;

  
  if (imageViewer != NULL) {
    if (imageViewer->m_hWnd != NULL) {
      imageViewer->SetWindowPos(NULL, 
                            clientRect.left, clientRect.top,
                            clientRect.Width(), clientRect.Height(), 
                            SWP_NOZORDER);
    }
  }
}

void RenderView::OnClose() 
{
   g_ViewList.DeleteView(this);
	
//	CWnd::OnClose();
}

void RenderView::OnDestroy() {
  if (imageViewer != NULL) {
    imageViewer->DestroyWindow();
    delete imageViewer;
    imageViewer = NULL;
  }

  MBaseViewWnd::OnDestroy();
}

BOOL RenderView::OnCommand( WPARAM wParam, LPARAM lParam ) {

  // check to see if we have received a comand from a menu
  if (lParam == 0) {
    int result = HandlePopupCommand(LOWORD(wParam));
    bool update = false;
  
    // The command was handled, but the view was changed, so we must return.
    if (result == -1) {
      return 1;
    }
  
    if (result == 1) {
      update = true;
    } else {
      update = false;
    }
  
    if (update) {
      Invalidate();
      UpdateWindow();
    }
  }
  
  return TRUE;
}


