#define MainFuncs_CPP

//---------------------------------------------------------------------------
#include <AztecMainPCH.h>

#include "MainFunc.h"
#include "MDLGlobs.h"
#include "DlgGlobs.h"

#include <MUIManager.h>
#include <AztecGUIMPluginManager.h>
#include <misc/ResourceManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void AddWndStyle(HWND hWnd, long NewStyle) {
   long l = ::GetWindowLong(hWnd, GWL_STYLE);
   ::SetWindowLong(hWnd, GWL_STYLE, l | NewStyle);
}

void AddWndStyle(HWND hWnd, DWORD CtrlID, long NewStyle) {
   HWND  hCtrl;

   hCtrl = ::GetDlgItem(hWnd, CtrlID);
   if (hCtrl == NULL)
      return;

   long l = ::GetWindowLong(hCtrl, GWL_STYLE);
   ::SetWindowLong(hCtrl, GWL_STYLE, l | NewStyle);
}

int GetCWndWidth(const CWnd &Wnd) {
   RECT  Rect;
   Wnd.GetWindowRect(&Rect);
   return Rect.right-Rect.left;
}

int GetCWndHeight(const CWnd &Wnd) {
   RECT  Rect;
   Wnd.GetWindowRect(&Rect);
   return Rect.bottom-Rect.top;
}

class MyScriptCallbacks : public CScriptCallbacks {
public:

  // CScriptCallbacks methods
  int puts(const char *str) {
    MSystemManager::getInstance()->getLogger()->writeString(str);
    return 1;
  }

  void updateDisplay() {
  	g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
	  g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  }

  actionFunc* getActionFunction(const char *actionName) {
    MAction *action = g_KeyList.FindAction(actionName, "");
    if (action == NULL)
      return NULL;
    
    return action->m_Exec;
  }

};


MyScriptCallbacks script;


void InitialiseGlobals() {
  g_SysMan->logOutput("Initialising globals...");

  // Add in the resource location entries for locating scripts and what not.
  {
    MStr directory;
    char buf[512];
    ::GetModuleFileName(NULL, buf, 512);
    directory = buf;
    MStr drive,dir;
    directory.SplitPath(&drive,&dir,NULL,NULL);
    std::string strdir = (drive+dir).c_str();

    Aztec::ResourceManager::addResourcePath(".");
    Aztec::ResourceManager::addResourcePath(strdir);
    Aztec::ResourceManager::addResourcePath(strdir + "../../common");
    Aztec::ResourceManager::addResourcePath("$(AZTEC_SCRIPT_PATH)");

    MScriptInterpreter::getInstance()->ExecuteScript((MStr("cd('") + strdir + "../../common/Scripts')").c_str());
  }
  

  // set up the initial scene
  MScene::setGlobalScene(new MScene());

  // Initialise all the different translators.
  { 
    MStr directory;

    char buf[512];
    ::GetModuleFileName(NULL, buf, 512);
    directory = buf;
    MStr drive,dir;
    directory.SplitPath(&drive,&dir,NULL,NULL);
    directory = drive+dir;

	// Aztec only uses DLLs with the *.DLL exentsion now
    //g_SysMan->findAndLoadDLLs(directory, "*.DLM");
    //g_SysMan->findAndLoadDLLs(directory, "*.DLF");
    g_SysMan->findAndLoadDLLs(directory, "*.DLL");

	MScriptInterpreter::getInstance()->extendScripting(g_SysMan.m_Ptr);
    
    g_Scene = g_SysMan->getScene();

    AztecGUI::MPluginManager::initialise();
    AztecGUI::MPluginManager::loadPlugins((LPCTSTR)directory, "*.dll");
  }
  
  // initialise the script engine callbacks
  MScriptInterpreter::getInstance()->putCallbacks(&script);

  g_SysMan->logOutput("Finished Initialising globals.");
}

void CleanUpGlobals() {
  g_SysMan->logOutput("Cleaning Up Globals...");

  Aztec::MUIManager::removeAllListeners();
  g_SysMan->logOutput("Deleting Undo and Redo Nodes...");
  Aztec::getSystemManager()->getUndoManager()->clearUndoInfo();

  g_ClrPickDlg->DestroyWindow();
  delete g_ClrPickDlg;

  // Clean up the tool manager
  g_ToolMan.DeleteList();

  g_Scene = NULL;

  g_ViewList.DeleteAllViews();
  g_CurView = NULL;

  g_Views[0] = NULL;
  g_Views[1] = NULL;
  g_Views[2] = NULL;
  g_Views[3] = NULL;

  // cleaning up the script interpreter
  Aztec::MScriptInterpreter::cleanInstance();

  AztecGUI::MPluginManager::cleanup();
}


COLORREF RGBToColorRef(BYTE rgb[3]) {
   return RGB(rgb[0], rgb[1], rgb[2]);
}

int WrapMouseToScreen(HWND hWnd, int &x, int &y, int &ox, int &oy)
{
   int      targX, targY;
   bool     changed=false;
   POINT    C,S;
   int      ScreenWidth, ScreenHeight;
   
   ScreenWidth = ::GetSystemMetrics(SM_CXSCREEN);
   ScreenHeight = ::GetSystemMetrics(SM_CYSCREEN);
   
   C.x = x;
   C.y = y;
   S = C;
   
   ClientToScreen(hWnd, &S);
   
   targX = (int)(65535.0*(0.5+S.x)/ScreenWidth);
   targY = (int)(65535.0*(0.5+S.y)/ScreenHeight);
   
   if (S.x == ScreenWidth-1)
   {
      targX = (int)(2*(65535.0/ScreenWidth));
      ox += 1-ScreenWidth;
      x += 1-ScreenWidth;
      changed = true;
   }
   else
   {
      if (S.y == ScreenHeight-1)
      {
         targY = (int)(2*(65535.0/ScreenHeight));
         oy += 1-ScreenHeight;
         y += 1-ScreenHeight;
         changed = true;
      }
      else
      {
         if (S.x == 0)
         {
            targX = (int)(65535 - 2*(65535.0/ScreenWidth));
            ox -= 1-ScreenWidth;
            x -= 1-ScreenWidth;;
            changed = true;
         }
         else
         {
            if (S.y == 0)
            {
               targY = (int)(65535 - 2*(65535.0/ScreenHeight));
               oy -= 1-ScreenHeight;
               y -= 1-ScreenHeight;
               changed = true;
            }
         }
      }
   }
   
   if (changed)
   {
      mouse_event(MOUSEEVENTF_MOVE|MOUSEEVENTF_ABSOLUTE, targX,targY,0,0);
      return 1;
   }
   return 0;
}


