#include <AztecMainPCH.h>

#include "MenuItem.h"
#include "Keyboard.h"
#include "MdlConst.h"
#include "ModelGLConst.h"

#include "resource.h"

#include "DlgGlobs.h"   // Global dialog variables.
#include "MdlGlobs.h"

#include "MDLMsgs.h"

#include "KeyFuncView.h"

#include "SceneViewWnd.h"
#include "UVEditViewWnd.h"
#include "SegmentViewWnd.h"
#include "GraphViewWnd.h"
#include "ParameterViewWnd.h"
#include <views/ImageViewerView.h>
#include <views/RenderView.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void InitViewActionList(MActionListType *AL) {
  g_SysMan->logOutput("Initialising View Action List");
  
  // Viewport functions
  AL->Add("KViewportTop", "Top View", "View", KViewportTop);
  AL->Add("KViewportFront", "Front View", "View", KViewportFront);
  AL->Add("KViewportRight", "Right View", "View", KViewportRight);
  AL->Add("KViewportBottom", "Bottom View", "View", KViewportBottom);
  AL->Add("KViewportBack", "Back View", "View", KViewportBack);
  AL->Add("KViewportLeft", "Left View", "View", KViewportLeft);
  AL->Add("KViewportPerspective", "Perspective View", "View", KViewportPerspective);
  AL->Add("KViewportSceneOutline", "Scene Outline View", "View", KViewportSceneOutline);
  AL->Add("KViewportSegmentEditor", "Segment Editor View", "View", KViewportSegmentEditor);
  AL->Add("KViewportUVEdit", "UV Edit View", "View", KViewportUVEdit);
  AL->Add("KViewportGraphView", "Graph View", "View", KViewportGraphView);
  AL->Add("KViewportParameterView", "Parameter View", "View", KViewportParameterView);
  AL->Add("KViewportImageView", "Image View", "View", KViewportImageView);
  AL->Add("KViewportRenderView", "Render View", "View", KViewportRenderView);
  AL->Add("KViewportMakeCopy", "Make Copy of View", "View", KViewportMakeCopy);
  
  
  AL->Add("KViewportFrameAll", "Frame All", "View", KViewportFrameAll);
  AL->Add("KViewportFrameSelected", "Frame Selected", "View", KViewportFrameSelected);
  AL->Add("KViewportZoomIn", "Zoom In", "View", KViewportZoomIn);
  AL->Add("KViewportZoomOut", "Zoom Out", "View", KViewportZoomOut);
  
  AL->Add("KViewportIncreaseIconSize", "Increase Icon Size", "View", KViewportIncreaseIconSize);
  AL->Add("KViewportDecreaseIconSize", "Decrease Icon Size", "View", KViewportDecreaseIconSize);
  
  AL->Add("KViewportRedrawAll", "Redraw All Viewports", "View", KViewportRedrawAll);
  AL->Add("KViewportFullScreen", "Toggle Fullscreen", "View", KViewportFullScreen);
  AL->Add("KViewportToggleGrid", "Toggle Grid Visibiliy", "View", KViewportToggleGrid);

  AL->Add("KSegmentViewZoomIn", "Segment View Zoom In", "View", KSegmentViewZoomIn);
  AL->Add("KSegmentViewZoomOut", "Segment View Zoom Out", "View", KSegmentViewZoomOut);
}
// viewport functions

int KViewportMakeCopy() {
  // Make a copy of the current viewport into a window.
  
  if (g_CurView == NULL)
    return 0;
  
  MBaseViewWndPtr NewView;
  
  NewView = AZTEC_CAST(MBaseViewWnd, g_CurView->createNew());
  NewView->CreateEx(NULL, AfxRegisterWndClass(CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS), "View", WS_OVERLAPPEDWINDOW, CRect(10,10,500,500), g_MainDlg, 0);
  NewView->ViewCreate();
  
  g_ViewList.AddView(NewView);
  SetCurrentView(NewView);
  
  NewView->ShowWindow(SW_SHOW);
  
  return 1;
}

//

void doViewportFunction(MBaseViewWndPtr newView, const char *className, const char *viewName) {
  int            ViewIndex;
  MBaseViewWndPtr View, OldView;
  RECT           OldRect;
  
  ViewIndex = -1;
  for (int i=0; i<4; i++)
  {
    if (g_Views[i] == g_CurView)
      ViewIndex = i;
  }
  
  OldView = g_CurView;
  OldView->GetWindowRect(&OldRect);
  
  // If ViewIndex is -1, we are dealing with a viewport not a child to the main dialog.
  if (ViewIndex != -1) {
    newView->CreateEx(NULL, AfxRegisterWndClass(CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS), className, WS_CHILD | WS_CLIPSIBLINGS|WS_BORDER, CRect(10,10,500,500), g_MainDlg, 0);
    g_Views[ViewIndex] = newView;
    g_MainDlg->ScreenToClient(&OldRect);
  } else {
    newView->CreateEx(NULL, AfxRegisterWndClass(CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS), className, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, CRect(10,10,500,500), g_MainDlg, 0);
  }
  
  newView->ViewCreate();
  
  newView->SetViewName(viewName);
  g_ViewList.AddView(newView);
  SetCurrentView(newView);
  g_ViewList.DeleteView(OldView);
  
  newView->MoveWindow(&OldRect);
  newView->ShowWindow(SW_SHOW);
}

COpenGLWndPtr KViewportHelpCreateGL() {
  COpenGLWndPtr GLView;
  GLView = new COpenGLWnd;

  doViewportFunction(GLView, "GLView", "");

  return GLView;
}

int KViewportTop() {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(0,0,0);
  GLView->SetViewName("Top");
  GLView->SetGridBasis(MVector3(1,0,0), MVector3(0,1,0));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportFront()
{
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(-90,0,0);
  GLView->SetViewName("Front");
  GLView->SetGridBasis(MVector3(1,0,0), MVector3(0,0,1));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportRight() {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(-90,0,-90);
  GLView->SetViewName("Right");
  GLView->SetGridBasis(MVector3(0,1,0), MVector3(0,0,1));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportBottom() {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(180,0,0);
  GLView->SetViewName("Bottom");
  GLView->SetGridBasis(MVector3(1,0,0), MVector3(0,1,0));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportBack() {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(90,0,0);
  GLView->SetViewName("Back");
  GLView->SetGridBasis(MVector3(1,0,0), MVector3(0,0,1));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportLeft() {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL)
    return 0;
  
  GLView->unsetFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->m_Rot.set(-90,0,90);
  GLView->SetViewName("Left");
  GLView->SetGridBasis(MVector3(0,1,0), MVector3(0,0,1));
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}

int KViewportPerspective() {
  return KViewportPerspective(NULL);
}

int KViewportPerspective(const MSceneObjectPtr &lookThrough) {
  COpenGLWndPtr GLView;
  
  GLView = KViewportHelpCreateGL();
  
  if (GLView == NULL) {
    return 0;
  }

  GLView->camera = lookThrough;

  GLView->SetViewName("Perspective");
  
  GLView->setFlag(GLVIEW_FLAGS_PERSPECTIVE);
  GLView->SetGridBasis(MVector3(1,0,0), MVector3(0,1,0));
  GLView->m_Rot.set(-70.0f, 0, -30.0f);
  
  GLView->ShowWindow(SW_SHOW);
  
  return 1;
}


int KViewportSceneOutline() {
  doViewportFunction(new CSceneViewWnd, "SceneView", "Scene Outline");
  return 1;
}

int KViewportSegmentEditor() {
  doViewportFunction(new CSegmentViewWnd, "SegmentView", "Segment Editor");
  return 1;
}

int KViewportUVEdit() {
  doViewportFunction(new CUVEditViewWnd, "UVEditView", "UV Edit");
  return 1;
}

int KViewportGraphView() {
  doViewportFunction(new CGraphViewWnd, "GraphView", "Graph View");
  return 1;
}

int KViewportParameterView() {
  doViewportFunction(new CParameterViewWnd, "ParameterView", "Parameter View");
  return 1;
}

int KViewportImageView() {
  doViewportFunction(new ImageViewerView, "ImageViewerView", "Image View");
  return 1;
}

int KViewportRenderView() {
  // we can only change to a render view if there isn't one already visible
  MBaseViewWndPtr view = g_ViewList.FindViewOfType("RenderView");

  if (view == NULL) {
    doViewportFunction(new RenderView, "RenderView", "Render View");
  }

  return 1;
}

int KViewportFrameAll() {
  MZoomableWindow *zoom = AZTEC_CAST(MZoomableWindow, g_CurView);

  if (zoom != NULL) {
    zoom->zoomToFitAll();
    g_CurView->DrawView();
    return 1;
  }

  return 0;
}

int KViewportFrameSelected()
{
  MZoomableWindow *zoom = AZTEC_CAST(MZoomableWindow, g_CurView);

  if (zoom != NULL) {
    zoom->zoomToFitSelected();
    g_CurView->DrawView();
    return 1;
  }

  return 0;
}

int KViewportZoomOut() {
  MZoomableWindow *zoom = AZTEC_CAST(MZoomableWindow, g_CurView);

  if (zoom != NULL) {
    zoom->zoomOut();
    g_CurView->DrawView();
    return 1;
  }

  return 0;
}

int KViewportZoomIn() {
  MZoomableWindow *zoom = AZTEC_CAST(MZoomableWindow, g_CurView);

  if (zoom != NULL) {
    zoom->zoomIn();
    g_CurView->DrawView();
    return 1;
  }

  return 0;
}


int KViewportIncreaseIconSize() {
  g_IconSize *= (float)1.5;
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KViewportDecreaseIconSize() {
  g_IconSize /= (float)1.5;
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KViewportRedrawAll() {
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KViewportFullScreen() {
  MBaseViewWndPtr View;
  
  View = g_ViewList.FindViewFromHWND(g_hMouseWnd);
  
  if (View == NULL)
    View = g_CurView;
  
  if (View == NULL)
    return 0;
  
  if (View->isFlagged(GLVIEW_FLAGS_FULLSCREEN)) {
    View->unsetFlag(GLVIEW_FLAGS_FULLSCREEN);
  } else {
    View->setFlag(GLVIEW_FLAGS_FULLSCREEN);
  }
  
  SetCurrentView(View);
  g_MainDlg->DoViewPortSize();
  
  return 1;
}

int KViewportToggleGrid() {
  if (g_CurView == NULL)
    return 0;
  
  if (g_CurView->isFlagged(GLVIEW_FLAGS_DRAWGRID)) {
    g_CurView->unsetFlag(GLVIEW_FLAGS_DRAWGRID);
  } else {
    g_CurView->setFlag(GLVIEW_FLAGS_DRAWGRID);
  }
  
  g_CurView->DrawView();
  
  return 1;
}

int KSegmentViewZoomIn() {
  CSegmentViewWnd *segView = AZTEC_CAST(CSegmentViewWnd, g_CurView);

  if (segView == NULL) {
    return 0;
  }

  segView->zoomIn();

  return 1;
}

int KSegmentViewZoomOut() {
  CSegmentViewWnd *segView = AZTEC_CAST(CSegmentViewWnd, g_CurView);

  if (segView == NULL) {
    return 0;
  }

  segView->zoomOut();

  return 1;
}
